
//OpenSCADA module Special.SystemTests file: test_mess.h
/***************************************************************************
 *   Copyright (C) 2005-2022 by Roman Savochenko, <roman@oscada.org>       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef TEST_SOATTACH_H
#define TEST_SOATTACH_H

#include <tfunction.h>

namespace KernelTest
{

//*************************************************
//* TestSOAttach: Attach/Detach module test.      *
//*************************************************
class TestSOAttach : public TFunction
{
    public:
	TestSOAttach( ) : TFunction("SOAttach",SSPC_ID)
	{
	    ioAdd( new IO("rez",trS("Result"),IO::String,IO::Return) );
	    ioAdd( new IO("name",trS("Path to the module"),IO::String,IO::Default) );
	    ioAdd( new IO("mode",trS("Mode (1-attach;-1-detach;0-change)"),IO::Integer,IO::Default,"0") );
	    ioAdd( new IO("full",trS("Complete attach (when start)"),IO::Boolean,IO::Default,"1") );
	}

	string name( )	{ return _("Attaching SO"); }
	string descr( )	{ return _("Test the module to attach/detach."); }

	void calc( TValFunc *val ) {
	    try {
		mod->mess(id(),_("Test: Start"));

		SYS->modSchedul();
		string SO_name = val->getS(1);
		TModSchedul::SHD so_st = SYS->modSchedul().at().lib(SO_name);
		if(val->getI(2) > 0)		SYS->modSchedul().at().libAtt(so_st.name, val->getB(3));
		else if(val->getI(2) < 0)	SYS->modSchedul().at().libDet(so_st.name);
		else {
		    if(so_st.hd) SYS->modSchedul().at().libDet(so_st.name);
		    else SYS->modSchedul().at().libAtt(so_st.name, val->getB(3));
		}

		mod->mess(id(), _("Test: Passed"));
		val->setS(0, _("Passed"));
	    }
	    catch( TError err ) {
		mod->mess(id(), _("Test: Failed: %s"),err.mess.c_str());
		val->setS(0, TSYS::strMess(_("Failed: %s"),err.mess.c_str()));
	    }
	}
};

}

#endif //TEST_SOATTACH_H
