const char *WebVisionVCA_js=
   "\n"
   "//OpenSCADA system module UI.WebVision file: VCA.js\n"
   "/***************************************************************************\n"
   " *   Copyright (C) 2007-2025 by Roman Savochenko, <roman@oscada.org>       *\n"
   " *                                                                         *\n"
   " *   This program is free software; you can redistribute it and/or modify  *\n"
   " *   it under the terms of the GNU General Public License as published by  *\n"
   " *   the Free Software Foundation; version 2 of the License.               *\n"
   " *                                                                         *\n"
   " *   This program is distributed in the hope that it will be useful,       *\n"
   " *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *\n"
   " *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *\n"
   " *   GNU General Public License for more details.                          *\n"
   " *                                                                         *\n"
   " *   You should have received a copy of the GNU General Public License     *\n"
   " *   along with this program; if not, write to the                         *\n"
   " *   Free Software Foundation, Inc.,                                       *\n"
   " *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *\n"
   " ***************************************************************************/\n"
   "\n"
   "var MOD_ID = 'WebVision';\n"
   "var isNN = navigator.appName.indexOf('Netscape') != -1;\n"
   "var isIE = navigator.appName.indexOf('Microsoft') != -1;\n"
   "var isOpera = navigator.appName.indexOf('Opera') != -1;\n"
   "var isKonq = navigator.userAgent.indexOf('Konqueror') != -1;\n"
   "var mainTmId = 0;\n"
   "var gPrms = window.location.search || '';\n"
   "var tmClearEdit = 10;			//Time of clearing the line edit fields, seconds\n"
   "var tmConfirmEdit = 2;			//Time of confirming the line edit fields, seconds\n"
   "var tmFullUpd = 5;			//Full tree updating time, seconds\n"
   "var tmAlrmUpd = 0.5;			//Alarms updating time, seconds\n"
   "var limTblItmCnt = 300;			//Limit of the table item content\n"
   "var tblCurClr = \"lightblue\";		//Table cursor color\n"
   "var tblCurBrd = \"2px dotted red\"	//Table cursor border\n"
   "\n"
   "/***************************************************\n"
   " * pathLev - Path parsing function.                *\n"
   " ***************************************************/\n"
   "pathLev.off = 0;\n"
   "function pathLev( path, level, scan )\n"
   "{\n"
   "    var an_dir = scan ? pathLev.off : 0;\n"
   "    var t_lev = 0;\n"
   "    var t_dir;\n"
   "    while(an_dir < path.length && path.charAt(an_dir) == '/') an_dir++;\n"
   "    if(an_dir >= path.length) return '';\n"
   "    while(true) {\n"
   "	t_dir = path.indexOf('/', an_dir);\n"
   "	if(t_dir < 0)		{ pathLev.off = path.length; return (t_lev==level)?path.substr(an_dir):''; }\n"
   "	if(t_lev == level)	{ pathLev.off = t_dir; return path.substr(an_dir,t_dir-an_dir); }\n"
   "	an_dir = t_dir;\n"
   "	t_lev++;\n"
   "	while(an_dir < path.length && path.charAt(an_dir) == '/') an_dir++;\n"
   "    }\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * noSpace - Get no space (trimmed) string         *\n"
   " ***************************************************/\n"
   "function noSpace( str )\n"
   "{\n"
   "    var posSt = -1; var posEnd = 0;\n"
   "    for(var i = 0; i < str.length; i++)\n"
   "	if(str[i] != ' ') { if(posSt<0) posSt = i; posEnd = i; }\n"
   "    return (posSt>=0) ? str.substr(posSt,posEnd-posSt+1) : '';\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * i2s - integer to string                         *\n"
   " ***************************************************/\n"
   "function i2s( vl, base, len )\n"
   "{\n"
   "    rez = vl.toString(base);\n"
   "    if(len) while(rez.length < len) rez = \"0\"+rez;\n"
   "    return rez;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * posGetX - Get absolute position                 *\n"
   " **************************************************/\n"
   "function posGetX( obj, noWScrl )\n"
   "{\n"
   "    var posX = 0;\n"
   "    for( ; obj && obj.nodeName != 'BODY'; obj = obj.parentNode) {\n"
   "	posX += (obj.style.left?parseInt(obj.style.left):0)+\n"
   "	    (obj.parentNode.style.borderLeftWidth?parseInt(obj.parentNode.style.borderLeftWidth):0)+\n"
   "	    (obj.parentNode.style.marginLeft?parseInt(obj.parentNode.style.marginLeft):0);\n"
   "	if(obj.style.position == 'relative') posX += obj.offsetLeft;\n"
   "    }\n"
   "    return posX + (!noWScrl?-window.pageXOffset:0);\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * posGetY - Get absolute position                 *\n"
   " **************************************************/\n"
   "function posGetY( obj, noWScrl )\n"
   "{\n"
   "    var posY = 0;\n"
   "    for( ; obj && obj.nodeName != 'BODY'; obj = obj.parentNode) {\n"
   "	posY += (obj.style.top?parseInt(obj.style.top):0)+\n"
   "	    (obj.parentNode.style.borderTopWidth?parseInt(obj.parentNode.style.borderTopWidth):0)+\n"
   "	    (obj.parentNode.style.marginTop?parseInt(obj.parentNode.style.marginTop):0);\n"
   "	if(obj.style.position == 'relative') posY += obj.offsetTop;\n"
   "	posY -= obj.scrollTop;\n"
   "    }\n"
   "    return posY + (!noWScrl?-window.pageYOffset:0);\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * getXmlHttp - Check and return XMLHttpRequest for*\n"
   " *  various browsers.                              *\n"
   " ***************************************************/\n"
   "function getXmlHttp( )\n"
   "{\n"
   "    reqO = null;\n"
   "    if(window.XMLHttpRequest) reqO = new XMLHttpRequest();\n"
   "    else if(window.ActiveXObject) {\n"
   "	try { reqO = new ActiveXObject('Msxml2.XMLHTTP'); }\n"
   "	catch(e) { reqO = new ActiveXObject('Microsoft.XMLHTTP'); }\n"
   "    }\n"
   "\n"
   "    for(iO = 0; iO < reqObjects.length; iO++) {\n"
   "	if(reqObjects[iO] && reqObjects[iO].readyState == 4) { delete reqObjects[iO]; reqObjects[iO] = null; }\n"
   "	if(!reqObjects[iO]) { reqObjects.splice(iO, 1); iO--; }\n"
   "    }\n"
   "\n"
   "    reqObjects.push(reqO);\n"
   "\n"
   "    return reqO;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * realRound - Real numbers round                  *\n"
   " ***************************************************/\n"
   "function realRound( val, dig, toInt )\n"
   "{\n"
   "    var rrRez = Math.floor(val*Math.pow(10,dig?dig:0)+0.5)/Math.pow(10,dig?dig:0);\n"
   "    if(toInt) return Math.floor(rrRez+0.5);\n"
   "    return rrRez;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * evMouseGet - Get mouse key code from event      *\n"
   " ***************************************************/\n"
   "function evMouseGet( e )\n"
   "{\n"
   "    if(e.which == 1)		return 'Left';\n"
   "    else if(e.which == 2)	return 'Midle';\n"
   "    else if(e.which == 3)	return 'Right';\n"
   "    return '';\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * evKeyGet - Get key code from event              *\n"
   " ***************************************************/\n"
   "function evKeyGet( e )\n"
   "{\n"
   "    if((e.keyCode >= 48 && e.keyCode <= 57) || (e.keyCode >= 65 && e.keyCode <= 90))\n"
   "	return String.fromCharCode(e.keyCode);\n"
   "    switch(e.keyCode) {\n"
   "	case 27: return 'Esc';\n"
   "	case 8:  return 'BackSpace';\n"
   "	case 13: return 'Enter';\n"
   "	case 45: return 'Insert';\n"
   "	case 19: return 'Pause';\n"
   "	case 36: return 'Home';\n"
   "	case 35: return 'End';\n"
   "	case 37: return 'Left';\n"
   "	case 38: return 'Up';\n"
   "	case 39: return 'Right';\n"
   "	case 40: return 'Down';\n"
   "	case 33: return 'PageUp';\n"
   "	case 34: return 'PageDown';\n"
   "	case 112: return 'F1';\n"
   "	case 113: return 'F2';\n"
   "	case 114: return 'F3';\n"
   "	case 115: return 'F4';\n"
   "	case 116: return 'F5';\n"
   "	case 117: return 'F6';\n"
   "	case 118: return 'F7';\n"
   "	case 119: return 'F8';\n"
   "	case 120: return 'F9';\n"
   "	case 121: return 'F10';\n"
   "	case 122: return 'F11';\n"
   "	case 123: return 'F12';\n"
   "	case 32: return 'Space';\n"
   "	case 59: return 'Semicolon';\n"
   "	case 61: return 'Equal';\n"
   "    }\n"
   "    if(isNN) switch(e.keyCode) {\n"
   "	case 46: return 'Delete';\n"
   "	case 44: return 'Print';\n"
   "	case 192: return 'Apostrophe';\n"
   "	case 106: return 'Asterisk';\n"
   "	case 107: return 'Plus';\n"
   "	case 188: return 'Comma';\n"
   "	case 109: return 'Minus';\n"
   "	case 190: return 'Period';\n"
   "	case 220: return 'Slash';\n"
   "	case 219: return 'BracketLeft';\n"
   "	case 191: return 'BackSlash';\n"
   "	case 221: return 'BracketRight';\n"
   "	case 222: return 'QuoteLeft';\n"
   "    }\n"
   "    else switch(e.keyCode) {\n"
   "	case 127: return 'Delete';\n"
   "	case 96: return 'Apostrophe';\n"
   "	case 42: return 'Asterisk';\n"
   "	case 43: return 'Plus';\n"
   "	case 44: return 'Comma';\n"
   "	case 45: return 'Minus';\n"
   "	case 46: return 'Period';\n"
   "	case 92: return 'Slash';\n"
   "	case 91: return 'BracketLeft';\n"
   "	case 47: return 'BackSlash';\n"
   "	case 93: return 'BracketRight';\n"
   "	case 39: return 'QuoteLeft';\n"
   "    }\n"
   "    return '#'+e.keyCode.toString(16);\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * servGet - XML get request to server             *\n"
   " ***************************************************/\n"
   "function servGet( adr, prm, callBack, callBackPrm )\n"
   "{\n"
   "    var req = getXmlHttp();\n"
   "    req.open('GET', encodeURI('/'+MOD_ID+adr+(gPrms.length?gPrms+'&':'?')+prm), callBack ? true : false);\n"
   "    if(callBack) {\n"
   "	req.callBack = callBack;\n"
   "	req.callBackPrm = callBackPrm;\n"
   "	req.responseXML = null;\n"
   "	req.onreadystatechange = function( ) {\n"
   "	    if(this.readyState != 4) return;\n"
   "	    if(this.status != 200) window.location.reload();\n"
   "	    else if(this.responseXML && this.responseXML.childNodes && this.responseXML.childNodes.length) {\n"
   "		this.responseXML.childNodes[0].callBackPrm = this.callBackPrm;\n"
   "		this.callBack(this.responseXML.childNodes[0]);\n"
   "	    }\n"
   "	    else this.callBack(-1);\n"
   "	};\n"
   "	req.send(null);\n"
   "	return null;\n"
   "    }\n"
   "    req.send(null);\n"
   "    if(req.status != 200) window.location.reload();\n"
   "    else if(req.responseXML.childNodes.length)	return req.responseXML.childNodes[0];\n"
   "\n"
   "    return null;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * servSet - XML set request to server             *\n"
   " ***************************************************/\n"
   "function servSet( adr, prm, body, noWaitRez )\n"
   "{\n"
   "    if(noWaitRez == null) noWaitRez = false;	//!!!! Otherwise we can get of processing old events after new ones\n"
   "    var req = getXmlHttp();\n"
   "    req.open('POST', encodeURI('/'+MOD_ID+adr+(gPrms.length?gPrms+'&':'?')+prm), noWaitRez);\n"
   "    try {\n"
   "	req.responseXML = null;\n"
   "	req.send(body);\n"
   "	if(!noWaitRez && req.status == 200 && req.responseXML.childNodes.length)\n"
   "	    return req.responseXML.childNodes[0];\n"
   "	else if(req.status == 404) window.location.reload();\n"
   "	//if(mainTmId) clearTimeout(mainTmId);\n"
   "	//mainTmId = setTimeout(makeUI, 1000);\n"
   "    } catch(e) { window.location.reload(); /*window.location = '/'+MOD_ID;*/ }\n"
   "\n"
   "    return null;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * getWAttr - request page/widget attribute        *\n"
   " ***************************************************/\n"
   "function getWAttr( wId, attr )\n"
   "{\n"
   "    var rNode = servGet(wId, 'com=attr&attr='+attr);\n"
   "    if(!rNode) return null;\n"
   "\n"
   "    return rNode.textContent;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * setWAttrs - set page/widget attributes          *\n"
   " ***************************************************/\n"
   "function setWAttrs( wId, attrs, val )\n"
   "{\n"
   "    var body = '<set>';\n"
   "    if(typeof(attrs) == 'string')\n"
   "	body += '<el id=\\''+attrs+'\\'>'+((typeof(val)=='string')?val.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;'):val)+'</el>';\n"
   "    else for(var i in attrs)\n"
   "	body += '<el id=\\''+i+'\\'>'+((typeof(attrs[i])=='string')?attrs[i].replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;'):attrs[i])+'</el>';\n"
   "    body += '</set>';\n"
   "\n"
   "    servSet(wId, 'com=attrs', body);\n"
   "\n"
   "    toFastCycle = true;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * getFont( fStr, fSc, opt ) - Parse font          *\n"
   " *  opt - options: 1-punkts; 2-return size         *\n"
   " ***************************************************/\n"
   "function getFont( fStr, fSc, opt )\n"
   "{\n"
   "    var rez = '';\n"
   "    if(fStr) {\n"
   "	var allFnt = fStr.split(' ');\n"
   "	if(opt == 2) return (parseInt(allFnt[1])*(fSc?fSc:1)).toFixed(0);\n"
   "	if(allFnt.length >= 1) rez += 'font-family: ' + allFnt[0].replace(/_/g,' ') + '; ';\n"
   "	if(allFnt.length >= 2) rez += 'font-size: ' + (parseInt(allFnt[1])*(fSc?fSc:1)).toFixed(0) + (opt==1?'pt; ':'px; ');\n"
   "	if(allFnt.length >= 3) rez += 'font-weight: ' + (parseInt(allFnt[2])?'bold':'normal') + '; ';\n"
   "	if(allFnt.length >= 4) rez += 'font-style: ' + (parseInt(allFnt[3])?'italic':'normal') + '; ';\n"
   "	if(allFnt.length >= 5 && parseInt(allFnt[4])) rez += 'text-decoration: underline; ';\n"
   "	else if(allFnt.length >= 6 && parseInt(allFnt[5])) rez += 'text-decoration: line-through; ';\n"
   "    }\n"
   "\n"
   "    return rez;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * getFontCond( fStr, fSc, opt ) - Parse font          *\n"
   " *  opt - options: 1-punkts; 2-return size         *\n"
   " ***************************************************/\n"
   "function getFontCond( fStr, fSc, opt )\n"
   "{\n"
   "    fontCfg = \"\";\n"
   "    if(fStr) {\n"
   "	allFnt = fStr.split(\" \");\n"
   "	if(allFnt.length >= 3 && parseInt(allFnt[2])) fontCfg += \"bold \";\n"
   "	if(allFnt.length >= 4 && parseInt(allFnt[3])) fontCfg += \"italic \";\n"
   "	if(allFnt.length >= 2) fontCfg += (parseInt(allFnt[1])*(fSc?fSc:1)).toFixed(0) + (opt==1?\"pt \":\"px \");\n"
   "	if(allFnt.length >= 1) fontCfg += allFnt[0].replace(/_/g,\" \") + \" \";\n"
   "    }\n"
   "\n"
   "    return fontCfg;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * getColor - Parse color                          *\n"
   " ***************************************************/\n"
   "function getColor( cStr, getOpacity )\n"
   "{\n"
   "    var sPos = cStr.indexOf('-');\n"
   "    var sOp  = (sPos >= 0) ? Math.max(0,Math.min(255,parseFloat(cStr.slice(sPos+1))/255)) : 1;\n"
   "    var sClr = (sPos >= 0) ? cStr.slice(0,sPos) : cStr;\n"
   "\n"
   "    //Only for transparency\n"
   "    if(sOp < 1) {\n"
   "	if(sClr[0] == '#') {	// Conversion to RGBA\n"
   "	    var iClr = parseInt(sClr.slice(1), 16);\n"
   "	    sClr = \"rgba(\"+((iClr>>16)&0xFF)+\",\"+((iClr>>8)&0xFF)+\",\"+(iClr&0xFF)+\",\"+sOp.toFixed(2)+\")\";\n"
   "	} else sClr = \"color-mix(in srgb, \"+sClr+\", transparent \"+Math.floor((1-sOp)*100)+\"%)\";\n"
   "	sOp = 1;	//For separate opacity requesting\n"
   "    }\n"
   "\n"
   "    return getOpacity ? sOp : sClr;\n"
   "}\n"
   "\n"
   "/*****************************************************\n"
   " * chkPattern - Check for allow expression to pattern *\n"
   " *****************************************************/\n"
   "function chkPattern( val, patt )\n"
   "{\n"
   "    //Check by regular expression\n"
   "    if(patt.length > 2 && patt.charAt(0) == '/' && patt.charAt(patt.length-1) == '/')\n"
   "	return (new RegExp(patt.slice(1,patt.length-1),'')).test(val);\n"
   "\n"
   "    //Check by simple pattern\n"
   "    var mult_s = false;\n"
   "    var v_cnt = 0, p_cnt = 0;\n"
   "    var v_bck = -1, p_bck = -1;\n"
   "\n"
   "    while(true) {\n"
   "	if(p_cnt >= patt.length)	return true;\n"
   "	if(patt.charAt(p_cnt) == '?')	{ v_cnt++; p_cnt++; mult_s = false; continue; }\n"
   "	if(patt.charAt(p_cnt) == '*')	{ p_cnt++; mult_s = true; v_bck = -1; continue; }\n"
   "	if(patt.charAt(p_cnt) == '\\\\')	p_cnt++;\n"
   "	if(v_cnt >= val.length)	break;\n"
   "	if(patt.charAt(p_cnt) == val.charAt(v_cnt)) {\n"
   "	    if(mult_s && v_bck < 0)	{ v_bck = v_cnt+1; p_bck = p_cnt; }\n"
   "	    v_cnt++; p_cnt++;\n"
   "	}\n"
   "	else {\n"
   "	    if(mult_s) {\n"
   "		if(v_bck >= 0) { v_cnt = v_bck; p_cnt = p_bck; v_bck = -1; }\n"
   "		else v_cnt++;\n"
   "	    }\n"
   "	    else break;\n"
   "	}\n"
   "    }\n"
   "    return false;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * getTabIndex - Calculate the absolute tab index  *\n"
   " ***************************************************/\n"
   "function getTabIndex( wdgO, origPos )\n"
   "{\n"
   "    for(pow = 1, curPar = wdgO.parent; curPar; curPar = curPar.parent)\n"
   "	if(curPar.wPos >= 0) { origPos += curPar.wPos*Math.pow(100,pow); pow++; }\n"
   "\n"
   "    return origPos;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * setFocus - Command for set focus                *\n"
   " ***************************************************/\n"
   "function setFocus( wdg, ack, focusElem, onlySet )\n"
   "{\n"
   "    if(masterPage.focusWdf == wdg) return;\n"
   "    if(onlySet) { masterPage.focusWdf = wdg; return; }\n"
   "    if(focusElem) focusElem.focus();\n"
   "\n"
   "    var attrs = new Object();\n"
   "    if(masterPage.focusWdf) {\n"
   "	attrs.focus = '0'; attrs.event = 'ws_FocusOut';\n"
   "	setWAttrs(masterPage.focusWdf, attrs);\n"
   "    }\n"
   "    if(ack) masterPage.focusWdf = wdg;\n"
   "    attrs.focus = '1'; attrs.event = 'ws_FocusIn';\n"
   "    setWAttrs(wdg, attrs);\n"
   "}\n"
   "\n"
   "/****************************************************************************\n"
   " * PageObj pgCacheGet( addr ) - Getting for the page <addr> from the cache. *\n"
   " *   addr - address of the page.                                            *\n"
   " ***************************************************************************/\n"
   "function pgCacheGet( addr )\n"
   "{\n"
   "    for(iPg = 0; iPg < pgCache.length; iPg++)\n"
   "	if(pgCache[iPg].addr == addr)\n"
   "	    return pgCache.splice(iPg,1)[0];\n"
   "    return null;\n"
   "}\n"
   "\n"
   "/*********************************************************************\n"
   " * pgCacheProc( page ) - Processing the cache for the <page> or      *\n"
   " *     the lifetime fo null <page>                                   *\n"
   " *   addr - address of the page.                                     *\n"
   " *********************************************************************/\n"
   "function pgCacheProc( page )\n"
   "{\n"
   "    if(page) { pgCache.unshift(page); page.cacheTm = (new Date()).getTime()/1000; }\n"
   "    //Removing the limited pages\n"
   "    for(iPg = pgCache.length-1; iPg >= 0; iPg--)\n"
   "	if((cachePgLife > 0.01 && ((((new Date()).getTime()/1000)-pgCache[iPg].cacheTm) > cachePgLife*60*60)) ||\n"
   "		(cachePgSz && pgCache.length > cachePgSz))\n"
   "	    delete pgCache.splice(iPg,1)[0];\n"
   "	else break;\n"
   "}\n"
   "\n"
   "/**********************************************************\n"
   " * callPage - call page 'pgId' for open update and other. *\n"
   " **********************************************************/\n"
   "function callPage( pgId, updWdg, pgGrp, pgOpenSrc )\n"
   "{\n"
   "    if(!pgId) return true;\n"
   "\n"
   "    //Checking and updating the presented pages\n"
   "    if(this == masterPage)\n"
   "	if((opPg=this.findOpenPage(pgId))) {\n"
   "	    opPg.fullUpdCnt = opPg.fullUpdCnt ? Math.max(0,opPg.fullUpdCnt-planePer) : tmFullUpd;\n"
   "	    if(updWdg || !opPg.fullUpdCnt)\n"
   "		servGet(pgId, 'com=attrsBr&FullTree='+(opPg.fullUpdCnt?'':'1')+'&tm='+tmCnt, makeEl, opPg);\n"
   "	    return true;\n"
   "	}\n"
   "\n"
   "    //Checking pages before opening\n"
   "    if(!pgGrp || !pgOpenSrc) {\n"
   "	reqPgGen = \"<CntrReqs>\"+\n"
   "	    \"<get path='/%2fattr%2fpgGrp'/>\"+\n"
   "	    \"<get path='/%2fattr%2fpgOpenSrc'/>\";\n"
   "	// For per-page notification\n"
   "	for(iNtf = 0; iNtf < 8; iNtf++)\n"
   "	    reqPgGen += \"<activate path='/%2fserv%2fattr%2fnotify\"+iNtf+\"'/>\"+\n"
   "			\"<activate path='/%2fserv%2fattr%2fnotifyVis\"+MOD_ID+iNtf+\"'/>\";\n"
   "	reqPgGen += \"</CntrReqs>\";\n"
   "	reqPgGen = servSet(\"/UI/VCAEngine\"+pgId, 'com=com', reqPgGen, false);\n"
   "	pgGrp = reqPgGen.childNodes[0].textContent;\n"
   "	pgOpenSrc = reqPgGen.childNodes[1].textContent;\n"
   "    }\n"
   "\n"
   "    //Creating/replacing the main page\n"
   "    if(this == masterPage && (!this.addr.length || pgGrp == 'main' || !pgGrp.length || pgGrp == this.attrs['pgGrp'])) {\n"
   "	if(this.addr.length) {\n"
   "	    servSet(this.addr, 'com=pgClose&cacheCntr', '');\n"
   "	    this.pwClean(true);\n"
   "	    document.body.removeChild(this.window);\n"
   "	}\n"
   "	this.addr  = pgId;\n"
   "	this.place = document.createElement('div');\n"
   "	this.place.setAttribute('id', 'mainCntr');\n"
   "\n"
   "	//Get and activate for specific attributes to the master-page\n"
   "	servSet(\"/UI/VCAEngine\"+this.addr, 'com=com', \"<CntrReqs>\"+\n"
   "	    \"<activate path='/%2fserv%2fattr%2fkeepAspectRatio' aNm='Keep aspect ratio on scale' aTp='0' />\"+\n"
   "	    \"<activate path='/%2fserv%2fattr%2fstBarNoShow' aNm='Do not show the status bar' aTp='0' />\"+\n"
   "	    \"<activate path='/%2fserv%2fattr%2fstatLine' />\"+\n"
   "	    \"<activate path='/%2fserv%2fattr%2fuserSetVis' />\"+\n"
   "	    \"<activate path='/%2fserv%2fattr%2fprjDoc' />\"+\n"
   "	    \"</CntrReqs>\");\n"
   "\n"
   "	this.makeEl(servGet(pgId,'com=attrsBr'), false, true);\n"
   "	var centerTag = document.createElement('center');\n"
   "	centerTag.appendChild(this.place);\n"
   "	document.body.appendChild(centerTag);\n"
   "	this.window = centerTag;\n"
   "	//Set project's icon and RunTime page title\n"
   "	document.getElementsByTagName('link')[0].setAttribute('href',location.pathname+'?com=ico');\n"
   "	return true;\n"
   "    }\n"
   "\n"
   "    //Find for included pages creation\n"
   "    for(var i in this.wdgs)\n"
   "	if(this.wdgs[i].attrs['root'] == 'Box' && this.wdgs[i].isVisible) {\n"
   "	    if(pgGrp == this.wdgs[i].attrs['pgGrp']) {\n"
   "		if(pgId != this.wdgs[i].attrs['pgOpenSrc']) {\n"
   "		    //this.wdgs[i].attrs['pgOpenSrc'] = pgId;\n"
   "		    //this.wdgs[i].makeEl(null, true);\n"
   "		    // Changing the pages only through 'pgOpenSrc' but the source page direct update may cause collisions on fast switching\n"
   "		    setWAttrs(this.wdgs[i].addr, 'pgOpenSrc', pgId);\n"
   "		}\n"
   "		return true;\n"
   "	    }\n"
   "	    if(this.wdgs[i].inclOpen && this.wdgs[i].pages[this.wdgs[i].inclOpen].callPage(pgId,updWdg,pgGrp,pgOpenSrc)) return true;\n"
   "	}\n"
   "    //Put checking to child pages\n"
   "    for(var i in this.pages)\n"
   "	if(this.pages[i].callPage(pgId,updWdg,pgGrp,pgOpenSrc)) return true;\n"
   "    //Check for open child page or for unknown and empty source pages open as master page child windows\n"
   "    if((!pgGrp.length && pgOpenSrc == this.addr) || this == masterPage) {\n"
   "	var iPg = new pwDescr(pgId, true, this);\n"
   "	var attrBrVal = servGet(pgId, 'com=attrsBr');\n"
   "\n"
   "	var winName = null;\n"
   "	var winWidth = 600;\n"
   "	var winHeight = 400;\n"
   "	for(var iCh = 0; iCh < attrBrVal.childNodes.length; iCh++)\n"
   "	    if(attrBrVal.childNodes[iCh].nodeName != 'el') continue;\n"
   "	    else if(attrBrVal.childNodes[iCh].getAttribute('id') == 'name') winName = attrBrVal.childNodes[iCh].textContent;\n"
   "	    else if(attrBrVal.childNodes[iCh].getAttribute('id') == 'geomW') winWidth = parseInt(attrBrVal.childNodes[iCh].textContent);\n"
   "	    else if(attrBrVal.childNodes[iCh].getAttribute('id') == 'geomH') winHeight = parseInt(attrBrVal.childNodes[iCh].textContent);\n"
   "\n"
   "	//New external <div> window create\n"
   "	if(winWidth < parseInt(masterPage.attrs['geomW']) && winHeight < parseInt(masterPage.attrs['geomH'])) {\n"
   "	    iPg.window = document.createElement('table');\n"
   "	    iPg.window.iPg = iPg;\n"
   "	    iPg.window.id = \"gen-pnl-dlg\";\n"
   "	    iPg.window.setAttribute('cellspacing', '0');\n"
   "	    iPg.window.setAttribute('style','left: '+((parseInt(masterPage.attrs['geomW'])-winWidth-5)/2)+'px; '+\n"
   "					    'top: '+((parseInt(masterPage.attrs['geomH'])-winHeight-18)/2)+'px; ');\n"
   "	    iPg.window.innerHTML = \"<tr class='hd' onmousedown='this.clX = event.clientX; this.clY = event.clientY; return false;' \"+\n"
   "		\"onmouseup='this.clX = this.clY = null; return false;' onmouseout='this.onmouseup()' \"+\n"
   "		\"onmousemove='if(this.clX != null) { \"+\n"
   "		\" this.offsetParent.style.left = (parseInt(this.offsetParent.style.left)+event.clientX-this.clX)+\\\"px\\\"; \"+\n"
   "		\" this.offsetParent.style.top  = (parseInt(this.offsetParent.style.top)+event.clientY-this.clY)+\\\"px\\\"; \"+\n"
   "		\" this.clX = event.clientX; this.clY = event.clientY; }'>\"+\n"
   "		\" <td title='\"+winName+\"' style='padding-left: 5px; overflow: hidden; white-space: nowrap;'>\"+winName+\"</td>\"+\n"
   "		\" <td style='color: red; cursor: pointer; text-align: right; width: 1px;' \"+\n"
   "		\"  onclick='servSet(this.offsetParent.iPg.addr,\\\"com=pgClose&cacheCntr\\\",\\\"\\\"); \"+\n"
   "		\"   /*this.offsetParent.iPg.pwClean(); \"+	//!!!! Commented to prevent the flicking\n"
   "		\"   delete this.offsetParent.iPg.parent.pages[this.offsetParent.iPg.addr]; \"+\n"
   "		\"   document.getElementById(\\\"mainCntr\\\").removeChild(this.offsetParent.iPg.window);*/'>X</td></tr>\\n\"+\n"
   "		\"<tr><td colspan='2'><div/></td></tr>\";\n"
   "	    document.getElementById('mainCntr').appendChild(iPg.window);\n"
   "	    iPg.place = iPg.window.rows[1].cells[0].children[0];\n"
   "	}\n"
   "	//New external window create\n"
   "	else {\n"
   "	    iPg.window = window.open('about:blank',pgId,'width='+(winWidth+20)+',height='+(winHeight+60)+\n"
   "		',directories=no,menubar=no,toolbar=no,scrollbars=yes,dependent=yes,location=no,locationbar=no,status=no,statusbar=no,alwaysRaised=yes');\n"
   "	    if(!iPg.window) return true;\n"
   "	    iPg.window.document.open();\n"
   "	    iPg.window.document.write(\"<html><body style='background-color: #E6E6E6;'><center><div id='main'/></center></body></html>\\n\");\n"
   "	    iPg.window.document.close();\n"
   "	    iPg.window.document.title = winName;\n"
   "	    var mainDiv = iPg.window.document.getElementById('main');\n"
   "	    iPg.place = mainDiv;\n"
   "	    iPg.windowExt = true;\n"
   "	}\n"
   "\n"
   "	this.pages[iPg.addr] = iPg;\n"
   "	iPg.makeEl(attrBrVal, false, true);\n"
   "\n"
   "	return true;\n"
   "    }\n"
   "\n"
   "  return false;\n"
   "}\n"
   "\n"
   "function findOpenPage( pgId )\n"
   "{\n"
   "    var opPg;\n"
   "    if(pgId == this.addr) return this;\n"
   "    //Check from included widgets\n"
   "    for(var i in this.wdgs)\n"
   "	if(this.wdgs[i].attrs['root'] == 'Box' && this.wdgs[i].isVisible) {\n"
   "	    if(pgId == this.wdgs[i].attrs['pgOpenSrc']) return this.wdgs[i].pages[pgId];\n"
   "	    if(this.wdgs[i].inclOpen) {\n"
   "		opPg = this.wdgs[i].pages[this.wdgs[i].inclOpen].findOpenPage(pgId);\n"
   "		if(opPg) return opPg;\n"
   "	    }\n"
   "	}\n"
   "    //Put checking to child pages\n"
   "    for(var i in this.pages) {\n"
   "	opPg = this.pages[i].findOpenPage(pgId);\n"
   "	if(opPg) return opPg;\n"
   "    }\n"
   "\n"
   "    return null;\n"
   "}\n"
   "\n"
   "function makeEl( pgBr, inclPg, full, FullTree )\n"
   "{\n"
   "    //Callback processing\n"
   "    if(pgBr) {\n"
   "	if(pgBr == -1) { window.location.reload(true); return; }	//Try to restore the connection\n"
   "	if(pgBr.getAttribute('FullTree')) FullTree = parseInt(pgBr.getAttribute('FullTree'));\n"
   "	if(pgBr.callBackPrm) {\n"
   "	    elO = pgBr.callBackPrm; pgBr.callBackPrm = null;\n"
   "	    elO.makeEl(pgBr, inclPg, full, FullTree);\n"
   "	    return;\n"
   "	}\n"
   "    }\n"
   "\n"
   "    //Main processing\n"
   "    var margBrdUpd = false; var newAttr = false;\n"
   "    this.place.wdgLnk = this;\n"
   "    if(!inclPg && pgBr) {\n"
   "	//Clear modify flag for all\n"
   "	for(var aId in this.attrsMdf) this.attrsMdf[aId] = false;\n"
   "	//Updated attributes\n"
   "	for(var iCh = 0; iCh < pgBr.childNodes.length; iCh++) {\n"
   "	    if(pgBr.childNodes[iCh].nodeName != 'el') continue;\n"
   "	    var aId = pgBr.childNodes[iCh].getAttribute('id');\n"
   "	    if((aId == 'bordWidth' || aId == 'geomMargin') && (!this.attrs[aId] || this.attrs[aId] != pgBr.childNodes[iCh].textContent)) margBrdUpd = true;\n"
   "	    this.attrsMdf[aId] = !this.attrs[aId] || this.attrs[aId] != pgBr.childNodes[iCh].textContent;\n"
   "	    if(this.attrsMdf[aId]) { this.attrs[aId] = pgBr.childNodes[iCh].textContent; newAttr = true; }\n"
   "	}\n"
   "    }\n"
   "\n"
   "    if(newAttr || inclPg || !pgBr) {\n"
   "	var elWr = (parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR);\n"
   "	var elMargin = parseInt(this.attrs['geomMargin']);\n"
   "	var elBorder = 0;\n"
   "	if(this.attrs['bordWidth']) elBorder = parseInt(this.attrs['bordWidth']);\n"
   "	var elStyle = '';\n"
   "	this.isVisible = true;\n"
   "	if(!(parseInt(this.attrs['en']) && (this.pg || parseInt(this.attrs['perm'])&SEC_RD)))\n"
   "	{ elStyle += 'visibility: hidden; '; this.isVisible = false; }\n"
   "	var geomX = parseFloat(this.attrs['geomX']);\n"
   "	var geomY = parseFloat(this.attrs['geomY']);\n"
   "	if(this.pg) { geomX = geomY = 0; elStyle += 'overflow: hidden; '; }\n"
   "	else { geomX *= this.parent.xScale(true); geomY *= this.parent.yScale(true); }\n"
   "	if(this.parent && !(this.pg && this.parent.pg)) {\n"
   "	    geomX -= parseInt(this.parent.attrs['geomMargin'])+parseInt(this.parent.attrs['bordWidth']);\n"
   "	    geomY -= parseInt(this.parent.attrs['geomMargin'])+parseInt(this.parent.attrs['bordWidth']);\n"
   "	}\n"
   "	elStyle += 'position: '+((this==masterPage || this.window)?'relative':'absolute')+'; '+\n"
   "		   'left: '+realRound(geomX)+'px; top: '+realRound(geomY)+'px; '+\n"
   "		   'pointer-events: '+((elWr||this == masterPage||\n"
   "					    (this.attrs['tipTool']&&this.attrs['tipTool'].length)||\n"
   "					    (this.attrs['tipStatus']&&this.attrs['tipStatus'].length))?'all':'none')+'; ';\n"
   "\n"
   "	// Calculation of the main window/page scale\n"
   "	if(this == masterPage) {\n"
   "	    sesUser = pgBr.getAttribute('user');\n"
   "\n"
   "	    //  Own status bar reserve\n"
   "	    var toCrtStBar = false;\n"
   "	    if(!parseInt(this.attrs[\"stBarNoShow\"]) && !masterPage.status) {\n"
   "		masterPage.status = document.createElement('div');\n"
   "		masterPage.status.srcHeight = 25;\n"
   "		masterPage.status.setAttribute('id', 'gen-pnl-status');\n"
   "		this.place.appendChild(masterPage.status);\n"
   "		toCrtStBar = true;\n"
   "	    }\n"
   "\n"
   "	    var geomW = parseFloat(this.attrs['geomW']);\n"
   "	    var geomH = parseFloat(this.attrs['geomH']);\n"
   "	    if(window.devicePixelRatio && window.devicePixelRatio != 1)	wx_scale = wy_scale = 1;\n"
   "	    else {\n"
   "		wx_scale = Math.max(1, window.innerWidth/geomW);\n"
   "		wy_scale = Math.max(1, window.innerHeight/(geomH+(masterPage.status?masterPage.status.srcHeight:0)));\n"
   "	    }\n"
   "	    if(parseInt(this.attrs['keepAspectRatio']))\n"
   "		wx_scale = wy_scale = Math.min(wx_scale, wy_scale);\n"
   "\n"
   "	    if(masterPage.status) {\n"
   "		masterPage.status.height = Math.floor(masterPage.status.srcHeight*wy_scale);\n"
   "		masterPage.status.style.top = Math.floor(geomH*wy_scale)+\"px\";\n"
   "		masterPage.status.style.width = (Math.floor(geomW*wx_scale)-5)+\"px\";\n"
   "		masterPage.status.style.height = (masterPage.status.height-1)+\"px\";\n"
   "		masterPage.status.style.fontSize = Math.floor(masterPage.status.height*0.7)+\"px\";\n"
   "\n"
   "		//  Status creation\n"
   "		if(toCrtStBar) {\n"
   "		    stBar = \"<table width='100%'><TR><td id='StatusBar' width='100%'/>\";\n"
   "		    if(this.attrs['statLine'] != null)\n"
   "			stBar += \"<td id='st_userFlds' class='vertalign' title='###User status fields.###' style='padding-left: 2px; padding-right: 2px;'/>\";\n"
   "		    stBar += \"<td id='st_man' title='###Field of getting the project manual.###'>\"+\n"
   "				\"<a href='\"+location.pathname+\"?com=manual' target='_blank'>\"+\n"
   "				    \"<img height='\"+(masterPage.status.height-2)+\"px' src='/\"+MOD_ID+\"/img_manual'/></a></td>\";\n"
   "		    stBar += \"<td id='st_export' title='###Field for printing and exporting data.###'>\"+\n"
   "			     \"<img onclick='printElData(event)' height='\"+(masterPage.status.height-2)+\"px' src='/\"+MOD_ID+\"/img_print' style='cursor: pointer;'/>\"+\n"
   "			     \"<img onclick='exportElData(event)' height='\"+(masterPage.status.height-2)+\"px' src='/\"+MOD_ID+\"/img_export' style='cursor: pointer;'/></td>\";\n"
   "		    stBar += \"<td id='st_alarm' title1='###Alarm level: %1###'>\"+\n"
   "			     \"<img id='alarmLev' onclick='alarmQuiet(this.id)' height='\"+(masterPage.status.height-2)+\"px' src='/\"+MOD_ID+\"/img_alarmLev'/></td>\";\n"
   "		    if(modelStyles && parseInt(modelStyles.getAttribute('curStlId')) >= 0 && modelStyles.childNodes.length > 1) {\n"
   "			stBar += \"<td id='st_style' title='###Field for displaying and changing the used interface style.###'>\";\n"
   "			stBar += \"<select onchange='styleSet(this.selectedOptions[0].getAttribute(\\\"itId\\\"))'>\";\n"
   "			for(iSt = 0; iSt < modelStyles.childNodes.length; iSt++) {\n"
   "			    if(parseInt(modelStyles.childNodes[iSt].getAttribute(\"id\")) < 0) continue;\n"
   "			    stBar += \"<option itId='\"+modelStyles.childNodes[iSt].getAttribute(\"id\")+\"' \"+\n"
   "				((modelStyles.childNodes[iSt].getAttribute(\"id\")==modelStyles.getAttribute('curStlId'))?\"selected='1'\":\"\")+\">\"+\n"
   "				    modelStyles.childNodes[iSt].textContent+\"</option>\";\n"
   "			}\n"
   "			stBar += \"</select></td>\";\n"
   "		    }\n"
   "		    stBar += \"<td id='st_user' title='###Field for displaying and changing the current user.###'><a href='/login\"+window.location.pathname+\"'>\"+sesUser+\"</a></td>\";\n"
   "		    stBar += \"</TR></table>\";\n"
   "		    masterPage.status.innerHTML = stBar;\n"
   "		}\n"
   "		elStyle += \"overflow: visible; \";\n"
   "\n"
   "		//  Status updating\n"
   "		if((tVl=this.attrs['prjDoc']) != null && this.attrsMdf['prjDoc']) {\n"
   "		    var st_man = masterPage.status.firstChild.rows[0].cells['st_man'];\n"
   "		    st_man.style.visibility = tVl.length ? 'visible' : 'hidden';\n"
   "		    st_man.firstChild.href = ((tVl=tVl.split('|')).length >= 2 && tVl[1].length)\n"
   "						? \"http://oscada.org/wiki/Special:MyLanguage/\"+tVl[1]\n"
   "						: location.pathname+\"?com=manual\"+(tVl[0].length?\"&doc=\"+tVl[0]:\"\");\n"
   "		}\n"
   "		if((tVl=this.attrs['statLine']) != null && this.attrsMdf['statLine']) {\n"
   "		    var st_userFlds = masterPage.status.firstChild.rows[0].cells['st_userFlds'];\n"
   "		    tVl = tVl.split('\\n');\n"
   "		    tVl2 = \"\";\n"
   "		    for(var i = 0; i < tVl.length; i++) {\n"
   "			if((tVl3=tVl[i].split(':')).length < 2)	continue;\n"
   "			if(tVl3.length < 4 || !tVl3[3].length) tVl3[3] = \"black\";\n"
   "			if(tVl3.length < 5) tVl3[4] = \"\";\n"
   "			tVl4 =	\"id='\"+tVl3[0]+\"' style='color: \"+tVl3[3]+\"; border: 1px solid \"+tVl3[3]+\"; ' \"+\n"
   "				\"onmousedown='setWAttrs(masterPage.addr,\\\"event\\\",\\\"key_mousePres\\\"+evMouseGet(event)+\\\":/stIt_\\\"+this.id);' \"+\n"
   "				\"onmouseup='setWAttrs(masterPage.addr,\\\"event\\\",\\\"key_mouseRels\\\"+evMouseGet(event)+\\\":/stIt_\\\"+this.id);' \"+\n"
   "				\"ondblclick='setWAttrs(masterPage.addr,\\\"event\\\",\\\"key_mouseDblClick:/stIt_\\\"+this.id);' \";\n"
   "			if(tVl3.length >= 3 && tVl3[2].length) tVl4 += \"title='\"+tVl3[2]+\"' \";\n"
   "			tVl2 += (tVl3.length >= 2 && tVl3[1].length)\n"
   "				? \"<span \"+tVl4+\">\"+tVl3[1]+\"</span>\"\n"
   "				: \"<img \"+tVl4+\"height='\"+(masterPage.status.height-4)+\"px' src='/\"+MOD_ID+this.addr+\"?com=res&val=\"+tVl3[4].replace(/ /g,'%20')+\"' />\";\n"
   "		    }\n"
   "		    st_userFlds.innerHTML = tVl2;\n"
   "		}\n"
   "	    }\n"
   "	}\n"
   "\n"
   "	var xSc = this.xScale(true);\n"
   "	var ySc = this.yScale(true);\n"
   "	var geomW = parseFloat(this.attrs['geomW'])*xSc;\n"
   "	var geomH = parseFloat(this.attrs['geomH'])*ySc;\n"
   "\n"
   "	this.mousedown = new Array;\n"
   "	this.mouseup = new Array;\n"
   "\n"
   "	if(this.pg && this.parent && this.parent.inclOpen && this.parent.inclOpen == this.addr) {\n"
   "	    var geomWpar = parseFloat(this.parent.attrs['geomW'])*this.parent.xScale(true);\n"
   "	    var geomHpar = parseFloat(this.parent.attrs['geomH'])*this.parent.yScale(true);\n"
   "	    this.parent.place.style.overflow = (geomW > geomWpar || geomH > geomHpar) ? 'auto' : 'hidden';\n"
   "	    geomWScrl = (geomH > geomHpar) ? 20 : 0; geomHScrl = (geomW > geomWpar) ? 20 : 0;	//!!!! 20 is most scrollbar width and clientWidth does not work here\n"
   "	    geomW = Math.max(geomW, geomWpar-geomWScrl);\n"
   "	    geomH = Math.max(geomH, geomHpar-geomHScrl);\n"
   "\n"
   "	    // Updating the real geometry in VCAEngine to closely adjust the content\n"
   "	    if(this.parent.place.style.overflow == 'hidden') {\n"
   "		setWAttrs(this.addr, 'geomW', Math.floor(geomW/this.xScale(true)));\n"
   "		setWAttrs(this.addr, 'geomH', Math.floor(geomH/this.yScale(true)));\n"
   "	    }\n"
   "	}\n"
   "	//else elStyle += 'overflow: hidden; ';\n"
   "\n"
   "	//Compensation debries of the real numbers in position and size\n"
   "	//for true aligning the internal content of widgets with different size\n"
   "	geomW = realRound(geomX+geomW-xSc) - realRound(geomX) + Math.floor(xSc);\n"
   "	geomH = realRound(geomY+geomH-ySc) - realRound(geomY) + Math.floor(ySc);\n"
   "\n"
   "	geomW -= 2*(elMargin+elBorder);\n"
   "	geomH -= 2*(elMargin+elBorder);\n"
   "\n"
   "	//Set included window geometry to widget size\n"
   "	//if( this == masterPage ) resizeTo(geomW,geomH);\n"
   "	if(this.pg && this.window && this.windowExt) {\n"
   "	    if(this.window.innerHeight)\n"
   "		this.window.resizeTo(geomW+(this.window.outerWidth-this.window.innerWidth)+20,\n"
   "				     geomH+(this.window.outerHeight-this.window.innerHeight)+20);\n"
   "	    else this.window.resizeTo(geomW+20,geomH+40);\n"
   "	}\n"
   "\n"
   "	if(this.attrs['focus'] && parseInt(this.attrs['focus']) && this.attrsMdf['focus'])\n"
   "	    setFocus(this.addr, true, this.place.focusElem);\n"
   "\n"
   "	this.place.className = \"Primitive \" + this.attrs['root'];\n"
   "	if(!this.place.getAttribute('id'))\n"
   "	    this.place.setAttribute('id', this.addr.slice(this.addr.lastIndexOf(\"/\")+1));	// this.addr.replace(\"/\"+sessId,\"\").replace(/\\//g, \"_\"));\n"
   "\n"
   "	var isPrim = true;\n"
   "	if(!(parseInt(this.attrs['perm'])&SEC_RD)) {\n"
   "	    if(this.pg) {\n"
   "\n"
   "		elStyle += 'background-color: #B0B0B0; border: 1px solid black; color: red; overflow: auto; ';\n"
   "		this.place.innerHTML = \"<div class='vertalign' style='width: \"+(geomW-2)+\"px; height: \"+(geomH-2)+\"px;'>###Page###: '\"+this.addr+\"'.<br/>###View access is not permitted.###</div>\";\n"
   "	    }\n"
   "	    isPrim = false;\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'ElFigure') {\n"
   "	    var toInit = !this.place.childNodes.length;\n"
   "	    var figObj = toInit ? this.place.ownerDocument.createElement('img') : this.place.childNodes[0];\n"
   "	    figObj.width = geomW; figObj.height = geomH;\n"
   "	    // Src update always therefore for any changes is shape update\n"
   "	    figObj.src = '/'+MOD_ID+this.addr+'?com=obj&tm='+tmCnt+'&geomX='+geomX.toFixed(3)+'&geomY='+geomY.toFixed(3)+\n"
   "						    '&geomW='+geomW.toFixed(3)+'&geomH='+geomH.toFixed(3)+\n"
   "						    '&xSc='+xSc.toFixed(3)+'&ySc='+ySc.toFixed(3);\n"
   "	    if(elWr != this.place.elWr) {\n"
   "		figObj.onclick = !elWr ? null : function(e) {\n"
   "		    if(!e) e = window.event;\n"
   "		    servSet(this.wdgLnk.addr,'com=obj&sub=point&geomX='+geomX.toFixed(3)+'&geomY='+geomY.toFixed(3)+\n"
   "						    '&xSc='+xSc.toFixed(3)+'&ySc='+ySc.toFixed(3)+\n"
   "						    '&x='+(e.offsetX?e.offsetX:(e.clientX-posGetX(this)))+\n"
   "						    '&y='+(e.offsetY?e.offsetY:(e.clientY-posGetY(this)))+\n"
   "						    '&key='+evMouseGet(e),'');\n"
   "		    return false;\n"
   "		}\n"
   "		figObj.ondblclick = !elWr ? null : function(e) {\n"
   "		    if(!e) e = window.event;\n"
   "		    servSet(this.wdgLnk.addr,'com=obj&sub=point&geomX='+geomX.toFixed(3)+'&geomY='+geomY.toFixed(3)+\n"
   "						    '&xSc='+xSc.toFixed(3)+'&ySc='+ySc.toFixed(3)+\n"
   "						    '&x='+(e.offsetX?e.offsetX:(e.clientX-posGetX(this)))+\n"
   "						    '&y='+(e.offsetY?e.offsetY:(e.clientY-posGetY(this)))+\n"
   "						    '&key=DblClick','');\n"
   "		}\n"
   "	    }\n"
   "\n"
   "	    if(toInit) {\n"
   "		figObj.border = 0;\n"
   "		figObj.wdgLnk = this;\n"
   "		this.place.appendChild(figObj);\n"
   "		//Disable drag mostly for FireFox\n"
   "		figObj.onmousedown = function(e) { e = e?e:window.event; if(e.preventDefault) e.preventDefault(); }\n"
   "	    }\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'Box') {\n"
   "	    if(this == masterPage && this.attrs['tipStatus'].length) { setStatus(this.attrs['tipStatus'],10000); this.attrs['tipStatus'] = \"\"; }\n"
   "	    elStyle += 'border-style: solid; border-width: '+this.attrs['bordWidth']+'px; ';\n"
   "	    if(elWr && this.attrs['backColor'].length && getColor(this.attrs['backColor'],true)) elStyle += 'cursor: pointer; ';\n"
   "\n"
   "	    if(this.attrs['vs_winTitle']) {\n"
   "		if(this == masterPage || (this.pg && this.window && this.windowExt))\n"
   "		    window.document.title = this.attrs['vs_winTitle'];\n"
   "		else if(this.pg && this.window && !this.windowExt)\n"
   "		    this.place.parentElement.offsetParent.rows[0].cells[0].innerText = this.attrs['vs_winTitle'];\n"
   "	    }\n"
   "	    if((tVl=this.attrs['userSetVis']) && !full && tVl.length && this.attrsMdf['userSetVis']) {\n"
   "		if(tVl == '*') window.location = '/login'+window.location.pathname;\n"
   "		else { servSet(this.addr, 'com=setUser&user='+tVl, ''); window.location.reload(); }\n"
   "	    }\n"
   "	    for(iNtf = 0; iNtf < 8; iNtf++)\n"
   "		if((tVl=this.attrs[\"notifyVis\"+MOD_ID+iNtf]) && this.attrsMdf[\"notifyVis\"+MOD_ID+iNtf])\n"
   "		    ntfReg(iNtf, tVl, this.addr, true);\n"
   "		else if((tVl=this.attrs[\"notify\"+iNtf]) && this.attrsMdf[\"notify\"+iNtf])\n"
   "		    ntfReg(iNtf, tVl, this.addr, false);\n"
   "\n"
   "	    if(!this.pg && ((this.inclOpen && this.attrs['pgOpenSrc'] != this.inclOpen) ||\n"
   "		    (!this.inclOpen && this.attrs['pgOpenSrc'].length)))\n"
   "	    {\n"
   "		if(this.inclOpen) {\n"
   "		    servSet(this.inclOpen, 'com=pgClose&cacheCntr&cachePg', '');\n"
   "		    this.pages[this.inclOpen].pwClean();\n"
   "\n"
   "		    //this.pages[this.inclOpen].reqTm = tmCnt;\n"
   "		    pgCacheProc(this.pages[this.inclOpen]);\n"
   "		    //this.place.removeChild(this.pages[this.inclOpen].place);\n"
   "		    while(this.place.children.length) this.place.removeChild(this.place.children[0]);\n"
   "		    this.pages[this.inclOpen].perUpdtEn(false);\n"
   "		    delete this.pages[this.inclOpen];\n"
   "		    this.inclOpen = null;\n"
   "		}\n"
   "		if(this.attrs['pgOpenSrc'].length) {\n"
   "		    this.inclOpen = this.attrs['pgOpenSrc'];\n"
   "		    if((pgO=pgCacheGet(this.inclOpen))) {\n"
   "			this.pages[this.inclOpen] = pgO;\n"
   "			this.place.appendChild(this.pages[this.inclOpen].place);\n"
   "			this.pages[this.inclOpen].perUpdtEn(true);\n"
   "			//!!!! In any case complete reload the page due to the possibility of the last changes loss at the closing\n"
   "			this.pages[this.inclOpen].makeEl(servGet(this.inclOpen, 'com=attrsBr')); //&tm='+pgO.reqTm));\n"
   "		    }\n"
   "		    else {\n"
   "			var iPg = new pwDescr(this.inclOpen, true, this);\n"
   "			iPg.place = this.place.ownerDocument.createElement('div');\n"
   "			iPg.makeEl(servGet(this.inclOpen,'com=attrsBr'), false, true);\n"
   "\n"
   "			this.pages[this.inclOpen] = iPg;\n"
   "			this.place.appendChild(iPg.place);\n"
   "		    }\n"
   "		}\n"
   "	    }\n"
   "	    if(this.inclOpen) elStyle += 'pointer-events: all; ';\n"
   "	    this.place.wdgLnk = this;\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'Text') {\n"
   "	    elStyle += 'border-style: solid; border-width: '+this.attrs['bordWidth']+'px; overflow: hidden; ';\n"
   "	    if(elWr && this.attrs['text'].length && this.attrs['backColor'].length && getColor(this.attrs['backColor'],true)) elStyle += 'cursor: pointer; ';\n"
   "	    if(elMargin) { elStyle += 'padding: '+elMargin+'px; '; elMargin = 0; }\n"
   "	    var txtOrient = (parseInt(this.attrs['orient'])+360)%360;	//To absolute for [-360...360]\n"
   "	    if(this.attrsMdf[\"orient\"] || !(txtOrient == 0 || geomW >= geomH))\n"
   "		while(this.place.children.length) this.place.removeChild(this.place.children[0]);\n"
   "\n"
   "	    var txtAlign = parseInt(this.attrs['alignment']);\n"
   "	    var spanStyle = \"display: table-cell; \"+\n"
   "			    \"line-height: \"+((!parseInt(this.attrs['inHtml']) && this.attrs['text'].indexOf(\"\\n\") < 0)?\"1.0\":\"1.2\")+\"; \"+\n"
   "			    \"white-space: \"+(parseInt(this.attrs[\"wordWrap\"])?\"pre-wrap\":\"pre\")+\"; \";\n"
   "	    switch(txtAlign&0x3) {\n"
   "		case 0: spanStyle += 'text-align: left; ';		break;\n"
   "		case 1: spanStyle += 'text-align: right; ';		break;\n"
   "		case 2: spanStyle += 'text-align: center; ';	break;\n"
   "		case 3: spanStyle += 'text-align: justify; ';	break;\n"
   "	    }\n"
   "	    switch(txtAlign>>2) {\n"
   "		case 0: spanStyle += 'vertical-align: top; ';	break;\n"
   "		case 1: spanStyle += 'vertical-align: bottom; ';	break;\n"
   "		case 2: spanStyle += 'vertical-align: middle; ';	break;\n"
   "	    }\n"
   "	    if(txtOrient != 0) spanStyle += \"transform: rotate(\"+txtOrient+\"deg); \";\n"
   "	    spanStyle += getFont(this.attrs['font'], Math.min(xSc, ySc));\n"
   "	    spanStyle += 'color: ' + (this.attrs['color']?getColor(this.attrs['color']):'black') + '; ';\n"
   "	    var txtVal = this.attrs['text'];\n"
   "	    for(var i = 0; i < parseInt(this.attrs['numbArg']); i++) {\n"
   "		var argVal;\n"
   "		var argCfg = new Array();\n"
   "		switch(parseInt(this.attrs['arg'+i+'tp'])) {\n"
   "		    case 0:\n"
   "			argCfg[0] = this.attrs['arg'+i+'cfg'];\n"
   "			argVal = parseInt(this.attrs['arg'+i+'val']);\n"
   "			if(isNaN(argVal)) argVal = 0;\n"
   "			argVal = argVal.toString();\n"
   "			break;\n"
   "		    case 1:\n"
   "			argCfg = this.attrs['arg'+i+'cfg'].split(';');\n"
   "			if(argCfg[1] == 'g')	argVal = parseFloat(this.attrs['arg'+i+'val']).toPrecision(Math.max(0,argCfg[2]));\n"
   "			else if(argCfg[1] == 'e')	argVal = parseFloat(this.attrs['arg'+i+'val']).toExponential(Math.max(0,argCfg[2]));\n"
   "			else if(argCfg[1] == 'f')	argVal = parseFloat(this.attrs['arg'+i+'val']).toFixed(Math.max(0,argCfg[2]));\n"
   "			else argVal = this.attrs['arg'+i+'val'];\n"
   "			if(isNaN(argVal)) argVal = 0;\n"
   "			argVal = argVal.toString();\n"
   "			break;\n"
   "		    case 2:\n"
   "			argCfg[0] = this.attrs['arg'+i+'cfg'];\n"
   "			argVal = this.attrs['arg'+i+'val'];\n"
   "			break;\n"
   "		}\n"
   "		var argSize = Math.max(-1000,Math.min(1000,parseInt(argCfg[0])));\n"
   "		var argPad = '';\n"
   "		for(var j = argVal.length; j < Math.abs(argSize); j++) argPad += ' ';//&nbsp;';\n"
   "		if(argSize > 0) argVal = argPad+argVal; else argVal += argPad;\n"
   "		txtVal = txtVal.replace('%'+(i+1), argVal);\n"
   "	    }\n"
   "	    if(txtOrient == 0 || geomW >= geomH) {\n"
   "		spanStyle += \"width: \"+geomW+\"px; height: \"+geomH+\"px; \";\n"
   "		var spEl = this.place.children.length ? this.place.children[0] : this.place.ownerDocument.createElement('span');\n"
   "		this.place.appendChild(spEl);\n"
   "	    }\n"
   "	    else {	//Specific processing of the vertical rectangle\n"
   "		spanStyle += \"width: \"+Math.max(geomW,geomH)+\"px; height: \"+Math.max(geomW,geomH)+\"px; \";\n"
   "		var spBoxStl = \"position: absolute; width: \"+Math.max(geomW,geomH)+\"px; height: \"+Math.max(geomW,geomH)+\"px; \";\n"
   "		var rotMult = 0.5;	//Middle\n"
   "		if((txtAlign>>2) != 2) {\n"
   "		    rotMult = ((txtAlign>>2) == 1) ? 0 : 1;\n"
   "		    if(txtOrient > 180) rotMult = !rotMult;\n"
   "		}\n"
   "		spBoxStl += \"left: \"+(-rotMult*(geomH-geomW))+\"px; \";\n"
   "\n"
   "		var spBox = this.place.children.length ? this.place.children[0] : this.place.ownerDocument.createElement('div');\n"
   "		this.place.appendChild(spBox);\n"
   "		var spEl = spBox.children.length ? spBox.children[0] : this.place.ownerDocument.createElement('span');\n"
   "		spBox.appendChild(spEl);\n"
   "\n"
   "		spBox.style = spBoxStl;\n"
   "	    }\n"
   "\n"
   "	    if(parseInt(this.attrs['inHtml'])) spEl.innerHTML = txtVal;\n"
   "	    else spEl.innerText = txtVal;\n"
   "	    spEl.style = spanStyle;\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'Media') {\n"
   "	    elStyle += 'border-width: '+this.attrs['bordWidth']+'px; ';\n"
   "	    if(elWr && !parseInt(this.attrs['areas']) && this.attrs['src'].length && this.attrs['backColor'].length && getColor(this.attrs['backColor'],true))\n"
   "		elStyle += 'cursor: pointer; ';\n"
   "	    if(this.place.elWr != elWr || (parseInt(this.attrs['areas']) && this.place.children.length <= 1) ||\n"
   "					  (!parseInt(this.attrs['areas']) && this.place.children.length > 1) ||\n"
   "					  ((this.attrsMdf[\"src\"] || this.attrsMdf[\"fit\"]) && this.attrs['fit'] != 1))\n"
   "		while(this.place.children.length) this.place.removeChild(this.place.children[0]);\n"
   "\n"
   "	    var toInit = !this.place.children.length;\n"
   "	    if(this.attrs['type'] == 2)		medObjTp = 'video';\n"
   "	    else if(this.attrs['type'] == 3)	medObjTp = 'audio';\n"
   "	    else medObjTp = 'img';\n"
   "	    var medObj = toInit ? this.place.ownerDocument.createElement(medObjTp) : this.place.children[0];\n"
   "	    if(this.attrs['roll'] && (toInit || this.attrsMdf[\"roll\"])) medObj.loop = parseInt(this.attrs['roll']);\n"
   "	    if(this.attrs['pause'] && (toInit || this.attrsMdf[\"pause\"]) && parseInt(this.attrs['play'])) {\n"
   "		if(parseInt(this.attrs['pause'])) medObj.pause();\n"
   "		else medObj.play();\n"
   "	    }\n"
   "	    if(this.attrs['seek'] && (toInit || this.attrsMdf[\"seek\"]) && Math.abs(parseFloat(this.attrs['seek'])-medObj.currentTime) > 10)\n"
   "		medObj.currentTime = parseFloat(this.attrs['seek']);\n"
   "	    if(this.attrs['volume'] && (toInit || this.attrsMdf[\"volume\"])) medObj.volume = parseFloat(this.attrs['volume'])/100;\n"
   "	    if(toInit || this.attrsMdf[\"src\"] || this.attrsMdf[\"fit\"] || (this.attrs['fit'] == 1 && this.attrsMdf[\"keepAspect\"]) || this.attrsMdf[\"play\"] || !pgBr) {\n"
   "		if(!this.attrs['src'].length || (this.attrs['play'] && !parseInt(this.attrs['play'])))	medObj.src = \"\";\n"
   "		else if(this.attrs['src'].indexOf(\"http://\") == 0 || this.attrs['src'].indexOf(\"https://\") == 0)\n"
   "		    medObj.src = this.attrs['src'];\n"
   "		else if(this.attrs['src'].indexOf(\"data:\") == 0 && (fLine=this.attrs['src'].indexOf(\"\\n\")) >= 0)\n"
   "		    medObj.src = \"data:\"+this.attrs['src'].slice(5,fLine)+\";base64,\"+this.attrs['src'].slice(fLine+1);\n"
   "		else medObj.src = \"/\"+MOD_ID+this.addr+\"?com=res&val=\"+this.attrs['src'].replace(/ /g,'%20');\n"
   "		medObj.hidden = !this.attrs['src'].length;\n"
   "	    }\n"
   "	    if(this.attrs['play'] && (toInit || this.attrsMdf[\"play\"])) {\n"
   "		if(parseInt(this.attrs['play'])) {\n"
   "		    if(toInit) medObj.autoplay = true;\n"
   "		    else medObj.play();\n"
   "		}\n"
   "		this.perUpdtEn(parseInt(this.attrs['play']));\n"
   "	    }\n"
   "	    if(toInit || this.attrsMdf[\"fit\"] || (this.attrs['fit'] == 1 && this.attrsMdf[\"keepAspect\"]) || !pgBr) {\n"
   "		if(this.attrs['fit'] == 1) {\n"
   "		    medObj.width = geomW; medObj.height = geomH;\n"
   "		    medObj.style.display = medObj.style.maxWidth = medObj.style.maxHeight = medObj.style.width = medObj.style.height = null;\n"
   "		    if(this.attrs['keepAspect'] == 1) {\n"
   "			medObj.removeAttribute(\"width\"); medObj.removeAttribute(\"height\");\n"
   "			medObj.style.display = \"block\";\n"
   "			medObj.style.maxWidth = geomW+\"px\";\n"
   "			medObj.style.maxHeight = geomH+\"px\";\n"
   "			medObj.style.width = medObj.style.height = \"auto\";\n"
   "		    }\n"
   "		    // Only for the type \"Image(0)\"\n"
   "		    else if(this.attrs['src'].length && this.attrs['type'] == 0 && this.attrs['src'].indexOf(\"data:\") != 0)\n"
   "			medObj.src += \"&size=\"+geomH;\n"
   "		    medObj.onload = null;\n"
   "		}\n"
   "		else medObj.onload = function() {\n"
   "		    if(this.cWdth == null) this.cWdth = this.width;\n"
   "		    if(this.cHeight == null) this.cHeight = this.height;\n"
   "		    if(this.wdgLnk.attrs['keepAspect'] == 1) {\n"
   "			this.width = this.cWdth * Math.min(this.wdgLnk.xScale(true),this.wdgLnk.yScale(true));\n"
   "			this.height = this.cHeight * Math.min(this.wdgLnk.xScale(true),this.wdgLnk.yScale(true));\n"
   "		    }\n"
   "		    else {\n"
   "			this.width = this.cWdth * this.wdgLnk.xScale(true);\n"
   "			this.height = this.cHeight * this.wdgLnk.yScale(true);\n"
   "		    }\n"
   "		}\n"
   "	    }\n"
   "	    if(elWr && (toInit || this.attrsMdf[\"areas\"])) {\n"
   "		var mapObj = toInit ? this.place.ownerDocument.createElement('map') : this.place.children[1];\n"
   "		while(mapObj.children.length) mapObj.removeChild(mapObj.children[0]);\n"
   "		for(var i = 0; i < parseInt(this.attrs['areas']); i++) {\n"
   "		    var arObj = this.place.ownerDocument.createElement('area');\n"
   "		    switch(parseInt(this.attrs['area'+i+'shp'])) {\n"
   "			case 0: arObj.shape = 'rect';	break;\n"
   "			case 1: arObj.shape = 'poly';	break;\n"
   "			case 2: arObj.shape = 'circle';	break;\n"
   "		    }\n"
   "		    // Scale the coordinates\n"
   "		    var coords = this.attrs['area'+i+'coord'].split(\",\");\n"
   "		    arObj.coords = \"\";\n"
   "		    for(var iCoord = 0; iCoord < coords.length; iCoord++)\n"
   "			arObj.coords += (arObj.coords.length?\",\":\"\") +\n"
   "				Math.floor(parseInt(coords[iCoord]) * (((iCoord%2)==0)?this.xScale(true):this.yScale(true)));\n"
   "		    //arObj.coords = this.attrs['area'+i+'coord'];\n"
   "		    arObj.title = this.attrs['area'+i+'title'];\n"
   "		    arObj.href = '';\n"
   "		    arObj.areaId = i;\n"
   "		    arObj.onclick = function( )	{ setWAttrs(this.wdgLnk.addr,'event','ws_MapAct'+this.areaId+'Left'); return false; }\n"
   "		    arObj.wdgLnk = this;\n"
   "		    mapObj.appendChild(arObj);\n"
   "		}\n"
   "	    }\n"
   "	    if(toInit) {\n"
   "		medObj.wdgLnk = this;\n"
   "		if(this.attrs['play']) {\n"
   "		    medObj.onloadeddata = function() { setWAttrs(this.wdgLnk.addr,'size',this.duration.toFixed(1)); return false; }\n"
   "		    if(this.attrs['type'] == 2)	medObj.setAttribute('style','height: inherit; width: inherit; ');\n"
   "		}\n"
   "		//Disable drag mostly for FireFox\n"
   "		medObj.onmousedown = function(e) { e = e?e:window.event; if(e.preventDefault) e.preventDefault(); }\n"
   "		medObj.border = 0;\n"
   "		this.place.appendChild(medObj);\n"
   "		if(elWr) {\n"
   "		    this.place.appendChild(mapObj);\n"
   "		    mapObj.name = this.addr;\n"
   "		    medObj.setAttribute('usemap','#'+this.addr);\n"
   "		}\n"
   "	    }\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'FormEl') {\n"
   "	    var elTp = parseInt(this.attrs['elType']);\n"
   "	    if(this.attrsMdf['elType'] || this.place.elWr != elWr)\n"
   "		while(this.place.childNodes.length) this.place.removeChild(this.place.childNodes[0]);\n"
   "\n"
   "	    if(this.attrsMdf['font'])	this.place.fontCfg = getFontCond(this.attrs['font'], Math.min(xSc,ySc));\n"
   "	    var fntSz = Math.min(geomH, (getFont(this.attrs['font'],Math.min(xSc,ySc),2)*1.4).toFixed(0));\n"
   "	    var applySz = Math.max(16, fntSz);\n"
   "\n"
   "	    // Processing the custom behaviour attributes\n"
   "	    bordStyle = backStyle = null;\n"
   "	    if(this.attrs['vs_border'])	bordStyle = this.attrs['vs_border'];\n"
   "	    if(this.attrs['vs_background']) {	//!!!! Must be moved to a separate function for the transparent background of the included items\n"
   "		if((backClr=this.attrs['vs_background'].split(' ')[0]) && (backOp=getColor(backClr,true))) {\n"
   "		    if(backOp == 1) {\n"
   "			backStyle = 'background-color: '+getColor(backClr)+'; ';\n"
   "			if(this.placeTr) this.placeTr.style.cssText = elStyle;\n"
   "		    }\n"
   "		    else {\n"
   "			backStyle = '';\n"
   "			if(!this.placeTr) {\n"
   "			    this.placeTr = this.place.ownerDocument.createElement('div');\n"
   "			    this.place.parentNode.appendChild(this.placeTr);\n"
   "			}\n"
   "			this.placeTr.style.cssText = elStyle + 'width: ' + geomW + 'px; height: ' + geomH + 'px; background-color: '+getColor(backClr)+'; opacity: '+backOp+\"; z-index: \"+(parseInt(this.attrs['geomZ'])-1)+\"; \";\n"
   "		    }\n"
   "		}\n"
   "		if((backImg=this.attrs['vs_background'].split(' ')[1]))	backStyle = (backStyle?backStyle:'') + 'background-image: url(\\'/'+MOD_ID+this.addr+'?com=res&val='+backImg+'\\'); ';\n"
   "	    }\n"
   "\n"
   "	    var comElMdf = (this.attrs['vs_border'] && this.attrsMdf['vs_border']) || (this.attrs['vs_background'] && this.attrsMdf['vs_background']);\n"
   "\n"
   "	    switch(elTp) {\n"
   "		case 0:	//Line edit\n"
   "		    var toInit = !this.place.childNodes.length;\n"
   "		    var formObj = toInit ? this.place.ownerDocument.createElement('input') : this.place.childNodes[0];\n"
   "		    this.place.view = parseInt(this.attrs['view']);\n"
   "		    this.place.confirm = parseInt(this.attrs['confirm']);\n"
   "\n"
   "		    if(toInit || comElMdf || this.attrsMdf['geomH'] || this.attrsMdf['geomW'] || this.attrsMdf['font']) {\n"
   "			brdW = (bordStyle?parseInt(bordStyle):1) + 1;\n"
   "			var geomWint = geomW - 2*brdW;\n"
   "			formObj.className = \"LineEd\";\n"
   "			formObj.style.cssText = 'padding: 1px; top: 0; bottom: 0; margin: auto; width: '+geomWint+'px; '+\n"
   "						'height: '+(fntSz-brdW)+'px; font: '+this.place.fontCfg+';';\n"
   "			formObj.style.cssText += \"border: \"+(bordStyle?bordStyle:\"1px solid gray\")+\"; \";\n"
   "			formObj.style.cssText += (backStyle == null) ? 'background-color: white; ' : (backStyle.length?backStyle:'');\n"
   "			switch(this.place.view) {\n"
   "			    case 1: case 2: case 3: case 5: case 6:	//Combo, Integer, Real, Date, Date and time\n"
   "				if(formObj.nextSibling) {\n"
   "				    formObj.style.width = (geomWint-16)+'px';\n"
   "				    formObj.nextSibling.style.left = (geomW-16)+'px';\n"
   "				}\n"
   "				break;\n"
   "			    case 7:	//Password\n"
   "				formObj.type = \"password\";\n"
   "				break;\n"
   "			}\n"
   "		    }\n"
   "		    this.place.cfg = this.attrs['cfg'];\n"
   "		    if(formObj.valSet && (this.attrsMdf['value'] || this.attrsMdf['cfg'])) formObj.valSet(this.attrs['value']);\n"
   "		    if(!toInit) break;\n"
   "		    formObj.wdgLnk = this;\n"
   "		    formObj.disabled = !elWr;\n"
   "\n"
   "		    this.place.appendChild(formObj);\n"
   "		    if(elWr) {\n"
   "			switch(this.place.view) {\n"
   "			    case 1:		//Combo\n"
   "				var combImg = this.place.ownerDocument.createElement('img');\n"
   "				combImg.className = \"cntr\"; combImg.src = '/'+MOD_ID+'/img_combar';\n"
   "				combImg.style.cssText = 'left: '+(geomW-16)+'px; top: 0; bottom: 0; margin: auto; height: '+fntSz+'px; ';\n"
   "				this.place.appendChild(combImg);\n"
   "				formObj.style.width = (geomWint-16)+'px';\n"
   "				combImg.onclick = function( ) {\n"
   "				    var formObj = this.parentNode.children[0];\n"
   "				    var combList = this.ownerDocument.getElementById('combomenu');\n"
   "				    if(!combList) {\n"
   "					combList = this.ownerDocument.createElement('div');\n"
   "					combList.id = 'combomenu';\n"
   "					combList.appendChild(this.ownerDocument.createElement('select'));\n"
   "					combList.childNodes[0].size = '100';\n"
   "					combList.childNodes[0].onclick = function( ) {\n"
   "					    //this.formObj.value = this.options[this.selectedIndex].value;\n"
   "					    //this.formObj.setModify(true);\n"
   "					    this.formObj.setModify(false);\n"
   "					    this.formObj.valSet(this.options[this.selectedIndex].value);\n"
   "					    this.formObj.chApply();\n"
   "					    this.parentNode.style.visibility = 'hidden';\n"
   "					    this.parentNode.style.top = \"-100px\";\n"
   "					}\n"
   "					this.ownerDocument.body.appendChild(combList);\n"
   "				    }\n"
   "				    while(combList.childNodes[0].childNodes.length)\n"
   "					combList.childNodes[0].removeChild(combList.childNodes[0].childNodes[0]);\n"
   "				    // Creation for items of the list\n"
   "				    var elLst = formObj.parentNode.cfg.split('\\n');\n"
   "				    for(var i = 0; i < elLst.length; i++) {\n"
   "					var optEl = this.ownerDocument.createElement('option');\n"
   "					optEl.appendChild(this.ownerDocument.createTextNode(elLst[i]));\n"
   "					if(formObj.valGet() == elLst[i]) optEl.defaultSelected = optEl.selected = true;\n"
   "					combList.childNodes[0].appendChild(optEl);\n"
   "				    }\n"
   "				    //  Appending for missed value to the list\n"
   "				    if(elLst.indexOf(formObj.valGet()) < 0) {\n"
   "					var optEl = this.ownerDocument.createElement('option');\n"
   "					optEl.appendChild(this.ownerDocument.createTextNode(formObj.valGet()));\n"
   "					optEl.defaultSelected = optEl.selected = true;\n"
   "					combList.childNodes[0].appendChild(optEl);\n"
   "				    }\n"
   "\n"
   "				    if(combList.childNodes[0].childNodes.length) {\n"
   "					var combHeight = Math.min(combList.childNodes[0].length,10)*parseInt(this.style.height)+2;\n"
   "					var combTop = posGetY(formObj,true) + formObj.offsetHeight;\n"
   "					if((combTop+combHeight) > this.ownerDocument.body.scrollHeight)\n"
   "					    combTop = posGetY(formObj,true) - combHeight;\n"
   "					combList.style.cssText = 'left: '+posGetX(formObj,true)+'px; top: '+combTop+'px; '+\n"
   "								 'width: '+formObj.offsetWidth+'px; height: '+combHeight+'px; ';\n"
   "					combList.childNodes[0].style.cssText = 'width: 100%; height: 100%; font: '+formObj.parentNode.fontCfg+'; ';\n"
   "					combList.childNodes[0].formObj = formObj;\n"
   "					combList.childNodes[0].focus();\n"
   "				    }\n"
   "				    return false;\n"
   "				}\n"
   "				break;\n"
   "			    case 2: case 3:	//Integer, Real\n"
   "				if(this.place.childNodes.length >= 2) break;\n"
   "				var spinImg = this.place.ownerDocument.createElement('img');\n"
   "				spinImg.className = \"cntr\"; spinImg.src = '/'+MOD_ID+'/img_spinar';\n"
   "				spinImg.style.cssText = 'left: '+(geomW-16)+'px; top: 0; bottom: 0; margin: auto; height: '+fntSz+'px; ';\n"
   "				spinImg.border = '0';\n"
   "				formObj.style.width = (geomWint-16)+'px';\n"
   "				spinImg.onclick = function(e) {\n"
   "				    if(!e) e = window.event;\n"
   "				    var formObj = this.parentNode.childNodes[0];\n"
   "				    var argCfg = this.parentNode.cfg.split(':');\n"
   "				    formObj.setModify(false);\n"
   "				    if((e.clientY-posGetY(this)) < fntSz/2)\n"
   "					formObj.valSet(formObj.valGet()+((argCfg.length>2)?((this.parentNode.view==2)?parseInt(argCfg[2]):parseFloat(argCfg[2])):1), true);\n"
   "				    else formObj.valSet(formObj.valGet()-((argCfg.length>2)?((this.parentNode.view==2)?parseInt(argCfg[2]):parseFloat(argCfg[2])):1), true);\n"
   "				    formObj.setModify(true);\n"
   "				    return false;\n"
   "				}\n"
   "				this.place.appendChild(spinImg);\n"
   "				break;\n"
   "			    case 4:	break;	//Time\n"
   "			    case 5:	//Date\n"
   "			    case 6:	//Date and time\n"
   "				var cldrImg = this.place.ownerDocument.createElement('img');\n"
   "				cldrImg.className = \"cntr\"; cldrImg.src = '/'+MOD_ID+'/img_combar';\n"
   "				cldrImg.style.cssText = 'left: '+(geomW-16)+'px; top: '+((geomH-fntSz)/2)+'px; height: '+fntSz+'px; ';\n"
   "				this.place.appendChild(cldrImg);\n"
   "				formObj.style.width = (geomWint-16)+'px';\n"
   "				cldrImg.onclick = function( ) {\n"
   "				    var formObj = this.parentNode.children[0];\n"
   "				    var cldrDlg = this.ownerDocument.getElementById('clndrdlg');\n"
   "				    if(!cldrDlg) {\n"
   "					cldrDlg = this.ownerDocument.createElement('div');\n"
   "					cldrDlg.id = 'clndrdlg';\n"
   "					cldrDlg.innerHTML = \"<input type='button' value='###Today###'/><select></select><select></select>\"+\n"
   "					    \"<table><tr><th>###Mon###</th><th>###Tue###</th><th>###Wed###</th><th>###Thr###</th><th>###Fri###</th><th class='end'>###Sat###</th><th class='end'>###Sun###</th></tr>\"+\n"
   "					    \"<tr><td/><td/><td/><td/><td/><td/><td/></tr>\"+\n"
   "					    \"<tr><td/><td/><td/><td/><td/><td/><td/></tr>\"+\n"
   "					    \"<tr><td/><td/><td/><td/><td/><td/><td/></tr>\"+\n"
   "					    \"<tr><td/><td/><td/><td/><td/><td/><td/></tr>\"+\n"
   "					    \"<tr><td/><td/><td/><td/><td/><td/><td/></tr>\"+\n"
   "					    \"<tr><td/><td/><td/><td/><td/><td/><td/></tr>\"+\n"
   "					    \"</table>\";\n"
   "					cldrDlg.onmouseup = function(e) { e.stopImmediatePropagation(); }\n"
   "					cldrDlg.children[0].onclick = function( ) {\n"
   "					    this.parentElement.formObj.setModify(false);\n"
   "					    this.parentElement.formObj.valSet((new Date()).getTime()/1000);\n"
   "					    this.parentElement.formObj.chApply();\n"
   "					    this.parentElement.style.visibility = 'hidden';\n"
   "					    this.parentElement.style.top = \"-100px\";\n"
   "					}\n"
   "					cldrDlg.children[1].onchange = cldrDlg.children[2].onchange = function( ) {\n"
   "					    this.parentElement.tmSet((new Date(parseInt(this.parentElement.children[1].options[this.parentElement.children[1].selectedIndex].value),\n"
   "									this.parentElement.children[2].selectedIndex,1)).getTime()/1000);\n"
   "					}\n"
   "					cldrDlg.daySet = function() {\n"
   "					    dlgN = this.offsetParent.parentElement;\n"
   "					    dtSrc = new Date(dlgN.formObj.valGet()*1000);\n"
   "					    dtSrc.setFullYear(parseInt(dlgN.children[1].options[dlgN.children[1].selectedIndex].value));\n"
   "					    dtSrc.setMonth(dlgN.children[2].selectedIndex);\n"
   "					    dtSrc.setDate(parseInt(this.textContent));\n"
   "					    dlgN.formObj.setModify(false);\n"
   "					    dlgN.formObj.valSet(dtSrc.getTime()/1000);\n"
   "					    dlgN.formObj.chApply();\n"
   "					    dlgN.style.visibility = 'hidden';\n"
   "					    dlgN.style.top = \"-100px\";\n"
   "					    dlgN.cldrDlg = null;\n"
   "					}\n"
   "					//Fill and activate the table\n"
   "					cldrDlg.tmSet = function(tm) {\n"
   "					    var dtCur = new Date();\n"
   "					    var dtSet = new Date(parseInt(tm)*1000);\n"
   "					    // Years fill\n"
   "					    var optLs = \"\"; hasCur = false;\n"
   "					    for(iY = 0; iY < 10; iY++) {\n"
   "						iY_ = (dtCur.getFullYear()-iY);\n"
   "						if(iY_ != dtSet.getFullYear()) optLs += \"<option>\"+iY_+\"</option>\";\n"
   "						else { optLs += \"<option selected>\"+iY_+\"</option>\"; hasCur = true; }\n"
   "					    }\n"
   "					    if(!hasCur) optLs += \"<option selected>\"+dtSet.getFullYear()+\"</option>\";\n"
   "					    this.children[1].innerHTML = optLs;\n"
   "					    // Months fill\n"
   "					    var optLs = \"\";\n"
   "					    for(iM = 0; iM < 12; iM++) {\n"
   "						var mNm = \"\";\n"
   "						if(iM == 0)		mNm = \"###January###\";\n"
   "						else if(iM == 1)	mNm = \"###February###\";\n"
   "						else if(iM == 2)	mNm = \"###March###\";\n"
   "						else if(iM == 3)	mNm = \"###April###\";\n"
   "						else if(iM == 4)	mNm = \"###May###\";\n"
   "						else if(iM == 5)	mNm = \"###June###\";\n"
   "						else if(iM == 6)	mNm = \"###July###\";\n"
   "						else if(iM == 7)	mNm = \"###August###\";\n"
   "						else if(iM == 8)	mNm = \"###September###\";\n"
   "						else if(iM == 9)	mNm = \"###October###\";\n"
   "						else if(iM == 10)	mNm = \"###November###\";\n"
   "						else if(iM == 11)	mNm = \"###December###\";\n"
   "						optLs += \"<option\"+((iM==dtSet.getMonth())?\" selected\":\"\")+\">\"+mNm+\"</option>\";\n"
   "					    }\n"
   "					    this.children[2].innerHTML = optLs;\n"
   "					    // Days fill\n"
   "					    dtSetMBeg = new Date(dtSet.getFullYear(), dtSet.getMonth(), 1);\n"
   "					    maxDayInMonth = 28;\n"
   "					    while((new Date(dtSet.getFullYear(),dtSet.getMonth(),maxDayInMonth+1)).getMonth() == dtSet.getMonth() && maxDayInMonth < 31)\n"
   "						maxDayInMonth++;\n"
   "					    for(iW = 0, iD = 1; iW < 6; iW++)\n"
   "						for(iWd = 0; iWd < 7; iWd++) {\n"
   "						    tdEl = this.children[3].rows[iW+1].cells[iWd];\n"
   "						    if((iW == 0 && iWd < ((tVl=dtSetMBeg.getDay()-1)<0?7+tVl:tVl)) || iD > maxDayInMonth)\n"
   "						    { tdEl.innerHTML = \"\"; tdEl.className = \"\"; tdEl.onclick = null; continue; }\n"
   "						    tdEl.innerHTML = iD;\n"
   "						    tdEl.className = \"active\";\n"
   "						    tdEl.onclick = this.daySet;\n"
   "						    if(iD == dtSet.getDate()) tdEl.className += \" sel\";\n"
   "						    if(iWd == 5 || iWd == 6) tdEl.className += \" end\";\n"
   "						    iD++;\n"
   "						}\n"
   "					    this.formObj.setModify(false);\n"
   "					}\n"
   "					this.ownerDocument.body.appendChild(cldrDlg);\n"
   "				    }\n"
   "				    formObj.cldrDlg = cldrDlg;\n"
   "				    cldrDlg.formObj = formObj;\n"
   "				    cldrDlg.tmSet(formObj.valGet());\n"
   "				    cldrDlg.style.cssText = 'left: '+Math.min(posGetX(formObj,true),this.ownerDocument.body.scrollWidth-cldrDlg.offsetWidth)+'px; '+\n"
   "					'top: '+(posGetY(formObj,true)+formObj.offsetHeight)+'px; '+\n"
   "					'font: '+formObj.parentNode.fontCfg+'; ';\n"
   "				    return false;\n"
   "				}\n"
   "				break;\n"
   "			}\n"
   "			formObj.onmousedown = function(e) { if(this.parentNode.confirm) this.setModify(true); }\n"
   "			formObj.onkeyup = function(e) {\n"
   "			    e.stopImmediatePropagation();\n"
   "			    if(this.modify() && e.keyCode == 13) this.chApply();\n"
   "			    if(this.modify() && e.keyCode == 27) this.chEscape();\n"
   "			    if(this.saveVal != this.value) this.setModify(true);\n"
   "			    return true;\n"
   "			}\n"
   "			formObj.onkeydown = function(e)	{ e.stopImmediatePropagation(); return true; }\n"
   "			formObj.oncontextmenu = function(e) { e.stopImmediatePropagation(); return true; }\n"
   "			formObj.modify = function( )	{ return this.parentNode.isModify ? true : false; }\n"
   "			formObj.setModify = function(on) {\n"
   "			    if(on && this.tmClearEdit)\n"
   "				this.tmClearEdit = this.parentNode.confirm ? tmClearEdit : tmConfirmEdit;\n"
   "			    if(this.modify() == on) return;\n"
   "			    var posOkImg = this.parentNode.children.length-1;\n"
   "			    var okImg = this.parentNode.children[posOkImg];\n"
   "			    if(on) {\n"
   "				if(this.parentNode.confirm) {\n"
   "				    this.style.width = (parseInt(this.style.width)-applySz)+'px';\n"
   "				    if(posOkImg == 2)\n"
   "					this.parentNode.children[1].style.left = (parseInt(this.parentNode.children[1].style.left)-applySz)+'px';\n"
   "				    okImg.style.visibility = 'visible';\n"
   "				}\n"
   "				else this.style.borderLeft = \"7px ridge red\";\n"
   "\n"
   "				this.wdgLnk.perUpdtEn(true); this.tmClearEdit = this.parentNode.confirm ? tmClearEdit : tmConfirmEdit;\n"
   "			    }\n"
   "			    else {\n"
   "				if(this.parentNode.confirm) {\n"
   "				    this.style.width = (parseInt(this.style.width)+applySz)+'px';\n"
   "				    if(posOkImg == 2)\n"
   "					this.parentNode.children[1].style.left = (parseInt(this.parentNode.children[1].style.left)+applySz)+'px';\n"
   "				    okImg.style.visibility = 'hidden';\n"
   "				    if(this.cldrDlg) this.cldrDlg.style.visibility = 'hidden';\n"
   "				}\n"
   "				else this.style.borderLeft = this.style.borderRight;\n"
   "\n"
   "				this.wdgLnk.perUpdtEn(false); this.tmClearEdit = 0;\n"
   "			    }\n"
   "			    this.parentNode.isModify = on;\n"
   "			}\n"
   "		    }\n"
   "		    formObj.valSet = function(val, noUpSave) {\n"
   "			this.srcVal = val;\n"
   "\n"
   "			switch(this.parentNode.view) {\n"
   "			    case 0: case 1: case 7: break;\n"
   "			    case 2:	//Integer\n"
   "				if(isNaN(tVal=parseInt(val))) tVal = 0;\n"
   "				var argCfg = this.parentNode.cfg.split(':');\n"
   "				val = ((argCfg.length>3)?argCfg[3]:'')+\n"
   "				    Math.max((argCfg.length>1)?parseInt(argCfg[0]):0,Math.min((argCfg.length>1)?parseInt(argCfg[1]):100,parseInt(tVal)))+((argCfg.length>4)?argCfg[4]:'');\n"
   "				break;\n"
   "			    case 3:	//Real\n"
   "				if(isNaN(tVal=parseFloat(val))) tVal = 0;\n"
   "				var argCfg = this.parentNode.cfg.split(':');\n"
   "				val = ((argCfg.length>3)?argCfg[3]:'')+Math.max((argCfg.length>1)?parseFloat(argCfg[0]):0,Math.min((argCfg.length>1)?parseFloat(argCfg[1]):100,parseFloat(tVal))).toFixed((argCfg.length>5)?parseInt(argCfg[5]):2)+((argCfg.length>4)?argCfg[4]:'');\n"
   "				break;\n"
   "			    case 4:	//Time\n"
   "				var rez = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'hh:mm';\n"
   "				var v = (Math.floor(val/3600)%(ap?12:24)).toString(10); rez = rez.replace('hh',i2s(v,10,2)); rez = rez.replace('h',v);\n"
   "				v = (Math.floor(val/60)%60).toString(10); rez = rez.replace('mm',i2s(v,10,2)); rez = rez.replace('m',v);\n"
   "				v = (val%60).toString(10); rez = rez.replace('ss',i2s(v,10,2)); rez = rez.replace('s',v);\n"
   "				if(rez.indexOf('ap') >= 0) { rez = rez.replace('ap',(val>=43200)?'pm':'am'); var ap = true; }\n"
   "				if(rez.indexOf('AP') >= 0) { rez = rez.replace('AP',(val>=43200)?'PM':'AM'); var ap = true; }\n"
   "				val = rez;\n"
   "				break;\n"
   "			    case 5:	//Date\n"
   "				var rez = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'dd.MM.yy';\n"
   "				var dt = new Date(parseInt(val)*1000);\n"
   "				var v = dt.getDate().toString(10); rez = rez.replace('dddd',i2s(v,10,2)); rez = rez.replace('ddd',i2s(v,10,2)); rez = rez.replace('dd',i2s(v,10,2)); rez = rez.replace('d',v);\n"
   "				v = (dt.getMonth()+1).toString(10); rez = rez.replace('MMMM',i2s(v,10,2)); rez = rez.replace('MMM',i2s(v,10,2)); rez = rez.replace('MM',i2s(v,10,2)); rez = rez.replace('M',v);\n"
   "				v = dt.getFullYear().toString(10); rez = rez.replace('yyyy',i2s(v,10,4)); rez = rez.replace('yy',i2s(v.substr(2,2),10,2));\n"
   "				val = rez;\n"
   "				break;\n"
   "			    case 6:	//Date and time\n"
   "				var rez = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'dd.MM.yy hh:mm';\n"
   "				var dt = new Date(parseInt(val)*1000);\n"
   "				var v = dt.getDate().toString(10); rez = rez.replace('dddd',i2s(v,10,2)); rez = rez.replace('ddd',i2s(v,10,2)); rez = rez.replace('dd',i2s(v,10,2)); rez = rez.replace('d',v);\n"
   "				v = (dt.getMonth()+1).toString(10); rez = rez.replace('MMMM',i2s(v,10,2)); rez = rez.replace('MMM',i2s(v,10,2)); rez = rez.replace('MM',i2s(v,10,2)); rez = rez.replace('M',v);\n"
   "				v = dt.getFullYear().toString(10); rez = rez.replace('yyyy',i2s(v,10,4)); rez = rez.replace('yy',i2s(v.substr(2,2),10,2));\n"
   "				v = dt.getHours().toString(10); rez = rez.replace('hh',i2s(v,10,2)); rez = rez.replace('h',v);\n"
   "				v = dt.getMinutes().toString(10); rez = rez.replace('mm',i2s(v,10,2)); rez = rez.replace('m',v);\n"
   "				v = dt.getSeconds().toString(10); rez = rez.replace('ss',(v.length==1)?'0'+v:v); rez = rez.replace('s',v);\n"
   "				if(rez.indexOf('ap') >= 0)	{ rez = rez.replace('ap',(val>=43200)?'pm':'am'); var ap = true; }\n"
   "				if(rez.indexOf('AP') >= 0)	{ rez = rez.replace('AP',(val>=43200)?'PM':'AM'); var ap = true; }\n"
   "				val = rez;\n"
   "				break;\n"
   "			}\n"
   "\n"
   "			if(!this.modify || !this.modify()) this.value = val;\n"
   "			if(noUpSave == null || !noUpSave) this.saveVal = val;\n"
   "		    }\n"
   "		    formObj.valGet = function( ) {\n"
   "			switch(this.parentNode.view) {\n"
   "			    case 0: case 1: case 7: return this.value;\n"
   "			    case 2:\n"
   "				var rez = this.value;\n"
   "				var argCfg = this.parentNode.cfg.split(':');\n"
   "				var tmp = (argCfg&&argCfg.length>3) ? noSpace(argCfg[3]) : '';\n"
   "				if(tmp.length && rez.indexOf(tmp) >= 0) rez = rez.substring(rez.indexOf(tmp)+tmp.length);\n"
   "				tmp = (argCfg&&argCfg.length>4) ? noSpace(argCfg[4]) : '';\n"
   "				if(tmp.length && rez.indexOf(tmp) >= 0) rez = rez.substring(0,rez.indexOf(tmp));\n"
   "				return parseInt(rez);\n"
   "			    case 3:\n"
   "				var rez = this.value;\n"
   "				var argCfg = this.parentNode.cfg.split(':');\n"
   "				var tmp = (argCfg&&argCfg.length>3) ? noSpace(argCfg[3]) : '';\n"
   "				if(tmp.length && rez.indexOf(tmp) >= 0) rez = rez.substring(rez.indexOf(tmp)+tmp.length);\n"
   "				tmp = (argCfg&&argCfg.length>4) ? noSpace(argCfg[4]) : '';\n"
   "				if(tmp.length && rez.indexOf(tmp) >= 0) rez = rez.substring(0,rez.indexOf(tmp));\n"
   "				return parseFloat(rez);\n"
   "			    case 4:\n"
   "				var cfg = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'hh:mm';\n"
   "				var rez = this.value;\n"
   "				if(cfg.indexOf('ap') >= 0 || cfg.indexOf('AP') >= 0) {\n"
   "				    cfg = cfg.replace('ap','');\n"
   "				    cfg = cfg.replace('AP','');\n"
   "				    rez = rez.replace('am','');\n"
   "				    rez = rez.replace('AM','');\n"
   "				    rez = rez.replace('pm','');\n"
   "				    rez = rez.replace('PM','');\n"
   "				}\n"
   "				var hour = Math.floor(this.srcVal/3600);\n"
   "				var min  = Math.floor(this.srcVal/60)%60;\n"
   "				var sec  = this.srcVal%60;\n"
   "				var i = 0; var lstS = ''; var lenS = 0;\n"
   "				while(true) {\n"
   "				    if(i >= cfg.length || cfg.charAt(i) == 'h' || cfg.charAt(i) == 'm' || cfg.charAt(i) == 's') {\n"
   "					var space = lenS ? noSpace(cfg.substr(i-lenS,lenS)) : '';\n"
   "					if(lenS && !space.length) space = ' ';\n"
   "					if((space.length && lstS != '') || i >= cfg.length) {\n"
   "					    if(space.length && rez.indexOf(space) == -1) return 0;\n"
   "					    var val = parseInt(space.length?rez.substr(0,rez.indexOf(space)):rez,10);\n"
   "					    rez = rez.substr(rez.indexOf(space));\n"
   "					    if(lstS == 'h')	hour = val;\n"
   "					    else if(lstS == 'm')min = val;\n"
   "					    else if(lstS == 's')sec = val;\n"
   "					    if(i >= cfg.length) break;\n"
   "					}\n"
   "					if(space.length) {\n"
   "					    if(rez.indexOf(space) == -1) return 0;\n"
   "					    rez = rez.substr(rez.indexOf(space)+space.length);\n"
   "					}\n"
   "					lstS = cfg.charAt(i); lenS = 0;\n"
   "					i++;\n"
   "					continue;\n"
   "				    }\n"
   "				    lenS++; i++;\n"
   "				}\n"
   "				if(this.value.indexOf('pm') >= 0 || this.value.indexOf('PM') >= 0) hour += 12;\n"
   "				return (hour%24)*3600+(min%60)*60+(sec%60);\n"
   "			    case 5:\n"
   "				var cfg = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'd.MM.yy';\n"
   "				var rez  = this.value;\n"
   "				var dt = new Date(this.srcVal*1000);\n"
   "				var i = 0; var lstS = ''; var lenS = 0;\n"
   "				while(true) {\n"
   "				    if(i >= cfg.length || cfg.charAt(i) == 'd' || cfg.charAt(i) == 'M' || cfg.charAt(i) == 'y') {\n"
   "					var space = lenS ? noSpace(cfg.substr(i-lenS,lenS)) : '';\n"
   "					if(lenS && !space.length) space = ' ';\n"
   "					if((space.length && lstS != '') || i >= cfg.length) {\n"
   "					    if(space.length && rez.indexOf(space) == -1) return 0;\n"
   "					    var val = parseInt(space.length?rez.substr(0,rez.indexOf(space)):rez,10);\n"
   "					    rez = rez.substr(rez.indexOf(space));\n"
   "					    if(lstS == 'd')	dt.setDate(val);\n"
   "					    else if(lstS == 'M')dt.setMonth(val-1);\n"
   "					    else if(lstS == 'y')dt.setFullYear((val<100)?2000+val:val);\n"
   "					    if(i >= cfg.length) break;\n"
   "					}\n"
   "					if(space.length) {\n"
   "					    if(rez.indexOf(space) == -1) return 0;\n"
   "					    rez = rez.substr(rez.indexOf(space)+space.length);\n"
   "					}\n"
   "					lstS = cfg.charAt(i); lenS = 0;\n"
   "					i++;\n"
   "					continue;\n"
   "				    }\n"
   "				    lenS++; i++;\n"
   "				}\n"
   "				rez = dt.getTime()/1000;\n"
   "				return rez;\n"
   "			    case 6:\n"
   "				var cfg = (this.parentNode.cfg.length) ? this.parentNode.cfg : 'dd.MM.yy hh:mm';\n"
   "				var rez  = this.value;\n"
   "				if(cfg.indexOf('ap') >= 0 || cfg.indexOf('AP') >= 0) {\n"
   "				    cfg = cfg.replace('ap','');\n"
   "				    cfg = cfg.replace('AP','');\n"
   "				    rez = rez.replace('am','');\n"
   "				    rez = rez.replace('AM','');\n"
   "				    rez = rez.replace('pm','');\n"
   "				    rez = rez.replace('PM','');\n"
   "				}\n"
   "				var dt = new Date(this.srcVal*1000);\n"
   "				var i = 0; var lstS = ''; var lenS = 0;\n"
   "				while(true) {\n"
   "				    if(i >= cfg.length || cfg.charAt(i) == 'd' || cfg.charAt(i) == 'M' || cfg.charAt(i) == 'y' ||\n"
   "					cfg.charAt(i) == 'h' || cfg.charAt(i) == 'm' || cfg.charAt(i) == 's')\n"
   "				    {\n"
   "					var space = lenS ? noSpace(cfg.substr(i-lenS,lenS)) : '';\n"
   "					if(lenS && !space.length) space = ' ';\n"
   "					if((space.length && lstS != '') || i >= cfg.length) {\n"
   "					    if(space.length && rez.indexOf(space) == -1) return 0;\n"
   "					    var val = parseInt(space.length?rez.substr(0,rez.indexOf(space)):rez,10);\n"
   "					    rez = rez.substr(rez.indexOf(space));\n"
   "					    if(lstS == 'd')	dt.setDate(val);\n"
   "					    else if(lstS == 'M')dt.setMonth(val-1);\n"
   "					    else if(lstS == 'y')dt.setFullYear((val<100)?2000+val:val);\n"
   "					    else if(lstS == 'h')dt.setHours(val);\n"
   "					    else if(lstS == 'm')dt.setMinutes(val);\n"
   "					    else if(lstS == 's')dt.setSeconds(val);\n"
   "					    if(i >= cfg.length) break;\n"
   "					}\n"
   "					if(space.length) {\n"
   "					    if(rez.indexOf(space) == -1) return 0;\n"
   "					    rez = rez.substr(rez.indexOf(space)+space.length);\n"
   "					}\n"
   "					lstS = cfg.charAt(i); lenS = 0; i++; continue;\n"
   "				    }\n"
   "				    lenS++; i++;\n"
   "				}\n"
   "				if(this.value.indexOf('pm') >= 0 || this.value.indexOf('PM') >= 0) dt.setHours(dt.getHours()+12);\n"
   "				rez = dt.getTime()/1000;\n"
   "				return rez;\n"
   "			}\n"
   "			return '';\n"
   "		    }\n"
   "		    formObj.chApply = function( ) {\n"
   "			this.setModify(false);\n"
   "			var val = this.valGet();\n"
   "			this.valSet(val);\n"
   "			var attrs = new Object(); attrs.value = val; attrs.event = 'ws_LnAccept';\n"
   "			setWAttrs(this.wdgLnk.addr, attrs);\n"
   "		    }\n"
   "		    formObj.chEscape = function( ) {\n"
   "			this.setModify(false);\n"
   "			this.value = this.saveVal;\n"
   "		    }\n"
   "		    var okImg = this.place.ownerDocument.createElement('img');\n"
   "		    okImg.className = \"ok\";\n"
   "		    okImg.src = '/'+MOD_ID+'/img_button_ok';\n"
   "		    okImg.style.cssText = 'right: 0px; top: 0; bottom: 0; margin: auto; height: '+applySz+'px; width: '+applySz+'px; ';\n"
   "		    okImg.onclick = function() { this.parentNode.childNodes[0].chApply(); return false; };\n"
   "		    this.place.appendChild(okImg);\n"
   "		    formObj.valSet(this.attrs['value']);\n"
   "		    break;\n"
   "		case 1:	//Text edit\n"
   "		    elStyle += 'pointer-events: all; ';\n"
   "		    var fntSz = (getFont(this.attrs['font'],Math.min(xSc,ySc),2)*1.4).toFixed(0);\n"
   "		    var applySz = Math.max(16, fntSz);\n"
   "\n"
   "		    var toInit = !this.place.childNodes.length;\n"
   "		    var formObj = toInit ? this.place.ownerDocument.createElement('textarea') : this.place.childNodes[0];\n"
   "		    if(toInit || comElMdf || this.attrsMdf['geomW'] || this.attrsMdf['geomH'] || this.attrsMdf['font']) {\n"
   "			formObj.style.cssText = 'padding: 1px; width: '+(geomW-5)+'px; height: '+(geomH-5)+'px; font: '+this.place.fontCfg+'; ';\n"
   "			formObj.style.cssText += \"border: \"+(bordStyle?bordStyle:\"1px solid gray\")+\"; \";\n"
   "			formObj.style.cssText += (backStyle == null) ? 'background-color: white; ' : (backStyle.length?backStyle:'');\n"
   "		    }\n"
   "		    if(this.attrsMdf['value']) formObj.saveVal = formObj.value = this.attrs['value'];\n"
   "		    if(!toInit) break;\n"
   "		    formObj.disabled = !elWr;\n"
   "		    formObj.wdgLnk = this;\n"
   "		    formObj.appendChild(this.place.ownerDocument.createTextNode(this.attrs['value']));\n"
   "		    formObj.onkeyup = function(e) {\n"
   "			// For renew the activity status per 30 seconds\n"
   "			curTime = (new Date()).getTime()/1000;\n"
   "			if(this.lastTm == null || (curTime-this.lastTm) > 30) this.lastTm = curTime;\n"
   "			else e.stopImmediatePropagation();\n"
   "\n"
   "			if(this.saveVal != this.value) this.setModify(true);\n"
   "			if(this.modify()) {\n"
   "			    if(e.keyCode == 13 && e.ctrlKey) {\n"
   "				this.saveVal = this.value;	//!!!! Must be early applied to prevent of indication the false modification\n"
   "				this.nextSibling.onclick();\n"
   "			    }\n"
   "			    if(e.keyCode == 27) this.nextSibling.nextSibling.onclick();\n"
   "			}\n"
   "\n"
   "			//!!!! Some workaround in preventing of loss the keyboard events during network activity.\n"
   "			if(isNN) {\n"
   "			    if(mainTmId) clearTimeout(mainTmId);\n"
   "			    mainTmId = setTimeout(makeUI, 5000);\n"
   "			}\n"
   "\n"
   "			return true;\n"
   "		    };\n"
   "		    formObj.onkeydown = function(e) { e.stopImmediatePropagation(); return true; }\n"
   "		    formObj.oncontextmenu = function(e) { e.stopImmediatePropagation(); return true; }\n"
   "		    formObj.modify = function( ) { return (this.parentNode.childNodes[1].style.visibility == 'visible'); }\n"
   "		    formObj.setModify = function(on) {\n"
   "			if(this.modify() == on) return;\n"
   "\n"
   "			if((this.nextSibling.offsetWidth+this.nextSibling.nextSibling.offsetWidth) > this.offsetWidth)\n"
   "			    this.nextSibling.nextSibling.setText('');\n"
   "			if(this.nextSibling.offsetWidth > this.offsetWidth)\n"
   "			    this.nextSibling.lastChild.setText('');\n"
   "\n"
   "			if(on) {\n"
   "			    this.style.height = (parseInt(this.style.height)-this.nextSibling.offsetHeight)+'px';\n"
   "			    this.nextSibling.style.visibility = this.nextSibling.nextSibling.style.visibility = 'visible';\n"
   "			}\n"
   "			else {\n"
   "			    this.style.height = (parseInt(this.style.height)+this.nextSibling.offsetHeight)+'px';\n"
   "			    this.nextSibling.style.visibility = this.nextSibling.nextSibling.style.visibility = 'hidden';\n"
   "			}\n"
   "		    }\n"
   "		    this.place.appendChild(formObj);\n"
   "		    this.place.appendChild(getButton('img_button_ok','###Apply###',applySz));\n"
   "		    this.place.appendChild(getButton('img_button_cancel','###Cancel###',applySz));\n"
   "		    formObj.nextSibling.onclick = function( ) {\n"
   "			var attrs = new Object();\n"
   "			attrs.value = this.parentNode.firstChild.value; attrs.event = 'ws_TxtAccept';\n"
   "			setWAttrs(this.parentNode.firstChild.wdgLnk.addr,attrs);\n"
   "			this.parentNode.firstChild.setModify(false);\n"
   "			return false;\n"
   "		    };\n"
   "		    formObj.nextSibling.nextSibling.onclick = function( ) {\n"
   "			this.parentNode.firstChild.value = this.parentNode.firstChild.saveVal;\n"
   "			this.parentNode.firstChild.setModify(false);\n"
   "			return false;\n"
   "		    };\n"
   "		    break;\n"
   "		case 2:	//Chek box\n"
   "		    this.place.classList.add(\"vertalign\");\n"
   "\n"
   "		    var toInit = !this.place.childNodes.length;\n"
   "\n"
   "		    var formObj = toInit ? this.place.ownerDocument.createElement('input') : this.place.childNodes[0];\n"
   "		    formObj.style.cssText = 'width: '+Math.min(geomW,geomH)+'px; height: '+Math.min(geomW,geomH)+'px;';\n"
   "		    formObj.checked = parseInt(this.attrs['value']);\n"
   "\n"
   "		    var spanObj = toInit ? this.place.ownerDocument.createElement('span') : this.place.childNodes[1];\n"
   "		    spanObj.style.cssText = 'font: '+this.place.fontCfg+';';\n"
   "		    spanObj.textContent = this.attrs['name'];\n"
   "\n"
   "		    if(toInit) {\n"
   "			formObj.type = 'checkbox';\n"
   "			formObj.disabled = !elWr;\n"
   "			formObj.wdgLnk = this;\n"
   "			formObj.onclick = function( ) {\n"
   "			    var attrs = new Object();\n"
   "			    attrs.value = this.checked ? '1' : '0';	attrs.event = 'ws_ChkChange';\n"
   "			    setWAttrs(this.wdgLnk.addr,attrs);\n"
   "			    return true;\n"
   "			}\n"
   "			this.place.appendChild(formObj); this.place.appendChild(spanObj);\n"
   "		    }\n"
   "		    break;\n"
   "		case 3:	//Button\n"
   "		    var formObj;\n"
   "		    var iconImg = this.attrs['img'];\n"
   "		    this.place.checkable = (parseInt(this.attrs['mode']) == 1);\n"
   "		    this.place.isMenu = (parseInt(this.attrs['mode']) == 2);\n"
   "		    this.place.isLoad = (parseInt(this.attrs['mode']) == 3);\n"
   "		    this.place.isSave = (parseInt(this.attrs['mode']) == 4);\n"
   "		    var custBut = iconImg;\n"
   "		    if(custBut != this.place.custBut || this.attrsMdf['mode'])\n"
   "			while(this.place.childNodes.length) this.place.removeChild(this.place.childNodes[0]);\n"
   "		    this.place.custBut = custBut;\n"
   "		    var toInit = !this.place.childNodes.length;\n"
   "		    formObj = toInit ? this.place.ownerDocument.createElement('button') : this.place.childNodes[0];\n"
   "		    if(toInit || this.attrsMdf['font'])\n"
   "			formObj.style.font = this.place.fontCfg;\n"
   "		    if(toInit || this.attrsMdf['color'])\n"
   "			formObj.style.backgroundColor = \"\", formObj.style.backgroundColor = getColor(this.attrs['color']);\n"
   "		    if(toInit || this.attrsMdf['colorText'])\n"
   "			formObj.style.color = \"\", formObj.style.color = getColor(this.attrs['colorText']);\n"
   "\n"
   "		    this.mouseup[this.mouseup.length] = function(e,el) { el.btUp(); }\n"
   "		    this.mousedown[this.mousedown.length] = function(e,el) { el.btDown(); };\n"
   "		    if(toInit) {\n"
   "			formObj.style.cursor = elWr ? 'pointer' : '';\n"
   "			formObj.disabled = !elWr;\n"
   "			formObj.wdgLnk = this;\n"
   "			formObj.style.padding = \"0\";\n"
   "			this.place.appendChild(formObj);\n"
   "			this.place.btDown = function( ) {\n"
   "			    if(this.checkable) {\n"
   "				var attrs = new Object();\n"
   "				if(!this.childNodes[0].classList.contains(\"pressed\"))\n"
   "				{ attrs.value = '1'; this.childNodes[0].classList.add(\"pressed\"); setWAttrs(this.wdgLnk.addr,'event','ws_BtPress'); }\n"
   "				else { attrs.value = '0'; this.childNodes[0].classList.remove(\"pressed\"); setWAttrs(this.wdgLnk.addr,'event','ws_BtRelease'); }\n"
   "				setWAttrs(this.wdgLnk.addr,'value',attrs.value);\n"
   "				setWAttrs(this.wdgLnk.addr,'event','ws_BtToggleChange');\n"
   "				return;\n"
   "			    }\n"
   "			    this.childNodes[0].classList.add(\"pressed\");\n"
   "			    this.childNodes[0].focus();\n"
   "			    setWAttrs(this.wdgLnk.addr,'event','ws_BtPress');\n"
   "			}\n"
   "			this.place.btUp = function( ) {\n"
   "			    if(this.checkable) return;\n"
   "			    this.childNodes[0].classList.remove(\"pressed\");\n"
   "			    if(this.wdgLnk.attrs[\"vs_goHttpUrl\"]) window.open(this.wdgLnk.attrs[\"vs_goHttpUrl\"]);\n"
   "			    setWAttrs(this.wdgLnk.addr,'event','ws_BtRelease');\n"
   "			}\n"
   "			formObj.onkeydown = function(e)	{ if(e.keyCode == 13 || e.keyCode == 32) this.parentNode.btDown(); }\n"
   "			formObj.onkeyup = function(e)	{ if(e.keyCode == 13 || e.keyCode == 32) this.parentNode.btUp(); }\n"
   "		    }\n"
   "\n"
   "		    if(custBut) {\n"
   "			var stdBordWidth = 2;\n"
   "			var imgObj = formObj.childNodes.length ? formObj.childNodes[0] : this.place.ownerDocument.createElement('img');\n"
   "			var spanObj = formObj.childNodes.length ? formObj.childNodes[1] : this.place.ownerDocument.createElement('span');\n"
   "\n"
   "			spanObj.style.cssText = \"display: table-cell; height: \"+(geomH-2*stdBordWidth)+\"px; text-align: center; white-space: pre-line; word-break: break-word; width: \"+(geomW-2*stdBordWidth)+\"px; \";\n"
   "			if(toInit || this.attrsMdf['name']) {\n"
   "			    spanObj.disabled = !this.attrs['name'].length;\n"
   "			    spanObj.innerText = this.attrs['name'].replace('\\\\n','\\n') + (this.place.isMenu?\" ▾\":\"\");\n"
   "			    spanObj.style.lineHeight = (this.attrs['name'].indexOf(\"\\\\n\") < 0) ? 1.0 : 1.2;\n"
   "			}\n"
   "			if(toInit || this.attrsMdf['img'] || this.attrsMdf['name']) {\n"
   "			    imgObj.hidden = !this.attrs['img'].length;\n"
   "			    if(!imgObj.hidden) {\n"
   "				imgObj.className = elWr ? 'active' : 'inactive';\n"
   "				imgObj.src = \"/\"+MOD_ID+this.addr+\"?com=res&val=\"+this.attrs['img']+\"&size=\"+(Math.min(geomW,geomH)-2*stdBordWidth);//+(!elWr?\"&filtr=unact\":\"\");\n"
   "				//imgObj.width = Math.min(geomW, geomH);\n"
   "				imgObj.height = Math.min(geomW, geomH)-2*stdBordWidth;\n"
   "				imgObj.style.float = spanObj.disabled ? null : 'left';\n"
   "				imgObj.style.marginRight = this.attrs['name'].length ? \"2px\" : \"0px\";\n"
   "			    }\n"
   "			}\n"
   "\n"
   "			if(toInit) {\n"
   "			    formObj.className = 'vertalign';\n"
   "			    //Disable drag mostly for FireFox\n"
   "			    imgObj.onmousedown = function(e) { e = e?e:window.event; if(e.preventDefault) e.preventDefault(); }\n"
   "			    formObj.appendChild(imgObj);\n"
   "			    formObj.appendChild(spanObj);\n"
   "			}\n"
   "		    }\n"
   "		    else if(toInit || this.attrsMdf['name']) {\n"
   "			formObj.innerText = this.attrs['name'].replace('\\\\n','\\n') + (this.place.isMenu?\" ▾\":\"\");\n"
   "			formObj.style.lineHeight = (this.attrs['name'].indexOf(\"\\\\n\") < 0) ? 1.0 : 1.2;\n"
   "		    }\n"
   "\n"
   "		    if(this.place.checkable) {\n"
   "			if(parseInt(this.attrs['value'])) formObj.classList.add(\"pressed\"); else formObj.classList.remove(\"pressed\");\n"
   "		    }\n"
   "\n"
   "		    if(this.place.isMenu)\n"
   "			formObj.onclick = function( ) {\n"
   "			    var menuWin = this.ownerDocument.getElementById('menuwin');\n"
   "			    if(!menuWin) {\n"
   "				menuWin = this.ownerDocument.createElement('div');\n"
   "				menuWin.id = 'menuwin';\n"
   "				menuWin.className = \"ItemsTree active\";\n"
   "				menuWin.treeFont = 'font:'+this.wdgLnk.place.fontCfg+'; ';\n"
   "				menuWin.close = function( ) { this.style.visibility = 'hidden'; this.style.top = \"-100px\"; }\n"
   "				menuWin.setList = function(list) {\n"
   "				    if(!this.children.length) this.appendChild(getTree());\n"
   "				    this.children[0].style.cssText = this.treeFont;\n"
   "				    this.children[0].select = function(ipath) {\n"
   "					if(!ipath.length) return;\n"
   "					attrs = new Object();\n"
   "					attrs.event = 'ws_BtMenu='+ipath;\n"
   "					setWAttrs(this.parentNode.formObj.wdgLnk.addr, attrs);\n"
   "					this.parentNode.close();\n"
   "				    }\n"
   "				    this.children[0].setList(list);\n"
   "				}\n"
   "				this.ownerDocument.body.appendChild(menuWin);\n"
   "			    }\n"
   "			    menuWin.style.cssText = 'left: '+posGetX(this,true)+'px; top: '+(posGetY(this,true)+this.offsetHeight)+'px; ';\n"
   "			    menuWin.onmouseleave = menuWin.close;\n"
   "			    menuWin.formObj = this;\n"
   "			    menuWin.setList(this.wdgLnk.attrs['value']);\n"
   "			}\n"
   "		    else if(this.place.isLoad && toInit) {\n"
   "			iformObj = this.place.ownerDocument.createElement('form');\n"
   "			iformObj.method = 'post';\n"
   "			iformObj.action = \"/\"+MOD_ID+this.addr+\"?com=obj\"\n"
   "			iformObj.enctype = \"multipart/form-data\";\n"
   "			fHeader = this.attrs['value'].split(\"\\n\",1)[0].split(\"|\");\n"
   "			iformObj.innerHTML = \"<input type='file' style='display: none' name='File' accept='\"+fHeader[3]+\"' defaultValue='\"+fHeader[2]+\"'/>\";\n"
   "			formObj.iformObj = iformObj;\n"
   "			formObj.onclick = function( ) { this.iformObj.children[0].click(); }\n"
   "			iformObj.children[0].wdgLnk = this;\n"
   "			iformObj.children[0].onchange = function( ) { if(this.value.length) this.form.submit(); }\n"
   "			this.place.appendChild(iformObj);\n"
   "		    }\n"
   "		    else if(this.place.isSave) {\n"
   "			if(this.attrs['value'].length && this.attrs['value'] != this.valuePrev)\n"
   "			    window.open('/'+MOD_ID+this.addr+\"/\"+this.attrs['value'].split(\"\\n\",1)[0].split(\"|\")[2]+'?com=obj');\n"
   "			this.valuePrev = this.attrs['value'];\n"
   "		    }\n"
   "		    break;\n"
   "		case 4: case 5:	//ComboBox, List\n"
   "		    elStyle += 'pointer-events: all; ';\n"
   "		    var toInit = !this.place.childNodes.length;\n"
   "		    var formObj = toInit ? this.place.ownerDocument.createElement('select') : this.place.childNodes[0];\n"
   "		    if(toInit || comElMdf || this.attrsMdf['geomW'] || this.attrsMdf['geomH'] || this.attrsMdf['font']) {\n"
   "			formObj.style.cssText = 'padding: 0; top: '+((elTp==4)?(geomH-fntSz)/2:0)+'px; '+\n"
   "					    'height: '+((elTp==4)?fntSz+'px':'inherit')+'; width: inherit; '+\n"
   "					    'font: '+this.place.fontCfg+'; ';\n"
   "			formObj.style.cssText += \"border: \"+(bordStyle?bordStyle:\"1px solid gray\")+\"; \";\n"
   "			formObj.style.cssText += (backStyle == null) ? 'background-color: white; ' : (backStyle.length?backStyle:'');\n"
   "		    }\n"
   "		    formObj.multiple = parseInt(this.attrs['mult']) ? true : null;\n"
   "		    if(toInit || this.attrsMdf['items'] || this.attrsMdf['value']) {\n"
   "			while(formObj.childNodes.length) formObj.removeChild(formObj.childNodes[0]);\n"
   "			var selVal = this.attrs['value'].split('\\n');\n"
   "			var elLst = this.attrs['items'].split('\\n');\n"
   "			for(var i = 0; i < elLst.length; i++) {\n"
   "			    var optEl = this.place.ownerDocument.createElement('option');\n"
   "			    optEl.appendChild(this.place.ownerDocument.createTextNode(elLst[i]));\n"
   "			    if((selId=selVal.indexOf(elLst[i])) >= 0) {\n"
   "				optEl.defaultSelected = optEl.selected = true;\n"
   "				selVal.splice(selId, 1);\n"
   "			    }\n"
   "			    formObj.appendChild(optEl);\n"
   "			}\n"
   "			for(i = 0; i < selVal.length; i++) {\n"
   "			    if(!(selVal[i].length || elTp == 4) || elLst.indexOf(selVal[i]) >= 0) continue;\n"
   "			    var optEl = this.place.ownerDocument.createElement('option');\n"
   "			    optEl.textContent = selVal[i];\n"
   "			    optEl.selected = optEl.defaultSelected = true;\n"
   "			    formObj.appendChild(optEl);\n"
   "			}\n"
   "		    }\n"
   "		    if(!toInit) break;\n"
   "		    formObj.disabled = !elWr;\n"
   "		    formObj.wdgLnk = this;\n"
   "		    if(elTp == 4)\n"
   "			formObj.onchange = function( ) {\n"
   "			    var attrs = new Object();\n"
   "			    attrs.value = this.options[this.selectedIndex].value; attrs.event = 'ws_CombChange';\n"
   "			    this.wdgLnk.attrs['value'] = attrs.value;\n"
   "			    setWAttrs(this.wdgLnk.addr,attrs);\n"
   "			}\n"
   "		    else {\n"
   "			formObj.size = 100;\n"
   "			formObj.onclick = function( ) {\n"
   "			    var attrs = new Object();\n"
   "			    attrs.value = \"\";\n"
   "			    for(iO = 0; iO < this.options.length; iO++)\n"
   "				if(this.options[iO].selected) attrs.value += (attrs.value.length?\"\\n\":\"\") + this.options[iO].value;\n"
   "			    attrs.event = 'ws_ListChange';\n"
   "			    this.wdgLnk.attrs['value'] = attrs.value;\n"
   "			    setWAttrs(this.wdgLnk.addr, attrs);\n"
   "			}\n"
   "		    }\n"
   "		    this.place.appendChild(formObj);\n"
   "		    break;\n"
   "		case 6: case 7:	//Slider and Scroll bar\n"
   "		    isProgr = false;	//(elTp == 7);\n"
   "		    var applySz = Math.floor(Math.max(16, Math.min(xSc,ySc)*16));\n"
   "		    var toInit = !this.place.children.length;\n"
   "		    var formObj = toInit ? this.place.ownerDocument.createElement('input') : this.place.children[0];\n"
   "		    if(toInit || this.attrsMdf['value']) formObj.value = parseInt(this.attrs['value']);\n"
   "		    formObj.vOr = false;\n"
   "		    if(toInit || this.attrsMdf['cfg']) {\n"
   "			cfgLst = this.attrs['cfg'].split(':');\n"
   "			formObj.vOr = (cfgLst.length && parseInt(cfgLst[0]));\n"
   "			formObj.setAttribute(\"orient\", formObj.vOr?\"vertical\":\"\");\n"
   "			formObj.setAttribute(\"min\", (cfgLst.length > 1)?parseInt(cfgLst[1]):0);\n"
   "			formObj.setAttribute(\"max\", (cfgLst.length > 2)?parseInt(cfgLst[2]):100);\n"
   "			formObj.setAttribute(\"step\", (cfgLst.length > 3)?parseInt(cfgLst[3]):1);\n"
   "		    }\n"
   "		    if(!toInit) break;\n"
   "		    formObj.type = 'range';\n"
   "		    formObj.disabled = !elWr;\n"
   "		    formObj.wdgLnk = this;\n"
   "		    formObj.style.cssText = \"width: \"+(formObj.vOr?applySz:(isProgr?geomW-2*applySz:geomW))+\"px; \"+\n"
   "			\"height: \"+(formObj.vOr?(isProgr?geomH-2*applySz:geomH):applySz)+\"px; \";\n"
   "		    formObj.onclick = formObj.onkeyup = function( ) {\n"
   "			if(this.value == parseInt(this.wdgLnk.attrs['value']))	return;\n"
   "			var attrs = new Object();\n"
   "			attrs.value = this.value; attrs.event = 'ws_SliderChange';\n"
   "			setWAttrs(this.wdgLnk.addr, attrs);\n"
   "			this.defaultValue = this.value;\n"
   "			//return true;\n"
   "		    }\n"
   "		    this.place.appendChild(formObj);\n"
   "		    break;\n"
   "		case 8:	//Tree\n"
   "		    elStyle += \"pointer-events: all; border: \"+(bordStyle?bordStyle:\"1px solid gray\")+\"; \";\n"
   "		    elStyle += (backStyle == null) ? 'background-color: white; ' : (backStyle.length?backStyle:'');\n"
   "		    geomW -= 2; geomH -= 2;\n"
   "		    //elStyle += \"border: 1px solid gray; padding: 1px; \";\n"
   "		    this.place.className += \" ItemsTree\";\n"
   "		    if(elWr) this.place.className += \" active\";\n"
   "		    var toInit = !this.place.children.length;\n"
   "		    var formObj = toInit ? getTree() : this.place.children[0];\n"
   "		    formObj.wdgLnk = this;\n"
   "		    formObj.elWr = elWr;\n"
   "		    if(toInit || this.attrsMdf['font'])	formObj.style.cssText = 'font: '+this.place.fontCfg+'; ';\n"
   "		    //Events and the processings init\n"
   "		    if(toInit)\n"
   "			formObj.select = function(ipath) {\n"
   "			    if(!ipath || !ipath.length) return;\n"
   "			    attrs = new Object();\n"
   "			    attrs.value = ipath;\n"
   "			    attrs.event = 'ws_TreeChange';\n"
   "			    setWAttrs(this.wdgLnk.addr, attrs);\n"
   "			}\n"
   "		    //Processing for fill and changes\n"
   "		    if(toInit || this.attrsMdf['items']) formObj.setList(this.attrs['items']);\n"
   "		    if(toInit || this.attrsMdf['value'] || this.attrsMdf['items']) formObj.selIt(this.attrs['value']);\n"
   "		    if(toInit) this.place.appendChild(formObj);\n"
   "		    break;\n"
   "		case 9:	//Table\n"
   "		    elStyle += \"pointer-events: all; padding: 1px; \";\n"
   "		    if(bordStyle) elStyle += \"border: \"+bordStyle+\"; \";\n"
   "		    if(backStyle != null) elStyle += backStyle;\n"
   "		    geomW -= 4; geomH -= 4;\n"
   "		    this.place.className += \" Table\";\n"
   "		    if(elWr) this.place.className += \" active\";\n"
   "		    var toInit = !this.place.children.length;\n"
   "		    var formObj = toInit ? this.place.ownerDocument.createElement('table') : this.place.children[0];\n"
   "		    formObj.wdgLnk = this;\n"
   "		    formObj.elWr = elWr;\n"
   "\n"
   "		    // Events and the processings init\n"
   "		    if(toInit) {\n"
   "			this.place.onscroll = function(e, reset) {	//Copying the header and holding it on the top\n"
   "			    if(!this.children.length) return;\n"
   "			    var tbl = this.children[0];\n"
   "			    if(this.children.length > 1 && (reset == true || this.scrollTop < tbl.tHead.clientHeight/2))\n"
   "				this.removeChild(this.children[1]);\n"
   "			    var tHd = (this.children.length > 1) ? this.children[1] : null;\n"
   "			    if(!tHd && tbl.tHead && this.scrollTop > tbl.tHead.clientHeight/2 && tbl.tHead.clientHeight < this.clientHeight/3) {\n"
   "				tHd = this.ownerDocument.createElement('table');\n"
   "				tHd.style.cssText = tbl.style.cssText + \"position: absolute; width: \"+tbl.clientWidth+\"px; box-shadow: 0px 2px 1px rgba(68,68,68,0.6);\";\n"
   "				tHd.innerHTML = tbl.tHead.outerHTML;\n"
   "				tHd.onclick = function( ) { this.parentNode.scrollTop = 0; }\n"
   "				this.appendChild(tHd);\n"
   "\n"
   "				//  Adjusting the percent width columns\n"
   "				for(iH = 0, cO = null; iH < tHd.tHead.rows[0].cells.length; iH++) {\n"
   "				    tHd.tHead.rows[0].cells[iH].onclick = !tbl.sortCol ? null : function() { this.offsetParent.offsetParent.firstChild.sort(this.cellIndex+1); }\n"
   "				    if(tHd.tHead.rows[0].cells[iH].style.width.indexOf(\"%\") >= 0)\n"
   "					(cO=tHd.tHead.rows[0].cells[iH]).style.width = tbl.tHead.rows[0].cells[iH].clientWidth+\"px\";\n"
   "				}\n"
   "				if(cO) cO.style.width = (parseInt(cO.style.width)-1)+\"px\";\n"
   "			    }\n"
   "			    if(tHd) tHd.style.top = this.scrollTop + 'px';\n"
   "			}\n"
   "			formObj.onclick = function( ) {\n"
   "			    if(this.nodeName == \"TABLE\" || !(elTbl=this.offsetParent) || !elTbl.elWr) return true;\n"
   "			    attrs = null;\n"
   "			    if(elTbl.oSel == \"row\" && this.parentNode.rowIndex > 0) {\n"
   "				elTbl.selIt(this.parentNode.rowIndex);\n"
   "				attrs = new Object();\n"
   "				attrs.value = elTbl.getVal(this.parentNode.rowIndex-1, elTbl.oKeyID);\n"
   "				if(this.parentNode.cells[elTbl.oKeyID+1].outTp == \"b\")\n"
   "				    attrs.value = (attrs.value == \"true\") ? 1 : 0;\n"
   "			    }\n"
   "			    else if(elTbl.oSel == \"col\" && this.cellIndex > 0) {\n"
   "				elTbl.selIt(null, this.cellIndex);\n"
   "				attrs = new Object();\n"
   "				attrs.value = elTbl.getVal(elTbl.oKeyID, this.cellIndex-1);\n"
   "				if(elTbl.tBodies[0].rows[elTbl.oKeyID].cells[this.cellIndex].outTp == \"b\")\n"
   "				    attrs.value = (attrs.value == \"true\") ? 1 : 0;\n"
   "			    }\n"
   "			    else if(this.parentNode.rowIndex > 0 && this.cellIndex > 0) {\n"
   "				elTbl.selIt(this.parentNode.rowIndex, this.cellIndex);\n"
   "				attrs = new Object();\n"
   "				if(elTbl.oSel == \"cell\") {\n"
   "				    attrs.value = elTbl.getVal(this.parentNode.rowIndex-1, this.cellIndex-1);\n"
   "				    if(this.outTp == \"b\") attrs.value = (attrs.value == \"true\") ? 1 : 0;\n"
   "				} else attrs.value = (this.parentNode.rowIndex-1) + \":\" + (this.cellIndex-1);\n"
   "			    }\n"
   "			    if(attrs) { attrs.event = 'ws_TableChangeSel'; setWAttrs(elTbl.wdgLnk.addr, attrs); }\n"
   "			}\n"
   "			formObj.ondblclick = function( ) {\n"
   "			    setFocus(elTbl.wdgLnk.addr, false, null, true);\n"
   "\n"
   "			    if(this.nodeName == \"TABLE\" || !(elTbl=this.offsetParent) || !elTbl.elWr || !this.isEdit) return true;\n"
   "			    if(this.isEnter) return false;	//!!!! To allow for words selection and to prevent the changes loss\n"
   "			    /*if(this.isEnter) {\n"
   "				this.innerHTML = this.svInnerHTML;\n"
   "				this.isEnter = false; elTbl.edIt = null;\n"
   "			    }*/\n"
   "			    else {\n"
   "				if(elTbl.edIt) { elTbl.edIt.innerHTML = elTbl.edIt.svInnerHTML; elTbl.edIt.isEnter = false; }\n"
   "				this.isEnter = true; elTbl.edIt = this;\n"
   "				this.svInnerHTML = this.innerHTML;\n"
   "\n"
   "				if(this.outTp == \"b\") {\n"
   "				    tVl = parseInt(elTbl.getVal(this.parentNode.rowIndex-1,this.cellIndex-1));\n"
   "				    this.innerHTML = \"<input type='checkbox'/>\";\n"
   "				    this.firstChild.checked = tVl;\n"
   "				    this.firstChild.onclick = function( ) {\n"
   "					this.parentNode.offsetParent.setVal((this.checked?1:0),\n"
   "					    this.parentNode.parentNode.rowIndex-1, this.parentNode.cellIndex-1);\n"
   "				    }\n"
   "				    this.firstChild.onkeyup = function(e) {\n"
   "					if(e.keyCode == 13 || e.keyCode == 20) {\n"
   "					    this.checked = !this.checked;\n"
   "					    this.parentNode.offsetParent.setVal((this.checked?1:0), this.parentNode.parentNode.rowIndex-1, this.parentNode.cellIndex-1);\n"
   "					}\n"
   "					if(e.keyCode == 27) {\n"
   "					    this.parentNode.isEnter = false; this.parentNode.offsetParent.edIt = null;\n"
   "					    this.parentNode.innerHTML = this.parentNode.svInnerHTML;\n"
   "					}\n"
   "					return true;\n"
   "				    }\n"
   "				    this.firstChild.focus();\n"
   "				}\n"
   "				else if(this.outTp == \"i\" || this.outTp == \"r\" || this.outTp == \"s\" || this.outTp == \"t\") {\n"
   "				    tVl = elTbl.getVal(this.parentNode.rowIndex-1, this.cellIndex-1);\n"
   "				    this.innerHTML = (this.outTp == \"t\") ? \"<textarea style='height: \"+Math.max(40,this.clientHeight)+\"px;'/>\" : \"<input/>\";\n"
   "				    this.firstChild.value = tVl;\n"
   "				    this.firstChild.onkeydown = function(e) {\n"
   "					e.stopImmediatePropagation();\n"
   "					if(e.keyCode == 13) {\n"
   "					    e.preventDefault();\n"
   "					    if(this.nodeName == \"TEXTAREA\" && e.ctrlKey) {	//NewLine insertion\n"
   "						var selStart = this.selectionStart;\n"
   "						this.value = this.value.slice(0, selStart) + \"\\n\" + this.value.slice(this.selectionEnd);\n"
   "						this.setSelectionRange(selStart + 1, selStart + 1);\n"
   "						this.blur(); this.focus();\n"
   "						return true;\n"
   "					    }\n"
   "					    var cellObj = this.parentNode;\n"
   "					    this.parentNode.offsetParent.setVal(this.value, this.parentNode.parentNode.rowIndex-1, this.parentNode.cellIndex-1);\n"
   "					    //  Order the refitting at not fixed columns\n"
   "					    if((cellObj.innerHTML.length < 50 || cellObj.svInnerHTML.length < 50) &&\n"
   "						    cellObj.innerHTML.length != cellObj.svInnerHTML.length &&\n"
   "						    !cellObj.offsetParent.tHead.rows[0].cells[cellObj.cellIndex].widthSrc.length)\n"
   "					    {\n"
   "						var isGrow = (cellObj.innerHTML.length > cellObj.svInnerHTML.length);\n"
   "						var tRows = cellObj.offsetParent.tBodies[0].rows;\n"
   "						for(var iR = 0; iR < tRows.length; iR++)\n"
   "						    if(iR != (cellObj.parentNode.rowIndex-1) &&\n"
   "							    ((isGrow && tRows[iR].cells[cellObj.cellIndex].innerHTML.length >= cellObj.innerHTML.length) ||\n"
   "							     (!isGrow && tRows[iR].cells[cellObj.cellIndex].innerHTML.length >= cellObj.svInnerHTML.length)) )\n"
   "							break;\n"
   "						if(iR >= tRows.length) {\n"
   "						    cellObj.offsetParent.wdgLnk.toReFit = cellObj.offsetParent.wdgLnk.toReFitForce = true;\n"
   "						    cellObj.offsetParent.wdgLnk.perUpdtEn(true);\n"
   "						}\n"
   "					    }\n"
   "					}\n"
   "					if(e.keyCode == 27) {\n"
   "					    this.parentNode.isEnter = false; this.parentNode.offsetParent.edIt = null;\n"
   "					    this.parentNode.innerHTML = this.parentNode.svInnerHTML;\n"
   "					}\n"
   "				    }\n"
   "				    //this.firstChild.onkeydown = function(e) { e.stopImmediatePropagation(); return true; }\n"
   "				    this.firstChild.oncontextmenu = function(e) { e.stopImmediatePropagation(); return true; }\n"
   "				    this.firstChild.focus();\n"
   "				    this.firstChild.setSelectionRange(this.firstChild.selectionStart, this.firstChild.selectionEnd);\n"
   "				} else { this.isEnter = false; elTbl.edIt = null; }\n"
   "			    }\n"
   "			    //   Prevent for wrong selection\n"
   "			    //!!!! But causes the text cursor obtain in the created input tag\n"
   "			    //if(window.getSelection) window.getSelection().removeAllRanges();\n"
   "			    //else if(document.selection) document.selection.empty();\n"
   "			    return false;\n"
   "			}\n"
   "			formObj.selIt = function(row, col) {\n"
   "			    //Restore saved\n"
   "			    if(this.svRow || this.svCol) {\n"
   "				if(!this.svRow) {\n"
   "				    cO = this.tHead.rows[0].cells[this.svCol];\n"
   "				    cO.style.backgroundColor = cO.svBackgroundColor;\n"
   "				    cO.style.border = \"\";\n"
   "				}\n"
   "				for(iR = (this.svRow?this.svRow-1:0); iR <= (this.svRow?Math.min(this.svRow-1,this.tBodies[0].rows.length-1):this.tBodies[0].rows.length-1); iR++)\n"
   "				    for(iC = (this.svCol?this.svCol:0); iC <= (this.svCol?this.svCol:(this.tBodies[0].rows[iR].cells.length-1)); iC++) {\n"
   "					cO = this.tBodies[0].rows[iR].cells[iC];\n"
   "					cO.style.backgroundColor = cO.svBackgroundColor;\n"
   "					cO.style.border = \"\";\n"
   "				    }\n"
   "			    }\n"
   "			    //Set new\n"
   "			    if(row || col) {\n"
   "				if(!row) {\n"
   "				    cO = this.tHead.rows[0].cells[col];\n"
   "				    cO.svBackgroundColor = cO.style.backgroundColor;\n"
   "				    cO.style.backgroundColor = tblCurClr;\n"
   "				    cO.style.border = tblCurBrd;\n"
   "				}\n"
   "				for(iR = (row?row-1:0); iR <= (row?row-1:this.tBodies[0].rows.length-1); iR++)\n"
   "				    for(iC = (col?col:0); iC <= (col?col:this.tBodies[0].rows[iR].cells.length-1); iC++) {\n"
   "					cO = this.tBodies[0].rows[iR].cells[iC];\n"
   "					cO.svBackgroundColor = cO.style.backgroundColor;\n"
   "					cO.style.backgroundColor = tblCurClr;\n"
   "					if(!col || (row && col)) cO.style.borderTop = cO.style.borderBottom = tblCurBrd;\n"
   "					if(!row || (row && col)) cO.style.borderLeft = cO.style.borderRight = tblCurBrd;\n"
   "				    }\n"
   "			    }\n"
   "			    this.svRow = row; this.svCol = col;\n"
   "			}\n"
   "			formObj.getVal = function( row, col ) {\n"
   "			    tit = this.tBodies[0].rows[row].cells[col+1];\n"
   "			    return tit.origVl ? tit.origVl : tit.innerText;\n"
   "			}\n"
   "			formObj.setVal = function( val, row, col ) {\n"
   "			    tit = this.tBodies[0].rows[row].cells[col+1];\n"
   "			    if(tit.isEnter) {\n"
   "				//tit.innerHTML = tit.svInnerHTML;\n"
   "				attrs = new Object(); attrs.set = val; attrs.event = \"ws_TableEdit_\"+col+\"_\"+this.tBodies[0].rows[row].rowReal;\n"
   "				setWAttrs(this.wdgLnk.addr, attrs);\n"
   "				tit.isEnter = false; this.edIt = null;\n"
   "			    }\n"
   "			    tit.origVl = null;\n"
   "			    switch(tit.outTp) {\n"
   "				case 'b':\n"
   "				    tit.childNodes[0].style.display = parseInt(val) ? \"\" : \"none\";\n"
   "				    if(tit.isEdit) tit.origVl = parseInt(val);\n"
   "				    break;\n"
   "				case 'i': tit.innerText = parseInt(val);	break;\n"
   "				case 'r':\n"
   "				    tit.innerText = parseFloat(parseFloat(val).toPrecision(tit.outPrec?tit.outPrec:6));\n"
   "				    break;\n"
   "				default:\n"
   "				    if(val.length <= limTblItmCnt) tit.innerText = val;\n"
   "				    else { tit.innerText = val.slice(0,limTblItmCnt) + \"...\"; if(tit.isEdit) tit.origVl = val; }\n"
   "				    break;\n"
   "			    }\n"
   "			}\n"
   "		    }\n"
   "		    if(toInit || this.attrsMdf['font'])  formObj.style.cssText = 'font: '+this.place.fontCfg+'; ';\n"
   "		    // Processing for fill and changes\n"
   "		    if(this.attrs['items'] && (toInit || this.attrsMdf['items'] /*|| this.attrsMdf['value']*/ || this.attrsMdf['font'])) {\n"
   "			hdrPresent = false, maxCols = 0, maxRows = 0;\n"
   "			toReFit = this.attrsMdf['font'];\n"
   "			var itemsO = (new DOMParser()).parseFromString(this.attrs['items'], \"text/xml\");\n"
   "			//  No table data\n"
   "			if(!itemsO.children.length || (tX=itemsO.children[0]).nodeName != \"tbl\")	formObj.innerHTML = \"\";\n"
   "			//  Detection the table complete change in the edition mode\n"
   "			else if(!(toInit || !formObj.edIt || !formObj.tBodies.length || !formObj.tBodies[0].rows.length ||\n"
   "				!itemsO.children[0].children.length || !itemsO.children[0].children[0].children.length ||\n"
   "				(itemsO.children[0].children.length-formObj.tBodies[0].rows.length) != 1 ||	//Rows in the date + header\n"
   "				(tVl=formObj.tBodies[0].rows[0].cells.length-itemsO.children[0].children[0].children.length) < 0 || tVl > 1)) ;	//Columns not equal or more than 1\n"
   "			//  Processing the table data\n"
   "			else {\n"
   "			    if(toInit || !formObj.children.length) formObj.innerHTML = \"<THEAD><TR/></THEAD><TBODY/>\";\n"
   "			    else if(!((wVl=tX.getAttribute(\"sortEn\")) && parseInt(wVl))) formObj.sortCol = null;\n"
   "\n"
   "			    rClr = null, rClrTxt = null, rFnt = null, rPrec = null;\n"
   "			    startRows = formObj.tBodies[0].rows.length;\n"
   "			    startCols = startRows ? formObj.tBodies[0].rows[0].cells.length : 0;\n"
   "			    sortCol = 0;\n"
   "			    for(iR = 0, iRR = 0, iCh = 0; iCh < tX.children.length || iR < formObj.tBodies[0].rows.length; iCh++) {\n"
   "				tR = (iCh < itemsO.children[0].children.length) ? itemsO.children[0].children[iCh] : null;\n"
   "				isH = false, hit = null, tit = null;\n"
   "				if(tR && !((isH=(tR.nodeName==\"h\")) || tR.nodeName == \"r\")) continue;\n"
   "				if(!isH && iR >= formObj.tBodies[0].rows.length)\n"
   "				    formObj.tBodies[0].appendChild(this.place.ownerDocument.createElement('tr'));\n"
   "				if(!isH && tR) {\n"
   "				    formObj.tBodies[0].rows[iR].rowReal = iR;\n"
   "				    rClr = tR.getAttribute(\"color\");\n"
   "				    rClrTxt = tR.getAttribute(\"colorText\");\n"
   "				    rFnt = tR.getAttribute(\"font\");\n"
   "				    rPrec = tR.getAttribute(\"prec\");\n"
   "				}\n"
   "				for(iC = 0, iCR = 0, iCh1 = 0; (tR && iCh1 < tR.children.length) || iC < formObj.tHead.children.length; ) {\n"
   "				    tC = (tR && iCh1 < tR.children.length) ? tR.children[iCh1] : null;\n"
   "				    if(iC >= formObj.tHead.rows[0].cells.length)\n"
   "					formObj.tHead.rows[0].appendChild(this.place.ownerDocument.createElement('th'));\n"
   "				    hit = formObj.tHead.rows[0].cells[iC];\n"
   "				    hit.onclick = formObj.onclick;\n"
   "				    if(isH) {	//Header process\n"
   "					if(iC == 0) { hit.innerText = '*'; iC++; continue; }\n"
   "					if(tC) {\n"
   "					    if(hit.innerText != tC.textContent) toReFit = true;\n"
   "					    hit.innerText = tC.textContent;\n"
   "					    hit.widthSrc = \"\"\n"
   "					    if(!(wVl=tC.getAttribute(\"width\"))) ;\n"
   "					    else if(wVl.indexOf(\"%\") >= 0)	hit.widthSrc = parseInt(wVl) + \"%\";\n"
   "					    else hit.widthSrc = (parseInt(wVl)*xSc) + \"px\";\n"
   "					    hit.outEdit = parseInt(tC.getAttribute(\"edit\"));\n"
   "					    hit.outColor = tC.getAttribute(\"color\");\n"
   "					    hit.outColorText = tC.getAttribute(\"colorText\");\n"
   "					    hit.outFont = tC.getAttribute(\"font\");\n"
   "					    hit.outAlign = tC.getAttribute(\"align\");\n"
   "					    hit.style.display = (hit.widthSrc.length && !parseInt(hit.widthSrc)) ? \"none\" : \"\";\n"
   "					    if((wVl=tC.getAttribute(\"sort\")))	{ sortCol = iC+1; if(parseInt(wVl)) sortCol *= -1; }\n"
   "					    hit.outPrec = tC.getAttribute(\"prec\");\n"
   "					} else hit.innerText = \"\";\n"
   "				    }\n"
   "				    else {	//Rows content process\n"
   "					if(iC >= formObj.tBodies[0].rows[iR].cells.length)\n"
   "					    formObj.tBodies[0].rows[iR].appendChild(this.place.ownerDocument.createElement(iC==0?'th':'td'));\n"
   "					tit = formObj.tBodies[0].rows[iR].cells[iC];\n"
   "					tit.onclick = formObj.onclick;\n"
   "					if(iC == 0) { tit.innerText = iR+1; iC++; continue; }\n"
   "					else tit.ondblclick = formObj.ondblclick;\n"
   "					// Modify set\n"
   "					if(hit.outEdit || (tC && (wVl=tC.getAttribute(\"edit\")) && parseInt(wVl))) tit.isEdit = true;\n"
   "					else tit.isEdit = false;\n"
   "					// Value\n"
   "					if(tC) {\n"
   "					    tit.outTp = tC.nodeName;\n"
   "					    tit.style.textAlign = (tit.outTp == \"b\" || tit.outTp == \"i\" || tit.outTp == \"r\") ? \"center\" : \"\";\n"
   "					    if(tit.outTp == \"b\") tit.innerHTML = \"<img src='/\"+MOD_ID+\"/img_button_ok' height='\"+fntSz+\"px'/> \";\n"
   "					    if(tit.outTp == \"r\" && ((wVl=tC.getAttribute(\"prec\")) || (wVl=hit.outPrec) || (wVl=rPrec)))\n"
   "						tit.outPrec = parseInt(wVl);\n"
   "					    formObj.setVal(tC.textContent, iR, iC-1);\n"
   "					}\n"
   "					// Visibility\n"
   "					tit.style.display = (hit.widthSrc.length && !parseInt(hit.widthSrc)) ? \"none\" : \"\";\n"
   "					// Back color\n"
   "					isSelected = (tit.style.backgroundColor == tblCurClr);\n"
   "					if((tC && (wVl=tC.getAttribute(\"color\"))) || (wVl=hit.outColor) || (wVl=rClr))\n"
   "					    tit.style.backgroundColor = getColor(wVl);\n"
   "					else tit.style.backgroundColor = null;\n"
   "					if(isSelected) tit.svBackgroundColor = tit.style.backgroundColor;\n"
   "					tit.style.border = null;\n"
   "					// Text font and color\n"
   "					if((tC && (wVl=tC.getAttribute(\"colorText\"))) || (wVl=hit.outColorText) || (wVl=rClrTxt))\n"
   "					    tit.style.color = getColor(wVl);\n"
   "					else tit.style.color = null;\n"
   "					if((tC && (wVl=tC.getAttribute(\"font\"))) || (wVl=hit.outFont) || (wVl=rFnt))\n"
   "					    tit.style.font = getFontCond(wVl, Math.min(xSc,ySc));\n"
   "					else tit.style.font = null;\n"
   "					// Cell image\n"
   "					if(tC && (wVl=tC.getAttribute(\"img\")))\n"
   "					    tit.innerHTML = \"<img src='/\"+MOD_ID+this.addr+\"?com=res&val=\"+wVl+\"'/> \" + tit.innerText;\n"
   "					// Alignment set\n"
   "					if((tC && (wVl=tC.getAttribute(\"align\"))) || (wVl=hit.outAlign)) tit.style.textAlign = wVl;\n"
   "				    }\n"
   "				    if(tC)	{ ++iCR; maxCols = Math.max(maxCols, iCR); }\n"
   "				    iC++; iCh1++;\n"
   "				}\n"
   "				if(!isH) {\n"
   "				    if(tR)	{ ++iRR; maxRows = Math.max(maxRows, iRR); }\n"
   "				    iR++;\n"
   "				} else hdrPresent = true;\n"
   "			    }\n"
   "\n"
   "			    if(Math.abs(maxRows-startRows) > 3 || (!startRows && formObj.tBodies[0].rows.length) ||\n"
   "				    ((formObj.tBodies[0].rows.length-startRows) > 0 && formObj.tBodies[0].rows.length.toString(10).length > startRows.toString(10).length) ||\n"
   "				     (formObj.tBodies[0].rows.length && formObj.tBodies[0].rows[0].cells.length > startCols))\n"
   "				toReFit = true;\n"
   "\n"
   "			    // Generic properties set\n"
   "			    formObj.oKeyID = (wVl=tX.getAttribute(\"keyID\")) ? parseInt(wVl) : 0;\n"
   "			    formObj.oSel = tX.getAttribute(\"sel\");\n"
   "			    if(formObj.oSel == \"row\" && formObj.oKeyID)		formObj.oKeyID = Math.min(formObj.oKeyID, maxCols-1);\n"
   "			    else if(formObj.oSel == \"col\" && formObj.oKeyID)	formObj.oKeyID = Math.min(formObj.oKeyID, maxRows-1);\n"
   "\n"
   "			    // Remove spare rows and columns; Headers visibility process\n"
   "			    if(!(wVl=tX.getAttribute(\"hHdrVis\")) || !wVl.length || parseInt(wVl))\n"
   "				formObj.tHead.rows[0].style.display = \"\"\n"
   "			    else {\n"
   "				formObj.tHead.rows[0].style.display = \"none\";\n"
   "				if(formObj.tBodies[0].rows.length)\n"
   "				    for(iC = 0; iC < formObj.tBodies[0].rows[0].cells.length; iC++)\n"
   "					formObj.tBodies[0].rows[0].cells[iC].widthSrc = formObj.tHead.rows[0].cells[iC].widthSrc;\n"
   "			    }\n"
   "			    //formObj.tHead.rows[0].style.display =\n"
   "			    //	(!(wVl=tX.getAttribute(\"hHdrVis\")) || !wVl.length || parseInt(wVl)) ? \"\" : \"none\";\n"
   "			    while(formObj.tHead.rows[0].cells.length > (maxCols+1))\n"
   "				formObj.tHead.rows[0].removeChild(formObj.tHead.rows[0].lastChild);\n"
   "			    wVl = (wVl=tX.getAttribute(\"vHdrVis\")) ? parseInt(wVl) : false;\n"
   "			    if(formObj.tHead.rows[0].cells.length)\n"
   "				formObj.tHead.rows[0].cells[0].style.display = wVl ? \"\" : \"none\";\n"
   "			    for(iR = 0; iR < formObj.tBodies[0].rows.length; iR++) {\n"
   "				tR = formObj.tBodies[0].rows[iR];\n"
   "				if(tR.cells.length) tR.cells[0].style.display = wVl ? \"\" : \"none\";\n"
   "				while(tR.cells.length > (maxCols+1)) tR.removeChild(tR.lastChild);\n"
   "			    }\n"
   "			    while(formObj.tBodies[0].rows.length > maxRows)\n"
   "				formObj.tBodies[0].removeChild(formObj.tBodies[0].lastChild);\n"
   "\n"
   "			    //Specifying the columns mode fitting - the table layout mode\n"
   "			    if(toReFit) {\n"
   "				hdrRow = formObj.tHead.rows[0];\n"
   "				if(hdrRow.style.display == \"none\") hdrRow = formObj.tBodies[0].rows[0];\n"
   "				for(iC = 0; hdrRow && iC < hdrRow.cells.length; iC++)\n"
   "				    hdrRow.cells[iC].style.width = hdrRow.cells[iC].widthSrc ? hdrRow.cells[iC].widthSrc : null;\n"
   "\n"
   "				formObj.style.width = \"\"; formObj.style.tableLayout = \"auto\";\n"
   "				if((wVl=tX.getAttribute(\"colsWdthFit\")) && parseInt(wVl)) formObj.style.width = \"100%\";\n"
   "				else { this.toReFit = toReFit; this.perUpdtEn(true); }\n"
   "			    }\n"
   "\n"
   "			    //Sorting\n"
   "			    if(((wVl=tX.getAttribute(\"sortEn\")) && parseInt(wVl)) || sortCol) {\n"
   "				if(sortCol) {\n"
   "				    if(formObj.sortColSet && sortCol != formObj.sortColSet) formObj.sortCol = null;\n"
   "				    formObj.sortColSet = sortCol;\n"
   "				} else formObj.sortColSet = null;\n"
   "\n"
   "				formObj.sort = function(col, force) {\n"
   "				    if(force) this.sortCol = -col;\n"
   "				    col = Math.abs(col);\n"
   "				    if(!this.tHead.rows[0].cells[col-1]) return;\n"
   "				    isDesc = (Math.abs(this.sortCol) == col && this.sortCol && this.sortCol > 0);\n"
   "				    prcArr = Array.prototype.slice.call(this.tBodies[0].rows,0).sort(\n"
   "					    function(a,b) {\n"
   "						if(a.cells[col-1].outTp == \"i\")	return (isDesc?-1:1)*(parseInt(a.cells[col-1].textContent)<parseInt(b.cells[col-1].textContent)?-1:1);\n"
   "						if(a.cells[col-1].outTp == \"r\")	return (isDesc?-1:1)*(parseFloat(a.cells[col-1].textContent)<parseFloat(b.cells[col-1].textContent)?-1:1);\n"
   "						return (isDesc?-1:1)*a.cells[col-1].textContent.localeCompare(b.cells[col-1].textContent);\n"
   "					    }\n"
   "					);\n"
   "				    for(iR = 0; iR < prcArr.length; ++iR) {\n"
   "					if(this.svRow && this.svRow == parseInt(prcArr[iR].cells[0].textContent))\n"
   "					    this.svRow = -(iR+1);\n"
   "					prcArr[iR].cells[0].textContent = iR+1;\n"
   "					this.tBodies[0].appendChild(prcArr[iR]);\n"
   "				    }\n"
   "				    this.svRow = Math.abs(this.svRow);\n"
   "				    this.tHead.rows[0].cells[col-1].innerHTML = this.tHead.rows[0].cells[col-1].childNodes[0].textContent + \"<span>&nbsp;\"+(isDesc?\"▲\":\"▼\")+\"</span>\";\n"
   "				    if(this.sortCol && Math.abs(this.sortCol) != col)\n"
   "					this.tHead.rows[0].cells[Math.abs(this.sortCol)-1].innerText = this.tHead.rows[0].cells[Math.abs(this.sortCol)-1].childNodes[0].textContent;\n"
   "				    this.sortCol = (Math.abs(this.sortCol) == col) ? -this.sortCol : col;\n"
   "				}\n"
   "				for(iC = 1; iC < formObj.tHead.rows[0].cells.length; iC++) {\n"
   "				    formObj.tHead.rows[0].cells[iC].onclick = function() { this.offsetParent.sort(this.cellIndex+1); }\n"
   "				    if(!sortCol && formObj.tHead.rows[0].cells[iC].style.display != \"none\") sortCol = iC+1;\n"
   "				}\n"
   "\n"
   "				if(formObj.sortCol) formObj.sort(formObj.sortCol, true);\n"
   "				else if(sortCol) formObj.sort(sortCol, true);\n"
   "			    }\n"
   "			}\n"
   "			delete itemsO;\n"
   "			//!!!! Preventing of storing big table sources\n"
   "			if(this.attrs['items'].length > 10000) { delete this.attrs['items']; this.attrs['items'] = null; }\n"
   "		    }\n"
   "		    if(toInit) this.place.appendChild(formObj);\n"
   "\n"
   "		    // Set the value\n"
   "		    if((toInit || this.attrsMdf['value'] || this.attrsMdf['items']) && formObj.innerHTML.length) {\n"
   "			val = this.attrs['value'];\n"
   "			if(formObj.oSel == \"row\" || formObj.oSel == \"col\" || formObj.oSel == \"cell\") {\n"
   "			    findOK = false;\n"
   "			    for(iR = ((formObj.oSel==\"col\")?formObj.oKeyID:0);\n"
   "				    !findOK && iR <= ((formObj.oSel==\"col\")?formObj.oKeyID:formObj.tBodies[0].rows.length-1); iR++)\n"
   "				for(iC = ((formObj.oSel==\"row\")?formObj.oKeyID+1:1);\n"
   "					!findOK && iC <= ((formObj.oSel==\"row\")?formObj.oKeyID+1:(formObj.tBodies[0].rows[iR].cells.length-1)); iC++) {\n"
   "				    cO = formObj.tBodies[0].rows[iR].cells[iC];\n"
   "				    valc = formObj.getVal(iR, iC-1); if(cO.outTp == \"b\") valc = (valc==\"true\") ? 1 : 0;\n"
   "				    if((findOK=(valc==val))) formObj.selIt(((formObj.oSel==\"col\")?null:iR+1), ((formObj.oSel==\"row\")?null:iC));\n"
   "				}\n"
   "			    if(!findOK) formObj.selIt();\n"
   "			} else if((sepPos=val.indexOf(\":\")) > 0) formObj.selIt(parseInt(val.slice(0,sepPos))+1, parseInt(val.slice(sepPos+1))+1);\n"
   "		    }\n"
   "\n"
   "		    this.place.onscroll();\n"
   "\n"
   "		    break;\n"
   "	    }\n"
   "	    this.place.isSpecFocus = true;\n"
   "	    if(elWr != this.place.elWr || this.attrsMdf['geomZ']) {\n"
   "		if(elWr) formObj.setAttribute('tabIndex', getTabIndex(this,parseInt(this.attrs['geomZ'])));\n"
   "		else formObj.removeAttribute('tabIndex');\n"
   "		this.place.focusElem = elWr ? formObj : null;\n"
   "	    }\n"
   "	    if(elWr != this.place.elWr) formObj.onfocus = !elWr ? null : function(e) { setFocus(this.parentNode.wdgLnk.addr); }\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'Diagram') {\n"
   "	    elStyle += 'border-style: solid; border-width: '+this.attrs['bordWidth']+'px; ';\n"
   "	    var dgrObj = this.place.childNodes[0];\n"
   "	    if(!dgrObj)	{\n"
   "		this.place.appendChild((dgrObj=this.place.ownerDocument.createElement('img')));\n"
   "		dgrObj.wdgLnk = this;\n"
   "	    }\n"
   "	    dgrObj.isActive = elWr;\n"
   "	    dgrObj.onclick = function(e) {\n"
   "		if(!this.isActive) return false;\n"
   "		if(!e) e = window.event;\n"
   "		servSet(this.wdgLnk.addr,'com=obj&sub=point&x='+(e.offsetX?e.offsetX:(e.clientX-posGetX(this)))+\n"
   "							  '&y='+(e.offsetY?e.offsetY:(e.clientY-posGetY(this)))+\n"
   "							  '&key='+evMouseGet(e),'');\n"
   "		return false;\n"
   "	    }\n"
   "	    dgrObj.isLoad = false;\n"
   "	    dgrObj.onload = function( )	{ this.isLoad = true; }\n"
   "	    dgrObj.src = '/'+MOD_ID+this.addr+'?com=obj&tm='+tmCnt+'&xSc='+xSc.toFixed(3)+'&ySc='+ySc.toFixed(3);\n"
   "	    //Disable drag mostly for FireFox\n"
   "	    dgrObj.onmousedown = function(e) { e = e?e:window.event; if(e.preventDefault) e.preventDefault(); }\n"
   "	    this.perUpdtEn(this.isEnabled() && parseInt(this.attrs['trcPer']));\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'Protocol') {\n"
   "	    if(!this.attrs['backColor'] || !getColor(this.attrs['backColor'],true)) elStyle += 'background-color: white; ';\n"
   "	    elStyle += 'pointer-events: all; border: 1px solid black; overflow: auto; padding: 2px; text-align: left; ';\n"
   "	    geomW -= 6; geomH -= 6;\n"
   "\n"
   "	    this.wFont = getFont(this.attrs['font'], Math.min(xSc,ySc));\n"
   "\n"
   "	    if(!this.place.firstChild) {\n"
   "		this.place.appendChild(document.createElement('table'));\n"
   "		this.place.firstChild.setAttribute('width','100%');\n"
   "		this.place.firstChild.wdgLnk = this;\n"
   "		this.place.firstChild.isActive = elWr;\n"
   "		//this.place.firstChild.onclick = function(e) { return false; }\n"
   "		this.place.firstChild.className = 'prot';\n"
   "		this.loadData = function( ) {\n"
   "		    if(!this.tmPrev) this.tmPrev = 0;\n"
   "		    if(!this.tmGrndPrev) this.tmGrndPrev = 0;\n"
   "\n"
   "		    var tblB = this.place.firstChild;\n"
   "\n"
   "		    //Get archive parameters\n"
   "		    var tTime = parseInt(this.attrs['time']);\n"
   "		    var tTimeCurent = false;\n"
   "		    if(!tTime) {\n"
   "			tTimeCurent = true;\n"
   "			tTime = (new Date()).getTime()/1000;\n"
   "		    }\n"
   "		    var srcTime = tTime;\n"
   "		    var tTimeGrnd = tTime - parseInt(this.attrs['tSize']);\n"
   "\n"
   "		    if(this.curCols != this.attrs['col'] || this.curArch != this.attrs['arch'] || this.curTmpl != this.attrs['tmpl'] ||\n"
   "			this.curLev != this.attrs['lev'] || this.headVis != this.attrs['headVis'])\n"
   "		    {\n"
   "			this.arhBeg = this.arhEnd = 0;\n"
   "			this.messList = new Array();\n"
   "\n"
   "			this['col_pos'] = this['col_tm'] = this['col_utm'] = this['col_lev'] = this['col_cat'] = this['col_mess'] = -1;\n"
   "			this.curCols = this.attrs['col'];\n"
   "			this.curArch = this.attrs['arch'];\n"
   "			this.curTmpl = this.attrs['tmpl'];\n"
   "			this.curLev = this.attrs['lev'];\n"
   "			this.headVis = this.attrs['headVis'];\n"
   "			while(tblB.childNodes.length) tblB.removeChild(tblB.lastChild);\n"
   "			var rowEl = document.createElement('tr');\n"
   "			tblB.appendChild(rowEl);\n"
   "			var colCfg = '';\n"
   "			var clm = this.curCols.split(';');\n"
   "			for(var c_off = 0; c_off < clm.length; c_off++) {\n"
   "			    if(!parseInt(this.attrs['headVis'])) colCfg += \"<th style='display: none' />\";\n"
   "			    else colCfg += \"<th ind='\"+clm[c_off]+\"' \"+\n"
   "						\"style='\"+this.wFont+\"'>\"+((clm[c_off]=='pos') ? '#' :\n"
   "						    (clm[c_off]=='tm') ? '###Date and time###' :\n"
   "						    (clm[c_off]=='utm') ? '###mcsec###' :\n"
   "						    (clm[c_off]=='lev') ? '###Level###' :\n"
   "						    (clm[c_off]=='cat') ? '###Category###' :\n"
   "						    (clm[c_off]=='mess') ? '###Message###' : '')+\"</th>\";\n"
   "			    this['col_'+clm[c_off]] = c_off;\n"
   "			}\n"
   "			rowEl.innerHTML = colCfg;\n"
   "		    }\n"
   "\n"
   "		    if(parseInt(this.curLev) < 0) this.messList = new Array();\n"
   "		    else {\n"
   "			if(!this.arhBeg || !this.arhEnd || !tTime || tTime > this.arhEnd || tTimeCurent) {\n"
   "			    var rez = servSet('/Archive/%2fserv%2fmess','com=com',\"<info arch='\"+this.curArch+\"'/>\");\n"
   "			    if(!rez || parseInt(rez.getAttribute('rez')) != 0)	this.arhBeg = this.arhEnd = 0;\n"
   "			    else {\n"
   "				this.arhBeg = parseInt(rez.getAttribute('beg'));\n"
   "				this.arhEnd = parseInt(rez.getAttribute('end'));\n"
   "				if(!tTime) { tTime = this.arhEnd; tTimeGrnd += tTime; }\n"
   "			    }\n"
   "			}\n"
   "			if(!this.arhBeg || !this.arhEnd) return;\n"
   "\n"
   "			//Correct request to archive border\n"
   "			tTime = tTimeCurent ? this.arhEnd : Math.min(tTime,this.arhEnd);\n"
   "			tTimeGrnd = Math.max(tTimeGrnd, this.arhBeg);\n"
   "		    }\n"
   "\n"
   "		    //Clear data at time error\n"
   "		    var valEnd = 0; var valBeg = 0;\n"
   "		    while(this.messList.length && (valEnd=this.messList[0][0]) > tTime) this.messList.shift();\n"
   "		    while(this.messList.length && (valBeg=this.messList[this.messList.length-1][0]) < tTimeGrnd) this.messList.pop();\n"
   "\n"
   "		    if(!this.messList.length) valEnd = valBeg = 0;\n"
   "\n"
   "		    if(tTime < tTimeGrnd || (tTime < valEnd && tTimeGrnd > valBeg)) {\n"
   "			this.messList = new Array();\n"
   "			while(tblB.childNodes.length > 1) tblB.removeChild(tblB.lastChild);\n"
   "			valEnd = valBeg = 0;\n"
   "			return;\n"
   "		    }\n"
   "\n"
   "		    //Correct request to present data\n"
   "		    var toUp = false, isDtChang = false;\n"
   "		    if(srcTime > this.tmPrev) { if(valEnd) tTimeGrnd = valEnd; toUp = true; }\n"
   "		    else if((srcTime-parseInt(this.attrs['tSize'])) < this.tmGrndPrev) { if(valBeg) tTime = valBeg-1; }\n"
   "		    else return;\n"
   "		    this.tmPrev = srcTime;\n"
   "		    this.tmGrndPrev = srcTime-parseInt(this.attrs['tSize']);\n"
   "\n"
   "		    var rez = servSet('/Archive/%2fserv%2fmess','com=com',\n"
   "			\"<get arch='\"+this.curArch+\"' tm='\"+tTime+\"' tm_grnd='\"+tTimeGrnd+\"' cat='\"+this.curTmpl+\"' lev='\"+this.curLev+\"' />\");\n"
   "		    if(!rez || parseInt(rez.getAttribute('rez')) != 0) return;\n"
   "\n"
   "		    if(toUp)\n"
   "			for(var i_req = 0; i_req < rez.childNodes.length; i_req++) {\n"
   "			    var rcd = rez.childNodes[i_req];\n"
   "			    var mess = new Array(parseInt(rcd.getAttribute('time')), parseInt(rcd.getAttribute('utime')),\n"
   "						    Math.abs(parseInt(rcd.getAttribute('lev'))), rcd.getAttribute('cat'), rcd.textContent);\n"
   "\n"
   "			    // Check for dublicates\n"
   "			    var isDbl = false;\n"
   "			    for(var iP = 0; !isDbl && iP < this.messList.length; iP++) {\n"
   "				if(mess[0] > this.messList[0][0] && iP) break;\n"
   "				if(this.messList[iP][1] == mess[1] && this.messList[iP][2] == mess[2] &&\n"
   "				    this.messList[iP][3] == mess[3] && this.messList[iP][4] == mess[4]) isDbl = true;\n"
   "			    }\n"
   "			    if(isDbl) continue;\n"
   "\n"
   "			    // Insert new row\n"
   "			    this.messList.unshift(mess);\n"
   "			    isDtChang = true;\n"
   "			}\n"
   "		    else\n"
   "			for(var i_req = rez.childNodes.length-1; i_req >= 0; i_req--) {\n"
   "			    var rcd = rez.childNodes[i_req];\n"
   "			    var mess = new Array(parseInt(rcd.getAttribute('time')), parseInt(rcd.getAttribute('utime')),\n"
   "						    Math.abs(parseInt(rcd.getAttribute('lev'))), rcd.getAttribute('cat'), rcd.textContent);\n"
   "\n"
   "			    // Check for dublicates\n"
   "			    var isDbl = false;\n"
   "			    for(var iP = this.messList.length-1; !isDbl && iP >= 0; iP--) {\n"
   "				if(mess[0] < this.messList[this.messList.length-1][0] && iP < (this.messList.length-1)) break;\n"
   "				if(this.messList[iP][1] == mess[1] && this.messList[iP][2] == mess[2] &&\n"
   "				    this.messList[iP][3] == mess[3] && this.messList[iP][4] == mess[4]) isDbl = true;\n"
   "			    }\n"
   "			    if(isDbl) continue;\n"
   "\n"
   "			    // Insert new row\n"
   "			    this.messList.push(mess);\n"
   "			    isDtChang = true;\n"
   "			}\n"
   "\n"
   "		    if((tblB.childNodes.length-1) == this.messList.length && !isDtChang) return;\n"
   "\n"
   "		    //Sort data\n"
   "		    var sortIts = new Array();\n"
   "		    switch(parseInt(this.attrs['viewOrd'])&0x3) {\n"
   "			case 0:\n"
   "			    for(var i_m = 0; i_m < this.messList.length; i_m++)\n"
   "				sortIts.push(this.messList[i_m][0]+' '+this.messList[i_m][1]+':'+i_m);\n"
   "			    break;\n"
   "			case 1:\n"
   "			    for(var i_m = 0; i_m < this.messList.length; i_m++)\n"
   "				sortIts.push(this.messList[i_m][2]+':'+i_m);\n"
   "			    break;\n"
   "			case 2:\n"
   "			    for(var i_m = 0; i_m < this.messList.length; i_m++)\n"
   "				sortIts.push(this.messList[i_m][3]+':'+i_m);\n"
   "			    break;\n"
   "			case 3:\n"
   "			    for(var i_m = 0; i_m < this.messList.length; i_m++)\n"
   "				sortIts.push_back(this.messList[i_m][4]+':'+i_m);\n"
   "			    break;\n"
   "		    }\n"
   "\n"
   "		    sortIts.sort();\n"
   "		    if(parseInt(this.attrs['viewOrd'])&0x4) sortIts.reverse();\n"
   "\n"
   "		    //Write to the table\n"
   "		    for(var i_m = 0; i_m < sortIts.length; i_m++) {\n"
   "			var rowEl = (i_m>=(tblB.childNodes.length-1)) ? document.createElement('tr') : tblB.childNodes[i_m+1];\n"
   "			var elPos = parseInt(sortIts[i_m].slice(sortIts[i_m].lastIndexOf(':')+1));\n"
   "\n"
   "			var rowFnt = this.wFont;\n"
   "			var rowColor = '';\n"
   "\n"
   "			// Check properties\n"
   "			for(var i_it = 0, lst_lev = -1; i_it < parseInt(this.attrs['itProp']); i_it++) {\n"
   "			    var prpLev = parseInt(this.attrs['it'+i_it+'lev']);\n"
   "			    if(this.messList[elPos][2] >= prpLev && prpLev > lst_lev &&\n"
   "				    chkPattern(this.messList[elPos][3],this.attrs['it'+i_it+'tmpl']))\n"
   "			    {\n"
   "				var tRowFnt = getFont(this.attrs['it'+i_it+'fnt'], Math.min(xSc,ySc));\n"
   "				if(tRowFnt.length) rowFnt = tRowFnt;\n"
   "				rowColor = 'background-color: '+getColor(this.attrs['it'+i_it+'color'])+'; ';\n"
   "				if(this.messList[elPos][2] == parseInt(this.attrs['it'+i_it+'lev'])) break;\n"
   "				lst_lev = prpLev;\n"
   "			    }\n"
   "			}\n"
   "			//if( rowColor.length ) fclr = ((0.3*clr.red()+0.59*clr.green()+0.11*clr.blue()) > 128) ? Qt::black : Qt::white;\n"
   "			rowEl.style.cssText = rowFnt+rowColor;\n"
   "\n"
   "			for(var i_cel = 0; i_cel < tblB.childNodes[0].childNodes.length; i_cel++) {\n"
   "			    var celEl = (i_cel>=rowEl.childNodes.length) ? document.createElement('td') : rowEl.childNodes[i_cel];\n"
   "			    if(this.col_pos == i_cel) { celEl.textContent = i_m; celEl.style.cssText += ' text-align: center; '; }\n"
   "			    else if(this.col_tm == i_cel) {\n"
   "				var dt = new Date(this.messList[elPos][0]*1000);\n"
   "				celEl.textContent = dt.getDate()+'.'+(dt.getMonth()+1)+'.'+dt.getFullYear()+' '+dt.getHours()+':'+\n"
   "				    ((dt.getMinutes()<10)?('0'+dt.getMinutes()):dt.getMinutes())+':'+((dt.getSeconds()<10)?('0'+dt.getSeconds()):dt.getSeconds());\n"
   "			    }\n"
   "			    else if(this.col_utm == i_cel)	celEl.textContent = this.messList[elPos][1];\n"
   "			    else if(this.col_lev == i_cel)	celEl.textContent = this.messList[elPos][2];\n"
   "			    else if(this.col_cat == i_cel)	celEl.textContent = this.messList[elPos][3];\n"
   "			    else if(this.col_mess == i_cel)	celEl.textContent = this.messList[elPos][4];\n"
   "			    if(i_cel >= rowEl.childNodes.length) rowEl.appendChild(celEl);\n"
   "			}\n"
   "			if(i_m >= (tblB.childNodes.length-1)) tblB.appendChild(rowEl);\n"
   "		    }\n"
   "		    while((tblB.childNodes.length-1) > sortIts.length) tblB.removeChild(tblB.lastChild);\n"
   "		}\n"
   "	    }\n"
   "\n"
   "	    if(this.isEnabled() && parseInt(this.attrs['trcPer'])) this.perUpdtEn(true);\n"
   "	    else { this.perUpdtEn(false); this.loadData(); }\n"
   "	}\n"
   "	else if(this.attrs['root'] == 'Document') {\n"
   "	    elStyle += 'pointer-events: all; background-color: white; ';\n"
   "\n"
   "	    if(this.attrsMdf[\"style\"] || this.attrsMdf[\"font\"] ||\n"
   "		(this.attrsMdf[\"doc\"] && this.attrs[\"doc\"].length) || (this.attrsMdf[\"tmpl\"] && !this.attrs[\"doc\"].length))\n"
   "	    {\n"
   "		this.wFont = getFont(this.attrs['font'], Math.min(xSc,ySc),1);\n"
   "\n"
   "		var ifrmObj = this.place.childNodes[0];\n"
   "		try {\n"
   "		    if(ifrmObj && (!ifrmObj.contentDocument || document.URL != ifrmObj.contentDocument.URL))\n"
   "		    { this.place.removeChild(ifrmObj); ifrmObj = null; }\n"
   "		}catch(e) { this.place.removeChild(ifrmObj); ifrmObj = null; }\n"
   "		if(!ifrmObj) {\n"
   "		    ifrmObj = this.place.ownerDocument.createElement('iframe');\n"
   "		    this.place.appendChild(ifrmObj);\n"
   "		}\n"
   "\n"
   "		ifrmObj.style.cssText = 'width: '+geomW+'px; height: '+geomH+'px; border-style: ridge; border-width: 0px; padding: 0px;';\n"
   "		//ifrmObj.style.cssText = 'width: '+(geomW-14)+'px; height: '+(geomH-14)+'px; border-style: ridge; border-width: 2px; padding: 5px;';\n"
   "		this.perUpdtEn(true);\n"
   "	    }\n"
   "	}\n"
   "	elStyle += 'width: ' + geomW + 'px; height: ' + geomH + 'px; z-index: ' + this.attrs['geomZ'] + '; margin: ' + elMargin + 'px; ';\n"
   "	//Scroll for the included containers correct\n"
   "	if(this.inclOpen) {\n"
   "	    var geomWpar = parseFloat(this.attrs['geomW'])*this.xScale(true);\n"
   "	    var geomHpar = parseFloat(this.attrs['geomH'])*this.yScale(true);\n"
   "	    var geomWch = parseFloat(this.pages[this.inclOpen].attrs['geomW'])*this.pages[this.inclOpen].xScale(true);\n"
   "	    var geomHch = parseFloat(this.pages[this.inclOpen].attrs['geomH'])*this.pages[this.inclOpen].yScale(true);\n"
   "	    elStyle += \"overflow: \"+((geomWch > geomWpar || geomHch > geomHpar) ? 'auto' : 'hidden')+\"; \";\n"
   "	}\n"
   "	else if(isPrim) {\n"
   "	    // Border processing in generic\n"
   "	    if(this.attrs['bordColor']) elStyle += 'border-color: '+getColor(this.attrs['bordColor'])+'; ';\n"
   "	    switch(parseInt(this.attrs['bordStyle'])) {\n"
   "		case 1: elStyle += 'border-style: dotted; '; break;\n"
   "		case 2: elStyle += 'border-style: dashed; '; break;\n"
   "		case 3: elStyle += 'border-style: solid; ';  break;\n"
   "		case 4: elStyle += 'border-style: double; '; break;\n"
   "		case 5: elStyle += 'border-style: groove; '; break;\n"
   "		case 6: elStyle += 'border-style: ridge; ';  break;\n"
   "		case 7: elStyle += 'border-style: inset; ';  break;\n"
   "		case 8: elStyle += 'border-style: outset; '; break;\n"
   "	    }\n"
   "	    // Background processing in generic\n"
   "	    backStyle = \"\";\n"
   "	    if(this.attrs['backColor'] && (backOp=getColor(this.attrs['backColor'],true))) {\n"
   "		if(backOp == 1) {\n"
   "		    backStyle += 'background-color: '+getColor(this.attrs['backColor'])+'; ';\n"
   "		    if(this.placeTr) this.placeTr.style.cssText = elStyle;\n"
   "		}\n"
   "		else {\n"
   "		    if(!this.placeTr) {\n"
   "			this.placeTr = this.place.ownerDocument.createElement('div');\n"
   "			this.place.parentNode.appendChild(this.placeTr);\n"
   "		    }\n"
   "		    this.placeTr.style.cssText = elStyle + 'background-color: '+getColor(this.attrs['backColor'])+'; opacity: '+backOp+\"; z-index: \"+(parseInt(this.attrs['geomZ'])-1)+\"; \";\n"
   "		}\n"
   "	    }\n"
   "	    if(this.attrs['backImg'])	backStyle += 'background-image: url(\\'/'+MOD_ID+this.addr+'?com=res&val='+this.attrs['backImg']+'\\'); ';\n"
   "	    elStyle += backStyle;\n"
   "	    if(this == masterPage) document.body.style.cssText = parseInt(this.attrs['bordWidth']) ? '' : backStyle;\n"
   "	}\n"
   "\n"
   "	if(elStyle != this.place.style.cssText)	this.place.style.cssText = elStyle;\n"
   "\n"
   "	//Generic events process\n"
   "	if(elWr) {\n"
   "	    this.mousedown[this.mousedown.length] = function(e,el) {\n"
   "		setWAttrs(el.wdgLnk.addr,'event','key_mousePres'+evMouseGet(e));\n"
   "		setFocus(el.wdgLnk.addr);\n"
   "	    }\n"
   "	    this.mouseup[this.mouseup.length] = function(e,el) {\n"
   "		setWAttrs(el.wdgLnk.addr,'event','key_mouseRels'+evMouseGet(e));\n"
   "		if(!el.isSpecFocus) el.focus();\n"
   "	    }\n"
   "	}\n"
   "	if(!this.place.isSpecFocus) {\n"
   "	    if(elWr != this.place.elWr || this.attrsMdf['geomZ']) {\n"
   "		if(elWr) this.place.setAttribute('tabIndex', getTabIndex(this,parseInt(this.attrs['geomZ'])));\n"
   "		else this.place.removeAttribute('tabIndex');\n"
   "		this.place.focusElem = elWr ? this.place : null;\n"
   "	    }\n"
   "	    if(elWr != this.place.elWr) this.place.onfocus = !elWr ? null : function(e) { setFocus(this.wdgLnk.addr); }\n"
   "	}\n"
   "	if(elWr != this.place.elWr) {\n"
   "	    this.place.ondblclick = !elWr ? null : function(e) { setWAttrs(this.wdgLnk.addr,'event','key_mouseDblClick'); return false; }\n"
   "	    this.place.onkeydown = !elWr ? null : function(e) {\n"
   "		e = e ? e : window.event;\n"
   "		setWAttrs(this.wdgLnk.addr,'event','key_pres'+(e.ctrlKey?\"Ctrl\":\"\")+(e.altKey?\"Alt\":\"\")+(e.shiftKey?\"Shift\":\"\")+evKeyGet(e));\n"
   "	    }\n"
   "	    this.place.onkeyup = !elWr ? null : function(e) {\n"
   "		e = e ? e : window.event;\n"
   "		setWAttrs(this.wdgLnk.addr,'event','key_rels'+(e.ctrlKey?\"Ctrl\":\"\")+(e.altKey?\"Alt\":\"\")+(e.shiftKey?\"Shift\":\"\")+evKeyGet(e));\n"
   "	    }\n"
   "	}\n"
   "\n"
   "	//Context menu setup\n"
   "	if(elWr && this.attrs['contextMenu'].length) {\n"
   "	    var ctxEv = function(e,el) {\n"
   "		var cel = el ? el : this;\n"
   "		if(!e) e = window.event;\n"
   "		if((isKonq || isOpera) && evMouseGet(e) != 'Right') return true;\n"
   "		var popUpMenu = getPopup();\n"
   "		var optEl = '';\n"
   "		var cntxEls = cel.wdgLnk.attrs['contextMenu'].split('\\n');\n"
   "		for(var i_ce = 0; i_ce < cntxEls.length; i_ce++)\n"
   "		    optEl += \"<option sign='\"+cntxEls[i_ce].split(':')[1]+\"'>\"+cntxEls[i_ce].split(':')[0]+\"</option>\";\n"
   "		popUpMenu.childNodes[0].innerHTML = optEl;\n"
   "		if(popUpMenu.childNodes[0].childNodes.length) {\n"
   "		    popUpMenu.childNodes[0].wdgLnk = cel.wdgLnk;\n"
   "		    popUpMenu.childNodes[0].size = Math.max(3,popUpMenu.childNodes[0].childNodes.length);\n"
   "		    popUpMenu.style.cssText = 'visibility: visible; left: '+(e.clientX+window.pageXOffset)+'px; top: '+(e.clientY+window.pageYOffset)+'px;';\n"
   "		    popUpMenu.childNodes[0].selectedIndex = -1;\n"
   "		    popUpMenu.childNodes[0].onclick = function( ) {\n"
   "			this.parentNode.style.cssText = 'visibility: hidden; left: -200px; top: -200px;';\n"
   "			if(this.selectedIndex < 0) return false;\n"
   "			setWAttrs(this.wdgLnk.addr,'event','usr_'+this.options[this.selectedIndex].getAttribute('sign'));\n"
   "			return false;\n"
   "		    }\n"
   "		}\n"
   "		return false;\n"
   "	    }\n"
   "	    if(isKonq || isOpera) this.mousedown[this.mousedown.length] = ctxEv;\n"
   "	    else this.place.oncontextmenu = ctxEv;\n"
   "	}\n"
   "	else if(elWr) this.place.oncontextmenu = function(e) { return false; };\n"
   "	else this.place.oncontextmenu = null;\n"
   "\n"
   "	//Common mouse events processing\n"
   "	if(this.mousedown.length)\n"
   "	    this.place.onmousedown = function(e) {\n"
   "		if(!e) e = window.event;\n"
   "		if(e.elPrc) return true;\n"
   "		e.elPrc = true;\n"
   "		for(var iOn = 0; iOn < this.wdgLnk.mousedown.length; iOn++)\n"
   "		    this.wdgLnk.mousedown[iOn](e, this);\n"
   "		return true;\n"
   "	    }\n"
   "	else delete this.mousedown;\n"
   "	if(this.mouseup.length)\n"
   "	    this.place.onmouseup = function(e) {\n"
   "		if(!e) e = window.event;\n"
   "		if(e.elPrc) return true;\n"
   "		e.elPrc = true;\n"
   "		for(var iOn = 0; iOn < this.wdgLnk.mouseup.length; iOn++)\n"
   "		    this.wdgLnk.mouseup[iOn](e,this);\n"
   "		return true;\n"
   "	    }\n"
   "	else delete this.mouseup;\n"
   "\n"
   "	this.place.elWr = elWr;\n"
   "    }\n"
   "    if(margBrdUpd || this.attrsMdf[\"geomXsc\"] || this.attrsMdf[\"geomYsc\"]) for(var i in this.wdgs) this.wdgs[i].makeEl();\n"
   "    if(this.attrs['tipTool'] && this.attrs['tipTool'].length) this.place.setAttribute('title', this.attrs['tipTool']);\n"
   "    else this.place.removeAttribute('title');\n"
   "    this.place.onmouseover = function(e) {\n"
   "	if(this.wdgLnk.attrs['tipStatus']) {\n"
   "	    setStatus(this.wdgLnk.attrs['tipStatus'], 10000);\n"
   "	    e.stopPropagation();\n"
   "	}\n"
   "    };\n"
   "\n"
   "    //Checking for deletion the child widgets\n"
   "    if(FullTree && pgBr)\n"
   "	for(var i in this.wdgs) {\n"
   "	    var j;\n"
   "	    for(j = 0; j < pgBr.childNodes.length; j++)\n"
   "		if(pgBr.childNodes[j].nodeName == 'w' && pgBr.childNodes[j].getAttribute('id') == i)\n"
   "		    break;\n"
   "	    if(j >= pgBr.childNodes.length) {\n"
   "		this.wdgs[i].place.parentNode.removeChild(this.wdgs[i].place);\n"
   "		if(this.wdgs[i].placeTr)\n"
   "		    this.wdgs[i].placeTr.parentNode.removeChild(this.wdgs[i].placeTr);\n"
   "		delete this.wdgs[i];\n"
   "	    }\n"
   "	}\n"
   "\n"
   "    //Child widgets process\n"
   "    if(pgBr && !inclPg && parseInt(this.attrs['perm'])&SEC_RD) {\n"
   "	for(var j = 0; j < pgBr.childNodes.length; j++) {\n"
   "	    if(pgBr.childNodes[j].nodeName != 'w') continue;\n"
   "	    var chEl = pgBr.childNodes[j].getAttribute('id');\n"
   "	    if(this.wdgs[chEl]) this.wdgs[chEl].makeEl(pgBr.childNodes[j], false, full, FullTree);\n"
   "	    else {\n"
   "		var wdgO = new pwDescr(this.addr+'/wdg_'+chEl, false, this);\n"
   "		wdgO.wPos = j;\n"
   "		wdgO.place = this.place.ownerDocument.createElement('div');\n"
   "		this.place.appendChild(wdgO.place);\n"
   "		this.wdgs[chEl] = wdgO;\n"
   "		wdgO.makeEl(full?pgBr.childNodes[j]:servGet(wdgO.addr,'com=attrsBr'), false, full, FullTree);\n"
   "		//wdgO.makeEl(pgBr.childNodes[j]);		//!!!! Need full\n"
   "	    }\n"
   "	}\n"
   "    }\n"
   "}\n"
   "\n"
   "function pwClean( complete )\n"
   "{\n"
   "    if(this.pg)	{\n"
   "	ntfReg(-1, '', this.addr);\n"
   "	for(iNtf = 0; iNtf < 8; iNtf++)\n"
   "	    if(this.attrs[\"notifyVis\"+MOD_ID+iNtf]) delete this.attrs[\"notifyVis\"+MOD_ID+iNtf];\n"
   "	    else if(this.attrs[\"notify\"+iNtf]) delete this.attrs[\"notify\"+iNtf];\n"
   "    }\n"
   "\n"
   "    for(var i in this.pages) this.pages[i].pwClean(complete);\n"
   "    for(var i in this.wdgs) this.wdgs[i].pwClean(complete);\n"
   "\n"
   "    if(complete) {\n"
   "	this.perUpdtEn(false);		//Periodic update disable\n"
   "	this.pages = new Object()	//Pages recursively clean;\n"
   "	this.wdgs = new Object();	//Widgets recursively clean\n"
   "    }\n"
   "}\n"
   "\n"
   "function perUpdtEn( en )\n"
   "{\n"
   "    if(this.attrs['root'] == 'Diagram' || this.attrs['root'] == 'Protocol') {\n"
   "	if(en && this.isEnabled() && !perUpdtWdgs[this.addr] && parseInt(this.attrs['trcPer']))	perUpdtWdgs[this.addr] = this;\n"
   "	if(!en && perUpdtWdgs[this.addr]) delete perUpdtWdgs[this.addr];\n"
   "    }\n"
   "    else if(this.attrs['root'] == 'Document' || this.attrs['root'] == 'FormEl' || this.attrs['root'] == 'Media') {\n"
   "	if(en) perUpdtWdgs[this.addr] = this;\n"
   "	else delete perUpdtWdgs[this.addr];\n"
   "    }\n"
   "    for(var i in this.wdgs) this.wdgs[i].perUpdtEn(en);	//!!!! To restore updating of elements like to Document after returning from the cache\n"
   "}\n"
   "\n"
   "function perUpdt( )\n"
   "{\n"
   "    if(this.attrs['root'] == 'FormEl') {\n"
   "	if(parseInt(this.attrs['elType']) == 9 && this.toReFit) {	//Table type post adjust\n"
   "	    if(!(tblWdth=this.place.clientWidth)) return;		//Waiting the table drawing\n"
   "	    var tblWdthSum = 0;\n"
   "	    hdrRow = this.place.childNodes[0].tHead.rows[0];\n"
   "	    if(hdrRow.style.display == \"none\") hdrRow = this.place.childNodes[0].tBodies[0].rows[0];\n"
   "\n"
   "	    //Clearing the fitting\n"
   "	    if(this.toReFitForce) {\n"
   "		this.place.childNodes[0].style.tableLayout = \"auto\";\n"
   "		this.place.childNodes[0].style.width = \"\";\n"
   "		for(iC = 0; iC < hdrRow.cells.length; iC++)\n"
   "		    hdrRow.cells[iC].style.width = hdrRow.cells[iC].widthSrc ? hdrRow.cells[iC].widthSrc : null;\n"
   "	    }\n"
   "\n"
   "	    //The same fitting\n"
   "	    for(iC = 0; iC < hdrRow.cells.length; iC++) {\n"
   "		if(hdrRow.cells[iC].style.display == \"none\")	continue;\n"
   "		if(!hdrRow.cells[iC].style.width.length) {\n"
   "		    tblWdthSum += hdrRow.cells[iC].clientWidth;\n"
   "		    hdrRow.cells[iC].style.width = hdrRow.cells[iC].clientWidth+\"px\";\n"
   "		}\n"
   "		else if(hdrRow.cells[iC].style.width.indexOf(\"%\") >= 0) {\n"
   "		    hdrRow.cells[iC].style.width = (parseInt(hdrRow.cells[iC].style.width)*tblWdth/100) + \"px\";\n"
   "		    tblWdthSum += parseInt(hdrRow.cells[iC].style.width);\n"
   "		}\n"
   "		else tblWdthSum += parseInt(hdrRow.cells[iC].style.width);\n"
   "	    }\n"
   "	    this.place.childNodes[0].style.width = tblWdthSum+\"px\";\n"
   "	    this.place.childNodes[0].style.tableLayout = \"fixed\";\n"
   "	    this.toReFit = this.toReFitForce = false;\n"
   "	    this.perUpdtEn(false);\n"
   "\n"
   "	    this.place.onscroll(null, true);\n"
   "	}\n"
   "	else if(this.place.childNodes.length && this.place.firstChild.tmClearEdit && (this.place.firstChild.tmClearEdit-=prcTm) <= 0) {\n"
   "	    if(this.place.confirm) this.place.firstChild.chEscape();\n"
   "	    else this.place.firstChild.chApply();\n"
   "	}\n"
   "    }\n"
   "    else if(this.attrs['root'] == 'Diagram' && (this.updCntr-=prcTm) <= 0) {\n"
   "	this.updCntr = parseInt(this.attrs['trcPer']);\n"
   "	var dgrObj = this.place.childNodes[0];\n"
   "	if(!dgrObj.stLoadTm) dgrObj.stLoadTm = (new Date()).getTime();\n"
   "	if(dgrObj && (dgrObj.isLoad || ((new Date()).getTime()-dgrObj.stLoadTm) > this.updCntr*3000)) {\n"
   "	    dgrObj.isLoad = false;\n"
   "	    dgrObj.src = '/'+MOD_ID+this.addr+'?com=obj&tm='+tmCnt+'&xSc='+this.xScale(true).toFixed(3)+'&ySc='+this.yScale(true).toFixed(3);\n"
   "	    dgrObj.stLoadTm = (new Date()).getTime();\n"
   "	}\n"
   "    }\n"
   "    else if(this.attrs['root'] == 'Media' && (this.updCntr-=prcTm) <= 0) {\n"
   "	this.updCntr = 10;\n"
   "	var videoObj = this.place.childNodes[0];\n"
   "\n"
   "	if(videoObj.currentTime) setWAttrs(this.addr,'seek',videoObj.currentTime.toFixed(1));\n"
   "    }\n"
   "    else if(this.attrs['root'] == 'Protocol' && (this.updCntr-=prcTm) <= 0) {\n"
   "	this.updCntr = parseInt(this.attrs['trcPer']);\n"
   "	this.loadData();\n"
   "    }\n"
   "    else if(this.attrs['root'] == 'Document') {\n"
   "	var frDoc = this.place.childNodes[0].contentDocument || this.place.childNodes[0].contentWindow || this.place.childNodes[0].document;\n"
   "	if(frDoc) {	//Sometimes can be null\n"
   "	    frDoc.open();\n"
   "	    frDoc.write(\"<html><head>\\n\"+\n"
   "		\"<style type='text/css'>\\n\"+\n"
   "		\" * { \"+this.wFont+\" }\\n\"+\n"
   "		\" big { font-size: 120%; }\\n\"+\n"
   "		\" small { font-size: 90%; }\\n\"+\n"
   "		\" h1 { font-size: 200%; }\\n\"+\n"
   "		\" h2 { font-size: 150%; }\\n\"+\n"
   "		\" h3 { font-size: 120%; }\\n\"+\n"
   "		\" h4 { font-size: 105%; }\\n\"+\n"
   "		\" h5 { font-size: 95%; }\\n\"+\n"
   "		\" h6 { font-size: 70%; }\\n\"+\n"
   "		\" u,b,i { font-size : inherit; }\\n\"+\n"
   "		\" sup,sub { font-size: 80%; }\\n\"+\n"
   "		\" th { font-weight: bold; }\\n\"+\n"
   "		this.attrs['style']+\"</style>\"+\n"
   "		\"</head>\"+(this.attrs['doc']?this.attrs['doc']:this.attrs['tmpl'])+\"</html>\");\n"
   "	    frDoc.close();\n"
   "	    frDoc.body.wdgLnk = this;\n"
   "	    frDoc.body.isActive = (parseInt(this.attrs['active']) && parseInt(this.attrs['perm'])&SEC_WR);\n"
   "	    frDoc.body.onclick = function(e) {\n"
   "		if(this.isActive) setFocus(this.wdgLnk.addr);\n"
   "		return true;\n"
   "	    }\n"
   "	}\n"
   "	this.perUpdtEn(false);\n"
   "    }\n"
   "}\n"
   "\n"
   "function xScale( full )\n"
   "{\n"
   "    var rez = parseFloat(this.attrs['geomXsc'])\n"
   "    if(!full) return rez;\n"
   "    if(!this.pg) return rez*this.parent.xScale(full);\n"
   "    return rez * wx_scale;\n"
   "}\n"
   "\n"
   "function yScale( full )\n"
   "{\n"
   "    var rez = parseFloat(this.attrs['geomYsc'])\n"
   "    if(!full) return rez;\n"
   "    if(!this.pg) return rez*this.parent.yScale(full);\n"
   "    return rez * wy_scale;\n"
   "}\n"
   "\n"
   "function isEnabled( )\n"
   "{\n"
   "    var rez = parseInt(this.attrs['en']);\n"
   "    if(!rez || this.pg) return rez;\n"
   "    return this.parent.isEnabled();\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * pwDescr - Page/widget descriptor object         *\n"
   " ***************************************************/\n"
   "function pwDescr( pgAddr, pg, parent )\n"
   "{\n"
   "    this.addr = pgAddr;\n"
   "    this.pages = new Object();\n"
   "    this.wdgs = new Object();\n"
   "    this.attrs = new Object();\n"
   "    this.attrsMdf = new Object();\n"
   "    this.pg = pg;\n"
   "    this.parent = parent;\n"
   "    this.window = null;\n"
   "    this.windowExt = false;\n"
   "    this.place = null;\n"
   "    this.callPage = callPage;\n"
   "    this.findOpenPage = findOpenPage;\n"
   "    this.makeEl = makeEl;\n"
   "    this.pwClean = pwClean;\n"
   "    this.perUpdtEn = perUpdtEn;\n"
   "    this.perUpdt = perUpdt;\n"
   "    this.xScale = xScale;\n"
   "    this.yScale = yScale;\n"
   "    this.isEnabled = isEnabled;\n"
   "    this.updCntr = 0;\n"
   "    this.wPos = -1;\n"
   "}\n"
   "/***************************************************\n"
   " * makeUI                                          *\n"
   " ***************************************************/\n"
   "function makeUI( callBackRez )\n"
   "{\n"
   "    if(!callBackRez) stTmMain = new Date();\n"
   "    else prcCnt = (callBackRez == -1) ? Math.min(0,prcCnt) - 1 :  Math.max(0,prcCnt) + 1;\n"
   "\n"
   "    //Get open pages list\n"
   "    // Synchronous\n"
   "    //var pgNode = servGet('/'+sessId,'com=pgOpenList&tm='+tmCnt);\n"
   "    // Asynchronous\n"
   "    var pgNode = null;\n"
   "    if(callBackRez) pgNode = (callBackRez == -1) ? null : callBackRez;\n"
   "    else { servGet('/'+sessId,'com=pgOpenList&tm='+tmCnt,makeUI); return; }\n"
   "    if(pgNode) {\n"
   "	// Getting for the styles\n"
   "	if(tmCnt == 0)	modelStyles = servGet('/'+sessId,'com=style');\n"
   "\n"
   "	modelPer = parseInt(pgNode.getAttribute(\"per\"));\n"
   "	if((alrmUpdCnt+=planePer) > tmAlrmUpd) { alarmSet(parseInt(pgNode.getAttribute(\"alarmSt\"))); alrmUpdCnt = 0; }\n"
   "	cachePgSz   = parseInt(pgNode.getAttribute(\"cachePgSz\"));\n"
   "	cachePgLife = parseFloat(pgNode.getAttribute(\"cachePgLife\"));\n"
   "	// Checking for deleting the pages\n"
   "	for(var iP = 0; iP < pgList.length; iP++) {\n"
   "	    var opPg; var iCh;\n"
   "	    for(iCh = 0; iCh < pgNode.childNodes.length; iCh++)\n"
   "		if(pgNode.childNodes[iCh].nodeName == 'pg' && pgNode.childNodes[iCh].textContent == pgList[iP])\n"
   "		    break;\n"
   "	    if(iCh < pgNode.childNodes.length || !(opPg=masterPage.findOpenPage(pgList[iP]))) continue;\n"
   "	    if(opPg.window) {\n"
   "		if(opPg.windowExt) opPg.window.close();\n"
   "		else if(opPg != masterPage) document.getElementById('mainCntr').removeChild(opPg.window);\n"
   "		else {\n"
   "		    document.body.removeChild(opPg.window);\n"
   "		    masterPage = new pwDescr('', true);\n"
   "		}\n"
   "		if(opPg.parent)	delete opPg.parent.pages[pgList[iP]];\n"
   "	    }\n"
   "	    else if(opPg.parent && opPg.parent.inclOpen && opPg.parent.inclOpen == pgList[iP])\n"
   "	    { opPg.parent.attrs['pgOpenSrc'] = ''; opPg.parent.makeEl(null, true); }\n"
   "	}\n"
   "	// Processing the opened pages\n"
   "	pgList = new Array();\n"
   "	//  Updating for activity the pages appointed for close\n"
   "	for(var iPg in pgCloseList) pgCloseList[iPg].act = false;\n"
   "	//  Processing the opened pages\n"
   "	for(var iCh = 0, iCh2 = 0; iCh < pgNode.childNodes.length; ++iCh) {\n"
   "	    var chN = pgNode.childNodes[iCh];\n"
   "	    if(chN.nodeName != 'pg') continue;\n"
   "	    //  Checking for closed windows\n"
   "	    var opPg = masterPage.findOpenPage(chN.textContent);\n"
   "	    if(opPg && opPg.window && opPg.windowExt && opPg.window.closed) {\n"
   "		servSet(chN.textContent, 'com=pgClose&cacheCntr', '');\n"
   "		opPg.pwClean(true);\n"
   "		delete opPg.parent.pages[chN.textContent];\n"
   "		continue;\n"
   "	    }\n"
   "\n"
   "	    //  Register the page\n"
   "	    pgList.push(chN.textContent);\n"
   "\n"
   "	    //  Detection the double container pages and opening the last one\n"
   "	    if(chN.getAttribute('pgGrp') && chN.getAttribute('pgGrp') != 'main' && chN.getAttribute('pgGrp') != 'fl') {\n"
   "		for(iCh2 = iCh+1; iCh2 < pgNode.childNodes.length; ++iCh2)\n"
   "		    if(pgNode.childNodes[iCh2].getAttribute('pgGrp') == chN.getAttribute('pgGrp'))\n"
   "			break;\n"
   "		if(iCh2 < pgNode.childNodes.length) {\n"
   "		    //  Mark the page for closing after several times\n"
   "		    if(pgCloseList[chN.textContent] == null) {\n"
   "			pgCloseList[chN.textContent] = new Object();\n"
   "			pgCloseList[chN.textContent].cnt = 0;\n"
   "		    } else pgCloseList[chN.textContent].cnt++;\n"
   "		    pgCloseList[chN.textContent].act = true;\n"
   "\n"
   "		    //servSet(chN.textContent, 'com=pgClose', '');//Force closing lost opened and included pages\n"
   "		    continue;\n"
   "		}\n"
   "	    }\n"
   "\n"
   "	    //  Opening\n"
   "	    masterPage.callPage(chN.textContent, parseInt(chN.getAttribute('updWdg')));\n"
   "	}\n"
   "	//  Real closing the spare included pages\n"
   "	for(var iPg in pgCloseList)\n"
   "	    if(!pgCloseList[iPg].act) delete pgCloseList[iPg];\n"
   "	    else if(pgCloseList[iPg].cnt > 2) servSet(iPg, 'com=pgClose', '');\n"
   "\n"
   "	tmCnt_ = parseInt(pgNode.getAttribute('tm'));\n"
   "	if((tmCnt_-tmCnt) < -10) window.location.reload();	//The server or the counter restarted - reload the session\n"
   "	tmCnt = tmCnt_;\n"
   "    }\n"
   "    else if(prcCnt < 10) window.location.reload();\n"
   "\n"
   "    //Update some widgets\n"
   "    for(var i in perUpdtWdgs) perUpdtWdgs[i].perUpdt();\n"
   "\n"
   "    //Processing for the cache lifetime\n"
   "    pgCacheProc();\n"
   "\n"
   "    //Elapsed time get and adjust for plane update period depends from the network speed\n"
   "    var elTm = 1e-3*((new Date()).getTime()-stTmMain.getTime());\n"
   "    if(!planePer) planePer = 1e-3*modelPer;\n"
   "    planePer = Math.min(Math.max(1e-3*modelPer,(toFastCycle?0:elTm*5)), planePer + (Math.max(1e-3*modelPer,elTm*2)-planePer)/100);\n"
   "    var sleepTm = Math.max(0, planePer-elTm);\n"
   "    prcTm = elTm + sleepTm;\n"
   "    toFastCycle = false;\n"
   "\n"
   "    // The frontend status request\n"
   "    if(pgNode && parseInt(pgNode.getAttribute(\"fStatusOrder\")))\n"
   "	servSet('/'+sessId, 'com=fStatus', \"Counter=\"+tmCnt_+\"; \"+\n"
   "	    \"Period: \"+prcTm.toPrecision(3)+\"<\"+planePer.toPrecision(3)+\"(\"+(1e-3*modelPer).toPrecision(3)+\")s, \"+\n"
   "	    \"Time elapsed: \"+elTm.toPrecision(3)+\"s, sleep: \"+sleepTm.toPrecision(3)+\"s.\", true);\n"
   "\n"
   "    mainTmId = setTimeout(makeUI, sleepTm*1e3);\n"
   "\n"
   "    //Execution the performance test\n"
   "    /*var startChkTm = (new Date()).getTime();\n"
   "    for(var i_cnt = 0; i_cnt < 1000000; i_cnt++)\n"
   "	var trez = Math.sin(Math.PI);\n"
   "    var stopChkTm = (new Date()).getTime();\n"
   "    console.log(\"sin(PI): \"+(stopChkTm-startChkTm)+\"ms; trez: \"+trez);*/\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * setStatus - Setup status message.               *\n"
   " ***************************************************/\n"
   "function setStatus( mess, tm )\n"
   "{\n"
   "    if(!mess) mess = '';\n"
   "    if(masterPage && masterPage.status && (stb=document.getElementById('StatusBar'))) stb.innerText = mess;\n"
   "    else window.status = mess;\n"
   "    if(!mess) return;\n"
   "    if(stTmID) clearTimeout(stTmID);\n"
   "    if(!tm || tm > 0) stTmID = setTimeout('setStatus(null)', tm?tm:1000);\n"
   "}\n"
   "\n"
   "/**************************************************\n"
   " * getPopup - Get popup menu.                     *\n"
   " **************************************************/\n"
   "function getPopup( )\n"
   "{\n"
   "    var popUpMenu = document.getElementById('popupmenu');\n"
   "    if(!popUpMenu) {\n"
   "	popUpMenu = document.createElement('div'); popUpMenu.id = 'popupmenu';\n"
   "	popUpMenu.appendChild(document.createElement('select'));\n"
   "	document.body.appendChild(popUpMenu);\n"
   "	popUpMenu.style.visibility = 'hidden';\n"
   "    }\n"
   "    return popUpMenu;\n"
   "}\n"
   "\n"
   "/**************************************************\n"
   " * getTree - Get the items tree                   *\n"
   " **************************************************/\n"
   "function getTree( )\n"
   "{\n"
   "    var formObj = document.createElement('ul');\n"
   "    formObj.finish = function(lit, selIt) {\n"
   "	this.style.cssText += 'font-style: italic; ';\n"
   "	if(selIt && !selIt.length) return false;\n"
   "	var cnt = lit ? lit.children[2] : this;\n"
   "	imgSz = Math.floor(Math.max(16,parseInt(this.style.fontSize)*1.14));\n"
   "	for(var iIt = cnt.children.length-1; iIt >= 0; iIt--) {\n"
   "	    var oIt = cnt.children[iIt];\n"
   "	    if(selIt) {\n"
   "		if(selIt == oIt.itPath) { oIt.classList.add(\"select\"); this.mSelIt = oIt; return true; }\n"
   "		if(this.finish(oIt,selIt)) oIt.itExp = true;\n"
   "	    }\n"
   "	    else {\n"
   "		if(oIt.itMdf != this.itMdf) { cnt.removeChild(oIt); continue; }\n"
   "		this.finish(oIt);\n"
   "		oIt.children[2].style.backgroundImage = (oIt!=cnt.lastChild?\"url(/\"+MOD_ID+\"/img_treeLine)\":\"\");\n"
   "	    }\n"
   "	    isExpandable = oIt.children[2].children.length;\n"
   "	    oIt.children[0].src = \"/\"+MOD_ID+\"/img_tree\"+\n"
   "		(isExpandable?(oIt.itExp?\"Minus\":\"Plus\"):\"\")+\n"
   "		\"Up\"+(oIt!=cnt.lastChild?\"Down\":\"\");\n"
   "	    oIt.children[0].style = \"height: \"+imgSz+\"px; \";\n"
   "	    if(isExpandable) oIt.children[2].style.display = oIt.itExp ? \"\" : \"none\";\n"
   "	    if(isExpandable) oIt.classList.add(\"expandable\"); else oIt.classList.remove(\"expandable\");\n"
   "	    if(selIt && this.mSelIt) return true;\n"
   "	}\n"
   "	return false;\n"
   "    }\n"
   "    formObj.expand = function(lit) {\n"
   "	if(!lit || !lit.children[2].children.length) return;\n"
   "	lit.itExp = !lit.itExp;\n"
   "	lit.children[2].style.display = lit.itExp ? \"\" : \"none\";\n"
   "	lit.children[0].src = \"/\"+MOD_ID+\"/img_tree\"+(lit.itExp?\"Minus\":\"Plus\")+\"Up\"+(lit!=lit.parentNode.lastChild?\"Down\":\"\");\n"
   "    }\n"
   "    formObj.selIt = function(ipath, sendEv) {\n"
   "	if(sendEv) this.select(ipath);\n"
   "	if(this.mSelIt) { this.mSelIt.classList.remove(\"select\"); this.mSelIt = null; }\n"
   "	this.finish(null, ipath);\n"
   "    }\n"
   "    formObj.setList = function(items) {\n"
   "	while(this.children.length) this.removeChild(this.children[0]);\n"
   "	formObj.itMdf = formObj.itMdf ? (formObj.itMdf+1) : 1;\n"
   "	elLst = items.split('\\n');\n"
   "	cur_it = null;\n"
   "	for(iEl = 0; iEl < elLst.length; iEl++) {\n"
   "	    ipath = elLst[iEl];\n"
   "	    for(lev = 0, pathLev.off = 0; (item=pathLev(ipath,0,true)).length; lev++) {\n"
   "		if(lev == 0) {\n"
   "		    for(cur_it = null, iR = 0; !cur_it && iR < formObj.children.length; iR++)\n"
   "			if(formObj.children[iR].children[1].innerText == item) cur_it = formObj.children[iR];\n"
   "		    if(!cur_it) formObj.appendChild((cur_it=this.ownerDocument.createElement('li')));\n"
   "		    cur_it.itMdf = formObj.itMdf;\n"
   "		}\n"
   "		else {\n"
   "		    for(t_it = null, iR = 0; !t_it && iR < cur_it.children[2].children.length; iR++)\n"
   "			if(cur_it.children[2].children[iR].children[1].innerText == item) t_it = cur_it.children[2].children[iR];\n"
   "		    if(!t_it) cur_it.children[2].appendChild((t_it=this.ownerDocument.createElement('li')));\n"
   "		    cur_it = t_it;\n"
   "		    cur_it.itMdf = formObj.itMdf;\n"
   "		}\n"
   "		if(!cur_it.children.length) {\n"
   "		    cur_it.innerHTML = \"<img onclick='this.parentNode.formObj.expand(this.parentNode)'/>\"+\n"
   "				       \"<span onclick='this.parentNode.formObj.selIt(this.parentNode.itPath,true)'>\"+\n"
   "					item.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;')+\n"
   "					\"</span><ul\\>\";\n"
   "		    cur_it.formObj = formObj;\n"
   "		}\n"
   "	    }\n"
   "	    if(cur_it && ipath.length) {\n"
   "		cur_it.classList.add(\"selectable\");\n"
   "		cur_it.itPath = ipath;\n"
   "	    }\n"
   "	}\n"
   "	formObj.finish();\n"
   "    }\n"
   "\n"
   "    return formObj;\n"
   "}\n"
   "\n"
   "/**************************************************\n"
   " * getButton - Get button with an image           *\n"
   " **************************************************/\n"
   "function getButton( imgFile, textLab, bHeight )\n"
   "{\n"
   "    var butObj = document.createElement('button');\n"
   "    butObj.style.cssText = 'visibility: hidden; height: auto; width: auto; cursor: pointer; text-align: left; float: right;';\n"
   "    var imgObj = document.createElement('img');\n"
   "    imgObj.src = '/'+MOD_ID+'/'+imgFile;\n"
   "    if(bHeight) imgObj.height = bHeight-4;\n"
   "    imgObj.style.cssText = 'float: left;';\n"
   "    butObj.appendChild(imgObj);\n"
   "    var spanObj = document.createElement('span');\n"
   "    spanObj.style.lineHeight = 1.0;\n"
   "    spanObj.innerText = textLab;\n"
   "    butObj.appendChild(spanObj);\n"
   "\n"
   "    butObj.onmouseup = function(e) { this.classList.remove(\"pressed\"); }\n"
   "    butObj.onmousedown = function(e) { this.classList.add(\"pressed\"); }\n"
   "    butObj.setText = function(tVal) { this.lastChild.innerText = tVal; }\n"
   "\n"
   "    return butObj;\n"
   "}\n"
   "\n"
   "/***************************************************\n"
   " * Main start code                                 *\n"
   " ***************************************************/\n"
   "var SEC_XT = 0x01;	//Extended\n"
   "var SEC_WR = 0x02;	//Write access\n"
   "var SEC_RD = 0x04;	//Read access\n"
   "\n"
   "//Alarms processing\n"
   "function alarmSet( alarm ) {\n"
   "    ch_tp = alarm^mAlrmSt;\n"
   "\n"
   "    alarmSt = document.getElementById(\"st_alarm\");\n"
   "    if(!alarmSt) return;\n"
   "    alarmSt_img = alarmSt.childNodes[0];\n"
   "\n"
   "    //Set notify to the alarm\n"
   "    for(iNtf = 0; iNtf < 8; iNtf++) {\n"
   "	if(notifiers[iNtf] == null) continue;\n"
   "\n"
   "	if(((newSt=(alarm>>8)&(1<<iNtf)) && notifiers[iNtf].stTag.style.display.length) || (!newSt && !notifiers[iNtf].stTag.style.display.length))\n"
   "	    notifiers[iNtf].stTag.style.display = newSt ? \"\" : \"none\";\n"
   "	if(((newSt=(alarm>>16)&(1<<iNtf)) && notifiers[iNtf].stTag.className == 'inactive') || (!newSt && notifiers[iNtf].stTag.className != 'inactive')) {\n"
   "	    notifiers[iNtf].stTag.className = newSt ? '' : 'inactive';\n"
   "	    notifiers[iNtf].stTag.style.cursor = (newSt || notifiers[iNtf].f_quietanceRet) ? 'pointer' : '';\n"
   "	}\n"
   "\n"
   "	// Checking and updating the audio tags\n"
   "	if(notifiers[iNtf].aTag) {\n"
   "	    toPlay = (alarm>>16) & (1<<iNtf);\n"
   "	    if(!toPlay && notifiers[iNtf].aTag.getAttribute(\"src\").length) notifiers[iNtf].aTag.src = '';	//disabling the playback by clearing the source\n"
   "	    else if(toPlay && (!notifiers[iNtf].aTag.getAttribute(\"src\").length ||\n"
   "		    !notifiers[iNtf].aTag.currentTime || (notifiers[iNtf].repDelay >= 0 && notifiers[iNtf].aTag.ended && (notifiers[iNtf].aTag.delay-=Math.max(planePer,tmAlrmUpd)) <= 0))) {\n"
   "		//  Requesting the resource data\n"
   "		reqRes = \"<get mode='resource' tp='\"+iNtf+\"' tm='\"+notifiers[iNtf].queueCurTm+\"' wdg='\"+notifiers[iNtf].queueCurPath+\"'/>\";\n"
   "		reqRes = servSet(\"/UI/VCAEngine/\"+sessId+\"/%2fserv%2falarm\", 'com=com', reqRes, false);\n"
   "		notifiers[iNtf].queueCurTm = parseInt(reqRes.getAttribute(\"tm\"));\n"
   "		notifiers[iNtf].queueCurPath = reqRes.getAttribute(\"wdg\");\n"
   "		//mess = reqRes.getAttribute(\"mess\");\n"
   "		//lang = reqRes.getAttribute(\"lang\");\n"
   "		if(reqRes.textContent.length) {\n"
   "		    resTp = reqRes.getAttribute(\"resTp\");\n"
   "		    notifiers[iNtf].aTag.src = \"data:\"+(resTp.length?resTp:\"audio/ogg\")+\";base64,\"+reqRes.textContent;\n"
   "		    notifiers[iNtf].aTag.play();\n"
   "		    notifiers[iNtf].aTag.delay = notifiers[iNtf].repDelay;\n"
   "		}\n"
   "	    }\n"
   "	}\n"
   "    }\n"
   "\n"
   "    //Alarm state indicators update\n"
   "    // Alarm level icon update\n"
   "    if(ch_tp&0xFF || (alarm>>16)&notifiers.ntfSet || !alarmSt_img.style.backgroundColor.length) {\n"
   "	alarmLev = alarm&0xFF;\n"
   "	alarmSt_img.style.cursor = alarmLev ? 'pointer' : '';\n"
   "	alarmSt_img.style.backgroundColor = alarmSt_img.style.backgroundColor.length ? '' :\n"
   "	    '#'+(alarmLev?'ff':'00')+(alarmLev?((alarmLev>245)?'0':'')+(255-alarmLev).toString(16):'FF')+'00';\n"
   "	alarmSt_img.title = alarmSt.getAttribute(\"title1\").replace('%1',alarmLev);\n"
   "    }\n"
   "\n"
   "    mAlrmSt = alarm;\n"
   "}\n"
   "\n"
   "function alarmQuiet( ev, iNtf, ret ) {\n"
   "    tmpl = (iNtf && iNtf >= 0) ? (1<<iNtf) : 255;\n"
   "\n"
   "    servSet(\"/UI/VCAEngine/\"+sessId+\"/%2fserv%2falarm\", \"com=com\", \"<quietance tmpl='\"+tmpl+\"' ret='\"+(ret?1:0)+\"' wdg='\"+(notifiers[iNtf]?notifiers[iNtf].curQueueWdg:'')+\"'/>\");\n"
   "\n"
   "    var attrs = new Object();\n"
   "    attrs.event = \"ws_\"+ev; setWAttrs(masterPage.addr, attrs);\n"
   "}\n"
   "\n"
   "function printElData(e) {\n"
   "    var optEl = '';\n"
   "    docs = document.getElementsByClassName(\"Primitive Document\");\n"
   "    optEl += \"<option id='<page>'>###Main Page###</option>\";\n"
   "    for(iD = 0; iD < docs.length; iD++)\n"
   "	optEl += \"<option id='\"+iD+\"' file='Document \"+iD+\".html'>\"+\n"
   "		    \"###Document %1###\".replace(\"%1\",iD.toString())+\"</option>\";\n"
   "\n"
   "    var popUpMenu = getPopup();\n"
   "    popUpMenu.childNodes[0].innerHTML = optEl;\n"
   "    popUpMenu.childNodes[0].size = Math.max(3,popUpMenu.childNodes[0].childNodes.length);\n"
   "    popUpMenu.style.cssText = 'visibility: visible; left: '+(e.clientX+window.pageXOffset-popUpMenu.offsetWidth/2)+'px; '+\n"
   "						   'top: '+(e.clientY+window.pageYOffset-popUpMenu.offsetHeight)+'px;';\n"
   "    popUpMenu.childNodes[0].selectedIndex = -1;\n"
   "    popUpMenu.childNodes[0].onclick = function( ) {\n"
   "	this.parentNode.style.cssText = 'visibility: hidden; left: -200px; top: -200px;';\n"
   "	if(this.selectedIndex < 0) return false;\n"
   "	sO = this.options[this.selectedIndex];\n"
   "	if(sO.getAttribute('id') == \"<page>\") window.print();\n"
   "	else docs[sO.getAttribute('id')].children[0].contentWindow.print();\n"
   "	return false;\n"
   "    }\n"
   "}\n"
   "\n"
   "function exportElData(e) {\n"
   "    var optEl = '';\n"
   "    docs = document.getElementsByClassName(\"Primitive Document\");\n"
   "    for(iD = 0; iD < docs.length; iD++) {\n"
   "	optEl += \"<option id='\"+docs[iD].wdgLnk.addr+\"' file='Document \"+iD+\".html'>\"+\n"
   "		    \"###Document %1### (HTML)\".replace(\"%1\",iD.toString())+\"</option>\";\n"
   "	tables = docs[iD].children[0].contentDocument.getElementsByTagName('table');\n"
   "	for(iT = 0; iT < tables.length; iT++) {\n"
   "	    if(tables[iT].getAttribute(\"export\") != \"1\") continue;\n"
   "	    optEl += \"<option id='\"+docs[iD].wdgLnk.addr+\"' file='Document \"+iD+\".csv'>\"+\n"
   "			\"###Document %1### (CSV)\".replace(\"%1\",iD.toString())+\"</option>\";\n"
   "	    break;\n"
   "	}\n"
   "    }\n"
   "    tables = document.getElementsByClassName(\"Primitive FormEl Table\");\n"
   "    for(iT = 0; iT < tables.length; iT++)\n"
   "	optEl += \"<option id='\"+tables[iT].wdgLnk.addr+\"' file='Table \"+iT+\".csv'>\"+\n"
   "		    \"###Table %1### (CSV)\".replace(\"%1\",iT.toString())+\"</option>\";\n"
   "\n"
   "    if(!optEl.length) alert(\"###No data for export!###\");\n"
   "    else {\n"
   "	var popUpMenu = getPopup();\n"
   "	popUpMenu.childNodes[0].innerHTML = optEl;\n"
   "	popUpMenu.childNodes[0].size = Math.max(3,popUpMenu.childNodes[0].childNodes.length);\n"
   "	popUpMenu.style.cssText = 'visibility: visible; left: '+(e.clientX+window.pageXOffset-popUpMenu.offsetWidth/2)+'px; '+\n"
   "							'top: '+(e.clientY+window.pageYOffset-popUpMenu.offsetHeight)+'px;';\n"
   "	popUpMenu.childNodes[0].selectedIndex = -1;\n"
   "	popUpMenu.childNodes[0].onclick = function( ) {\n"
   "	    this.parentNode.style.cssText = 'visibility: hidden; left: -200px; top: -200px;';\n"
   "	    if(this.selectedIndex < 0) return false;\n"
   "	    sO = this.options[this.selectedIndex];\n"
   "	    window.open('/'+MOD_ID+sO.getAttribute('id')+\"/\"+sO.getAttribute('file')+'?com=obj');\n"
   "	    return false;\n"
   "	}\n"
   "    }\n"
   "}\n"
   "\n"
   "function ntfReg( tp, props, pgCrtor, prior ) {\n"
   "    if(tp < 0) {\n"
   "	for(iNtf = 0; iNtf < 8; iNtf++)\n"
   "	    ntfReg(iNtf, props, pgCrtor, prior);\n"
   "	return;\n"
   "    }\n"
   "\n"
   "    if(prior == null)	prior = true;\n"
   "    pgPropsQ = new Array();\n"
   "\n"
   "    //Search for presented notification type\n"
   "    if(notifiers[tp] != null) {\n"
   "	if(notifiers[tp].pgProps.indexOf(pgCrtor+\"\\n\") == 0 && (props == notifiers[tp].props || !prior)) return;\n"
   "	pgPropsQ = notifiers[tp].pgPropsQ;\n"
   "	if(notifiers[tp].pgProps.indexOf(pgCrtor+\"\\n\") != 0) {\n"
   "	    // Check the queue for the page already here\n"
   "	    for(iQ = 0; iQ != pgPropsQ.length; ++iQ)\n"
   "		if(pgPropsQ[iQ].slice(0,pgCrtor.length+1) == (pgCrtor+\"\\n\")) {\n"
   "		    if(!props.length) notifiers[tp].pgPropsQ.splice(iQ, 1);\n"
   "		    else notifiers[tp].pgPropsQ[iQ] = pgCrtor + \"\\n\" + props;\n"
   "		    return;\n"
   "		}\n"
   "	    if(!props.length) return;\n"
   "	    pgPropsQ.push(notifiers[tp].pgProps);\n"
   "	}\n"
   "	// Removing the notifier for external things\n"
   "	if(notifiers[tp].aTag) notifiers[tp].aTag.parentNode.removeChild(notifiers[tp].aTag);\n"
   "	if(notifiers[tp].stTag) notifiers[tp].stTag.parentNode.removeChild(notifiers[tp].stTag);\n"
   "\n"
   "	delete notifiers[tp];\n"
   "	notifiers.ntfSet &= ~(1<<tp);\n"
   "    }\n"
   "\n"
   "    //Creation new or replacing present one\n"
   "    pgProps = pgCrtor + \"\\n\" + props;\n"
   "    if(props.length) ;\n"
   "    //Take and place a notificator from the queue\n"
   "    else if(pgPropsQ.length) pgProps = pgPropsQ.pop();\n"
   "    else return;\n"
   "\n"
   "    //Initiating the notifier for external things\n"
   "    notifiers.ntfSet |= (1<<tp);\n"
   "    notifiers[tp] = new Object();\n"
   "    notifiers[tp].pgProps = pgProps;\n"
   "    notifiers[tp].pgPropsQ = pgPropsQ;\n"
   "    notifiers[tp].f_notify = false;\n"
   "    notifiers[tp].f_queue = false;\n"
   "    notifiers[tp].f_resource = false;\n"
   "    notifiers[tp].f_quietanceRet = false;\n"
   "    notifiers[tp].repDelay = -1;\n"
   "    notifiers[tp].aTag = null;\n"
   "    notifiers[tp].stTag = null;\n"
   "    notifiers[tp].queueCurTm = 0;\n"
   "    notifiers[tp].curQueueWdg = '';\n"
   "\n"
   "    //Parsing the properties\n"
   "    prpLns = pgProps.split('\\n');\n"
   "    for(iLn = 1, hasFlags = false, ico = name = \"\"; (!hasFlags || !ico.length || !name.length) && iLn < prpLns.length; iLn++)\n"
   "	if(!hasFlags && (fPos=prpLns[iLn].indexOf(\"flags=\")) >= 0) {\n"
   "	    if((oPos=prpLns[iLn].indexOf(\"notify\",fPos+6)) >= 0) {\n"
   "		notifiers[tp].f_notify = true;\n"
   "		notifiers[tp].repDelay = ((ntfChr=prpLns[iLn].charCodeAt(oPos+6)) >= 0x30 && ntfChr <= 0x39) ? Math.max(0,Math.min(100,parseInt(prpLns[iLn].slice(oPos+6)))) : -1;\n"
   "	    }\n"
   "	    if(prpLns[iLn].indexOf(\"resource\",fPos+6) >= 0)	notifiers[tp].f_resource = true;\n"
   "	    if(prpLns[iLn].indexOf(\"queue\",fPos+6) >= 0)	{ notifiers[tp].f_queue = true; if(notifiers[tp].repDelay < 0) notifiers[tp].repDelay = 0; }\n"
   "	    if(prpLns[iLn].indexOf(\"quietanceRet\",fPos+6) >= 0)	notifiers[tp].f_quietanceRet = true;\n"
   "	}\n"
   "	else if(!ico.length && (fPos=prpLns[iLn].indexOf(\"ico=\")) >= 0)   ico = prpLns[iLn].slice(fPos+4);\n"
   "	else if(!name.length && (fPos=prpLns[iLn].indexOf(\"name=\")) >= 0) name = prpLns[iLn].slice(fPos+5);\n"
   "\n"
   "    //Creation the audio tag\n"
   "    if(notifiers[tp].f_notify && (notifiers[tp].f_queue || notifiers[tp].f_resource)) {\n"
   "	notifiers[tp].aTag = document.createElement(\"audio\");\n"
   "	notifiers[tp].aTag.autoplay = true;\n"
   "	notifiers[tp].aTag.src = '';\n"
   "	//notifiers[tp].aTag.id = \"notifierAudioTag\"+tp;\n"
   "	document.body.appendChild(notifiers[tp].aTag);\n"
   "    }\n"
   "\n"
   "    //Creation the statusbar icons\n"
   "    if(masterPage.status) {\n"
   "	notifiers[tp].stTag = document.createElement(\"img\");\n"
   "	notifiers[tp].stTag.id = \"alarmNtf\"+tp;\n"
   "	notifiers[tp].stTag.title = name.length ? name : \"###Notificator %1###\".replace(\"%1\",tp);\n"
   "	notifiers[tp].stTag.height = (masterPage.status.height-2);\n"
   "	notifiers[tp].stTag.src = \"/\"+MOD_ID+(ico.length?pgCrtor+\"?com=res&val=\"+ico+\"&size=\"+(masterPage.status.height-2):\"/img_alarmAlarm\");\n"
   "	notifiers[tp].stTag.style.display = 'none';\n"
   "	notifiers[tp].stTag.quietanceRet = notifiers[tp].f_quietanceRet;\n"
   "	notifiers[tp].stTag.onclick = function( ) { alarmQuiet(this.id, parseInt(this.id.slice(8)), (this.quietanceRet && this.className == 'inactive')); }\n"
   "	masterPage.status.children[0].rows[0].children.st_alarm.appendChild(notifiers[tp].stTag);\n"
   "    }\n"
   "}\n"
   "\n"
   "//Call session identifier\n"
   "var sessId = location.pathname.split('/');\n"
   "for(var i_el = sessId.length-1; i_el >= 0; i_el--)\n"
   "    if(sessId[i_el].length)\n"
   "    { sessId = sessId[i_el]; break; }\n"
   "\n"
   "function styleSet( sid ) {\n"
   "    servSet(\"/UI/VCAEngine/\"+sessId+\"/%2fobj%2fcfg%2fstyle\", \"com=com\", \"<set>\"+sid+\"</set>\");\n"
   "    stTmReload = setTimeout('window.location.reload()', 1000);\n"
   "}\n"
   "\n"
   "document.body.onmouseup = function(e)\n"
   "{\n"
   "    if(!e) e = window.event;\n"
   "    if(evMouseGet(e) != 'Left') return true;\n"
   "\n"
   "    if((popIt=document.getElementById('popupmenu')))	popIt.style.visibility = 'hidden';\n"
   "    if((popIt=document.getElementById('combomenu')))	popIt.style.visibility = 'hidden';\n"
   "    if((popIt=document.getElementById('clndrdlg')))	popIt.style.visibility = 'hidden';\n"
   "\n"
   "    //return false;	//!!!! It's buggy on <input type=range> for Chrome\n"
   "}\n"
   "\n"
   "window.onresize = function( ) {\n"
   "    if(stTmReload) clearTimeout(stTmReload);\n"
   "\n"
   "    brwsSc = (window.devicePixelRatio && window.devicePixelRatio != 1);\n"
   "\n"
   "    if((!brwsSc && ((window.innerHeight-document.body.clientHeight)/window.innerHeight > 0.1 ||\n"
   "		((document.body.clientHeight-window.innerHeight)/document.body.clientHeight > 0.5 && wy_scale > 1))) ||\n"
   "	    (brwsSc && (wy_scale != 1 || wx_scale != 1)))\n"
   "	stTmReload = setTimeout('window.location.reload()', 1000);\n"
   "}\n"
   "\n"
   "var reqObjects = new Array();		//Request objects\n"
   "var fullUpdCnt = 0;			//Full tree updating counter\n"
   "var alrmUpdCnt = 0;			//Alarms updating counter\n"
   "var mAlrmSt = -1;			//Current allarm state\n"
   "var modelPer = 0;			//Model proc period\n"
   "var modelStyles = null;			//Model styles\n"
   "var prcCnt = 0;				//Process counter\n"
   "var prcTm = 0;				//Process time\n"
   "var planePer = 0;			//Planed update period\n"
   "var tmCnt = 0;				//Calls counter\n"
   "var toFastCycle = false;		//Update immediately without sleep\n"
   "var pgList = new Array();		//Opened pages list\n"
   "var pgCloseList = new Object();		//Page list for close in several cycles\n"
   "var cachePgLife = 0;			//Life time of the pages in the cache\n"
   "var cachePgSz = 0;			//Maximum number of the pages cache\n"
   "var pgCache = new Array();		//Cached pages' data\n"
   "var perUpdtWdgs = new Object();		//Periodic updated widgets register\n"
   "var notifiers = new Object();		//Notifiers object\n"
   "notifiers.ntfSet = 0;\n"
   "var masterPage = new pwDescr('', true);	//Master page create\n"
   "var stTmID = null;			//Status line timer identifier\n"
   "var stTmMain = null;			//Main cycle start time\n"
   "var stTmReload = null;			//Main reload timeout at the main window resize\n"
   "var wx_scale = 1;			//Main window scale for fit, X axis\n"
   "var wy_scale = 1;			//Main window scale for fit, Y axis\n"
   "var sesUser = '';			//Session user\n"
   "\n"
   "mainTmId = setTimeout(makeUI, 100);	//First call init\n";
