/*******************************************************************************
  XDG desktop portal implementation for TDE
  Copyright © 2024 Mavridis Philippe <mavridisf@gmail.com>

  This program or library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the License,
  or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
  details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

  Improvements and feedback are welcome!
*******************************************************************************/

#ifndef __UTIL_H
#define __UTIL_H

// TQt
#include <tqdbusvariant.h>
#include <tqdbusdatalist.h>
#include <tqvariant.h>
#include <twin.h>

// TDE
#include <kurl.h>

#define DEL(x) if (x) { delete x; x = nullptr; }

typedef TQMap<TQString, TQT_DBusVariant> TQT_DBusVariantMap;
typedef TQValueList<TQT_DBusData> TQT_DBusValueList;

struct ApplicationInfo
{
    TQString name;
    TQString path;
    TQString desktopFile;
    int pid;
};

extern WId parse_window_id(const TQString data);

extern ApplicationInfo application_info_from_wid(WId wid);

extern bool check_variant(TQT_DBusVariant variant, TQString signature);

extern TQString bytelist_to_string(TQT_DBusDataList list);

extern TQT_DBusDataList string_to_bytelist(TQString str);

extern TQT_DBusDataList kurl_list_to_datalist(KURL::List urls);

extern bool make_variant(TQVariant variant, TQT_DBusVariant &other);

#endif // __UTIL_H

// kate: replace-tabs true; tab-width 4; indent-width 4;