/***************************************************************************
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License version 2.0 as   *
*   published by the Free Software Foundation.                            *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program in the file LICENSE.GPL; if not, write to the *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#include "config.h"

#include "UiGuiInfoDialog.h"
#include "IndentHandler.h"
#include "MainWindow.h"
#include "SettingsPaths.h"

#include <tqlineedit.h>
#include <tqpixmap.h>
#include <tqtabwidget.h>

/*
    \class UiGuiInfoDialog
    \brief Displays a dialog window with information about the current file
           and about the paths used by the application
*/

UiGuiInfoDialog::UiGuiInfoDialog(TQWidget *parent, const IndentHandler *indenter) :
        UiGuiInfoDialogBase(parent), m_mainWindow((const MainWindow*)parent),
        m_indentHandler(indenter)
{
	// For icon setup
	const TQString ICONS_PATH(APP_ICONS_PATH);
	// Application icon
	setIcon(TQPixmap(ICONS_PATH + "info.png"));

	tabWidget->setTabIconSet(tabFile, TQPixmap(ICONS_PATH + "accessories-text-editor.png"));
	tabWidget->setTabIconSet(tabPaths, TQPixmap(ICONS_PATH + "syntax-highlight.png"));
}

/*
    \brief Displays the dialog by calling the dialogs exec function.
 */
void UiGuiInfoDialog::showDialog()
{
	// Populate all dialog objects
	leFilename->setText(m_mainWindow->m_currentSourceFile);
	leConfigFilename->setText(m_indentHandler->m_indenterConfigFilename);
	leIndenter->setText(m_indentHandler->m_indenterName);

	leApplicationPath->setText(SettingsPaths::getApplicationBinaryPath());
	leSettingsPath->setText(SettingsPaths::getSettingsPath());
	leGlobalFilesPath->setText(SettingsPaths::getGlobalFilesPath());
	leIndentersPath->setText(SettingsPaths::getIndenterPath());
	leTempPath->setText(SettingsPaths::getTempPath());

	// Execute the dialog.
	exec();
}

#include "UiGuiInfoDialog.moc"
