/***************************************************************************
*   Copyright (C) 2003 by Roberto Raggi                                   *
*   roberto@kdevelop.org                                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include "kdevtdelibsimporter.h"
#include "kdevtdelibsimporter.moc"
#include "settingsdialog.h"

#include <kdebug.h>
#include <kgenericfactory.h>

#include <tqvaluestack.h>
#include <tqlabel.h>
#include <tqdir.h>
#include <tqcombobox.h>

K_EXPORT_COMPONENT_FACTORY( libkdevtdelibsimporter, KGenericFactory<KDevKDELibsImporter>( "kdevtdelibsimporter" ) )

KDevKDELibsImporter::KDevKDELibsImporter( TQObject * parent, const char * name, const TQStringList& )
		: KDevPCSImporter( parent, name )
{}

KDevKDELibsImporter::~KDevKDELibsImporter()
{}

TQStringList KDevKDELibsImporter::fileList( const TQString& path )
{
	TQDir dir( path );
	TQStringList lst = dir.entryList( "*.h" );
	TQStringList fileList;
	for ( TQStringList::Iterator it = lst.begin(); it != lst.end(); ++it )
	{
		fileList.push_back( dir.absPath() + "/" + ( *it ) );
	}
	return fileList;
}


TQStringList KDevKDELibsImporter::fileList()
{
	if ( !m_settings )
		return TQStringList();

	TQStringList files;
	int scope = m_settings->cbParsingScope->currentItem();
	if ( scope == 0 )
	{
		files += fileList( m_settings->kdeDir() );
		files += fileList( m_settings->kdeDir() + "/arts" );
		files += fileList( m_settings->kdeDir() + "/artsc" );
		files += fileList( m_settings->kdeDir() + "/dcopc" );
		files += fileList( m_settings->kdeDir() + "/dom" );
		files += fileList( m_settings->kdeDir() + "/tdeabc" );
		files += fileList( m_settings->kdeDir() + "/tdeprint" );
		files += fileList( m_settings->kdeDir() + "/tdesu" );
		files += fileList( m_settings->kdeDir() + "/tdeio" );
		files += fileList( m_settings->kdeDir() + "/kjs" );
		files += fileList( m_settings->kdeDir() + "/tdeparts" );
		files += fileList( m_settings->kdeDir() + "/tdetexteditor" );
	}
	else if ( scope == 1 )
	{
		TQValueStack<TQString> s;
		s.push( m_settings->kdeDir() );
		files += fileList( m_settings->kdeDir() );

		TQDir dir;
		do
		{
			dir.setPath( s.pop() );
			kdDebug( 9015 ) << "Examining: " << dir.path() << endl;
			const TQFileInfoList *dirEntries = dir.entryInfoList();
			if ( !dirEntries ) continue;
			TQPtrListIterator<TQFileInfo> it( *dirEntries );
			for ( ; it.current(); ++it )
			{
				TQString fileName = it.current() ->fileName();
				if ( fileName == "." || fileName == ".." )
					continue;
				TQString path = it.current() ->absFilePath();
				if ( it.current() ->isDir() )
				{
					kdDebug( 9015 ) << "Pushing: " << path << endl;
					s.push( path );
					files += fileList( path );
				}
			}
		}
		while ( !s.isEmpty() );
	}

	return files;
}

TQStringList KDevKDELibsImporter::includePaths()
{
	if ( !m_settings )
		return TQStringList();

	TQStringList includePaths;
	includePaths.push_back( m_settings->kdeDir() );
	return includePaths;
}

TQWidget * KDevKDELibsImporter::createSettingsPage( TQWidget * parent, const char * name )
{
	m_settings = new SettingsDialog( parent, name );
	return m_settings;
}
