/***************************************************************************
 *   Copyright (C) 2001-2002 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *   Copyright (C) 2003 Alexander Dymo                                     *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <tqcombobox.h>
#include <tqvaluelist.h>

#include <kservice.h>
#include <kdebug.h>

#include "service.h"


void ServiceComboBox::insertStringList(TQComboBox *combo, const TQValueList<KService::Ptr> &list,
                            TQStringList *names, TQStringList *execs)
{
    TQValueList<KService::Ptr>::ConstIterator it;
    for (it = list.begin(); it != list.end(); ++it) {
        combo->insertItem((*it)->comment());
        (*names) << (*it)->desktopEntryName();
        (*execs) << (*it)->exec();
        kdDebug() << "insertStringList item " << (*it)->name() << "," << (*it)->exec() << endl;
    }
}

TQString ServiceComboBox::currentText(TQComboBox *combo, const TQStringList &names)
{
    if (combo->currentItem() == -1)
        return TQString();
    return names[combo->currentItem()];
}

void ServiceComboBox::setCurrentText(TQComboBox *combo, const TQString &str, const TQStringList &names)
{
    TQStringList::ConstIterator it;
    int i = 0;
    for (it = names.begin(); it != names.end(); ++it) {
        if (*it == str) {
            combo->setCurrentItem(i);
            break;
        }
        ++i;
    }
}

int ServiceComboBox::itemForText(const TQString &str, const TQStringList &names)
{
    TQStringList::ConstIterator it;
    int i = 0;
    for (it = names.begin(); it != names.end(); ++it) {
        if (*it == str) {
            return i;
        }
        ++i;
    }
    return 0;
}

TQString ServiceComboBox::defaultCompiler()
{
    TDETrader::OfferList offers = TDETrader::self()->query("TDevelop/CompilerOptions", "[X-TDevelop-Language] == 'Pascal'");
    TQValueList<KService::Ptr>::ConstIterator it;
    for (it = offers.begin(); it != offers.end(); ++it) {
        if ((*it)->property("X-TDevelop-Default").toBool()) {
            return (*it)->name();;
        }
    }
    return "";
}
