/* This file is part of the KDE project
   Copyright (C) 2003 Alexander Dymo <cloudtemple@mksat.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include <tdelocale.h>
#include <tdeapplication.h>

#include <tqcombobox.h>

#include "addfilesdialog.h"
#include "addfilesdialog.moc"

AddFilesDialog::AddFilesDialog(const TQString& startDir, const TQString& filter,
    TQWidget *parent, const char *name, bool modal):
    KFileDialog(startDir, filter, parent, name, modal)
{
    TDEConfig *config = kapp->config();
    config->setGroup("Add Files Dialog");

    m_extraWidget = new TQComboBox(false, this);
    m_extraWidget->insertItem(i18n("Copy File(s)"), 0);
    m_extraWidget->insertItem(i18n("Create Symbolic Link(s)"), 1);
    m_extraWidget->insertItem(i18n("Add Relative Path(s)"), 2);
    m_extraWidget->setCurrentItem(config->readNumEntry("Mode"));
    connect(m_extraWidget, TQ_SIGNAL(activated(int)), this, TQ_SLOT(storePreferred(int)));

    setPreviewWidget(m_extraWidget);

    setOperationMode(Opening);
}


AddFilesDialog::AddFilesDialog(const TQString& startDir, const TQString& filter,
    TQWidget *parent, const char *name, bool modal, TQComboBox *extraWidget):
    KFileDialog(startDir, filter, parent, name, modal, extraWidget), m_extraWidget(extraWidget)
{
    TDEConfig *config = kapp->config();
    config->setGroup("Add Files Dialog");

    m_extraWidget->insertItem(i18n("Copy File(s)"), 0);
    m_extraWidget->insertItem(i18n("Create Symbolic Link(s)"), 1);
    m_extraWidget->insertItem(i18n("Add Relative Path(s)"), 2);
    m_extraWidget->setCurrentItem(config->readNumEntry("Mode"));
    connect(m_extraWidget, TQ_SIGNAL(activated(int)), this, TQ_SLOT(storePreferred(int)));

    setOperationMode(Opening);
}


AddFilesDialog::~AddFilesDialog()
{
}

AddFilesDialog::Mode AddFilesDialog::mode( )
{
    return (AddFilesDialog::Mode)m_extraWidget->currentItem();
}

void AddFilesDialog::storePreferred( int index )
{
    TDEConfig *config = kapp->config();
    config->setGroup("Add Files Dialog");
    config->writeEntry("Mode", index);
}
