/***************************************************************************
 *   Copyright (C) 2003-2008 by Albert Astals Cid                          *
 *   aacid@kde.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef __tdeio_gopher_h__
#define __tdeio_gopher_h__

#include <tdeio/tcpslavebase.h>
#include <kiconloader.h>

class GopherProtocol : public TDEIO::TCPSlaveBase
{
	public:
		GopherProtocol(const TQCString &pool_socket, const TQCString &app_socket);

		void get(const KURL& url);

	private:
		void processDirectory(const TQString &received_str, const TQString &host, const TQString &path);
		void processDirectoryLine(const TQString &data, TQString &show, TQString &info);
		TQString parsePort(TQString &received);
		void findLine(const TQString &received, int *i, int *remove);
		void handleSearch(const TQString &host, const TQString &path, int port);
		void addIcon(const TQString &type, const TQString &url, TQString &show);
		
		TDEIconLoader m_iconLoader;
};

#endif

