/*
	Copyright (C) 2006 Michael Lentner <michaell@gmx.net>
	
	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Library General Public
	License version 2 as published by the Free Software Foundation.
	
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Library General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
*/


#ifndef _QEMBED_Config
#define _QEMBED_Config
#include <tqimage.h>
#include <tqdict.h>
static const TQRgb tabIndicatorArrow_data[] = {
    0x0,0x0,0x0,0x10000000,0x4e000000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x18000000,0x5f000000,0x66000000,
    0x5f000000,0x18000000,0x0,0x0,0x0,0x21000000,0x63000000,0x66000000,0x66000000,0x66000000,0x63000000,0x20000000,0x0,0x28000000,
    0x62000000,0x63000000,0x66000000,0x66000000,0x66000000,0x63000000,0x62000000,0x27000000,0x0,0x0,0x0,0x60000000,0x66000000,0x60000000,
    0x0,0x0,0x0,0x0,0x0,0x0,0x60000000,0x66000000,0x60000000,0x0,0x0,0x0,0x0,0x0,
    0x0,0x61000000,0x66000000,0x61000000,0x0,0x0,0x0,0x0,0x0,0x0,0x61000000,0x66000000,0x61000000,0x0,
    0x0,0x0,0x0,0x0,0x0,0x62000000,0x66000000,0x62000000,0x0,0x0,0x0
};

/* Generated by qembed */
static struct ConfigEmbedImage {
    int width, height, depth;
    const unsigned char *data;
    int numColors;
    const TQRgb *colorTable;
    bool alpha;
    const char *name;
} config_embed_image_vec[] = {
    { 9, 9, 32, (const unsigned char*)tabIndicatorArrow_data, 0, 0, true, "tabIndicatorArrow" },
    { 0, 0, 0, 0, 0, 0, 0, 0 }
};

static const TQImage& config_findImage( const TQString& name )
{
    static TQDict<TQImage> dict;
    TQImage* img = dict.find( name );
    if ( !img ) {
	for ( int i = 0; config_embed_image_vec[i].data; i++ ) {
	    if ( strcmp(config_embed_image_vec[i].name, name.latin1()) == 0 ) {
		img = new TQImage((uchar*)config_embed_image_vec[i].data,
			    config_embed_image_vec[i].width,
			    config_embed_image_vec[i].height,
			    config_embed_image_vec[i].depth,
			    (TQRgb*)config_embed_image_vec[i].colorTable,
			    config_embed_image_vec[i].numColors,
			    TQImage::BigEndian );
		if ( config_embed_image_vec[i].alpha )
		    img->setAlphaBuffer( true );
		dict.insert( name, img );
		break;
	    }
	}
	if ( !img ) {
	    static TQImage dummy;
	    return dummy;
	}
    }
    return *img;
}

#endif
