

#ifndef CUESHEETEDITOR_H
#define CUESHEETEDITOR_H

#include <kdialog.h>
#include <ktextedit.h>


//class KTextEdit;
class KPushButton;

/**
 * @short The editor tool for cuesheet files
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class CuesheetEditor : public KDialog
{
    TQ_OBJECT
  
public:
    /**
     * Default Constructor
     */
    CuesheetEditor( TQWidget* parent=0, const char* name=0, bool modal=true, WFlags f=0 );

    /**
     * Default Destructor
     */
    virtual ~CuesheetEditor();

    void setContent( const TQString& text ) { tTextEdit->setText( text ); }

private slots:
    void help();
    void convert();
    void generate();
    void shift();

private:
    KTextEdit* tTextEdit;
    KPushButton* pHelp;
    KPushButton* pGenerate;
    KPushButton* pConvert;
    KPushButton* pShift;
    KPushButton* pOk;

};

#endif // CUESHEETEDITOR_H
