#!/usr/bin/python
###########################################################################
# kcontrol_module - description                                           #
# ------------------------------                                          #
# begin     : Mon May 2 2005                                              #
# copyright : (C) 2005 by AUTHOR                                          #
# email     : your@email.com                                              #
#                                                                         #
###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################

import sys
from PyTQt.tqt import *
from tdecore import *
from tdeui import *

import tdedesigner
from KcontrolModuleWidgetUI import *

description = "A Kcontrol module"
version = "0.1"

############################################################################
def AboutData():
    global version,description
    
    about_data = TDEAboutData("kcontrol_module", "kcontrol_module", version, \
        description, TDEAboutData.License_GPL, "(C) 2005 AUTHOR", None, None,\
        "your@email.com")
    about_data.addAuthor("AUTHOR", None, "your@email.com")
    return about_data

############################################################################
class KcontrolModuleWidget(KcontrolModuleWidgetUI):
    def __init__(self,parent=None):
        KcontrolModuleWidgetUI.__init__(self,parent,"Kcontrol module")
    # Add other methods, slots and signals here.

############################################################################
# The base class that we use depends on whether this is running inside
# kcontrol or as a standalone application.
# Are we running as a separate standalone application or in KControl?
standalone = __name__=='__main__'

if standalone:
    programbase = KDialogBase
else:
    programbase = TDECModule
    
class KcontrolModuleApp(programbase):
    ########################################################################
    def __init__(self,parent=None,name=None):
        global standalone
        if standalone:
            KDialogBase.__init__(self,KJanusWidget.Plain,"Kcontrol module",KDialogBase.User1|KDialogBase.Close, KDialogBase.Close)
            self.setButtonText(KDialogBase.User1,"About")
        else:
            TDECModule.__init__(self,parent,name)
            # Create a configuration object.
            self.config = TDEConfig("kcontrol_module")
            self.setButtons(0)
            self.aboutdata = AboutData()

        # The appdir needs to be explicitly otherwise we won't be able to
        # load our icons and images.
        TDEGlobal.iconLoader().addAppDir("kcontrol_module")
        
        if standalone:
            toplayout = TQVBoxLayout( self.plainPage(), 0, KDialog.spacingHint() )
            mainwidget = KcontrolModuleWidget(self.plainPage())
        else:
            toplayout = TQVBoxLayout( self, 0, KDialog.spacingHint() )
            mainwidget = KcontrolModuleWidget(self)
            
        toplayout.addWidget(mainwidget)

        self.aboutus = TDEAboutApplication(self)
                
    ########################################################################
    def __del__(self):
        pass

    ########################################################################
    # KDialogBase method
    def exec_loop(self):
        global programbase
        
        # Load configuration here
        self.__loadOptions()
        
        programbase.exec_loop(self)
        
        # Save configuration here
        self.__saveOptions()

    ########################################################################
    # KDialogBase method
    def slotUser1(self):
        self.aboutus.show()

    ########################################################################
    def slotCloseButton(self):
        self.close()

    ########################################################################
    def __loadOptions(self):
        global kapp
        config = kapp.config()
        config.setGroup("General")
        size = config.readSizeEntry("Geometry")
        if size.isEmpty()==False:
            self.resize(size)

    #######################################################################
    def __saveOptions(self):
        global kapp
        config = kapp.config()
        config.setGroup("General")
        config.writeEntry("Geometry", self.size())
        config.sync()

    #######################################################################
    # KControl virtual void methods
    def load(self):
        pass
    def save(self):
        pass
    def defaults(self):
        pass        
    def sysdefaults(self):
        pass
    
    def aboutData(self):
        # Return the TDEAboutData object which we created during initialisation.
        return self.aboutdata
    
    def buttons(self):
        # Only supply a Help button. Other choices are Default and Apply.
        return TDECModule.Help

############################################################################
# This is the entry point used when running this module outside of kcontrol.
def main():
    global kapp
    about_data = AboutData()
    TDECmdLineArgs.init(sys.argv,about_data)
    kapp = TDEApplication()
    myapp = KcontrolModuleApp()
    myapp.exec_loop()
    
############################################################################
# Factory function for KControl
def create_kcontrol_module(parent,name):
    global kapp
    kapp = TDEApplication.kApplication()
    return KcontrolModuleApp(parent, name)
    
############################################################################
if standalone:
    main()
