/***************************************************************************
 *   Copyright (C) 2005-2007 Nicolas Hadacek <hadacek@kde.org>             *
 *   Copyright (C) 2003-2005 Alain Gibaud <alain.gibaud@free.fr>           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef HARDWARE_CONFIG_H
#define HARDWARE_CONFIG_H

#include "common/global/generic_config.h"
#include "common/port/port.h"

namespace Hardware
{
//-----------------------------------------------------------------------------
struct DataInfo
{
  const char *name, *label, *comment;
};

class Data
{
public:
  Data() : portType(PortType::Nb_Types) {}
  virtual ~Data() {}
  virtual void readConfig(GenericConfig &config);
  virtual void writeConfig(GenericConfig &config) const;
  virtual bool isEqual(const Data &data) const;
  PortType portType;
  TQString  name;
};

//-----------------------------------------------------------------------------
class Config : public GenericConfig
{
public:
  Config(const char *group) : GenericConfig(group) {}
  virtual ~Config() {}
  TQStringList hardwareNames(PortType type);
  bool isStandardHardware(const TQString &name) const { return standardHardwareData(name); }
  TQString label(const TQString &name) const;
  TQString comment(const TQString &name) const;
  void writeCustomHardware(const TQString &name, const Hardware::Data &data);
  TQString currentHardware(PortType type);
  void writeCurrentHardware(PortType type, const TQString &name);
  void deleteCustomHardware(const TQString &name);
  Hardware::Data *hardwareData(const TQString& name) const;

protected:
  virtual TQStringList standardHardwareNames(PortType type) const = 0;
  virtual Hardware::Data *standardHardwareData(const TQString &name) const = 0;
  virtual const DataInfo *standardHardwareDataInfo(const TQString &name) const = 0;
  virtual Hardware::Data *createHardwareData() const = 0;
};

} // namespace

#endif
