#ifndef _KVI_KVS_TREENODE_SPECIALCOMMANDDEFPOPUP_H_
#define _KVI_KVS_TREENODE_SPECIALCOMMANDDEFPOPUP_H_
//=============================================================================
//
//   File : kvi_kvs_treenode_specialcommanddefpopup.h
//   Created on Fri 02 Jan 2004 13:54:00 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2004 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_qstring.h"
#include "kvi_kvs_treenode.h"
#include "kvi_kvs_treenode_specialcommand.h"

class KviKvsTreeNodeExpression;
class KviKvsTreeNodeInstruction;
class KviKvsRunTimeContext;
class KviKvsVariant;
class KviKvsPopupMenu;


class KVIRC_API KviKvsTreeNodeSpecialCommandDefpopupLabel : public KviKvsTreeNode
{
public:
	TQString m_szItemName;
public:
	KviKvsTreeNodeSpecialCommandDefpopupLabel(const TQChar * pLocation,const TQString &szItemName)
		: KviKvsTreeNode(pLocation), m_szItemName(szItemName) {};
	~KviKvsTreeNodeSpecialCommandDefpopupLabel(){};
public:
	void setItemName(const TQString &szItemName){ m_szItemName = szItemName; };
	virtual bool execute(KviKvsRunTimeContext * c,KviKvsPopupMenu * p) = 0;
};

class KVIRC_API KviKvsTreeNodeSpecialCommandDefpopupConditionalLabel : public KviKvsTreeNodeSpecialCommandDefpopupLabel
{
protected:
	TQString m_szCondition; // may be null!
public:
	KviKvsTreeNodeSpecialCommandDefpopupConditionalLabel(const TQChar * pLocation,const TQString &szCondition,const TQString &szItemName)
		: KviKvsTreeNodeSpecialCommandDefpopupLabel(pLocation,szItemName), m_szCondition(szCondition) {};
	~KviKvsTreeNodeSpecialCommandDefpopupConditionalLabel(){};
public:
	void setCondition(const TQString &szCondition){ m_szCondition = szCondition; };
};

class KVIRC_API KviKvsTreeNodeSpecialCommandDefpopupLabelSeparator : public KviKvsTreeNodeSpecialCommandDefpopupConditionalLabel
{
public:
	KviKvsTreeNodeSpecialCommandDefpopupLabelSeparator(const TQChar * pLocation,const TQString &szCondition,const TQString &szItemName)
		: KviKvsTreeNodeSpecialCommandDefpopupConditionalLabel(pLocation,szCondition,szItemName){};
	~KviKvsTreeNodeSpecialCommandDefpopupLabelSeparator(){};
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c,KviKvsPopupMenu * p);
};

class KVIRC_API KviKvsTreeNodeSpecialCommandDefpopupConditionalLabelWithTextAndIcon : public KviKvsTreeNodeSpecialCommandDefpopupConditionalLabel
{
protected:
	TQString m_szText;
	TQString m_szIcon;
public:
	KviKvsTreeNodeSpecialCommandDefpopupConditionalLabelWithTextAndIcon(const TQChar * pLocation,const TQString &szCondition,const TQString &szText,const TQString &szIcon,const TQString &szItemName)
		: KviKvsTreeNodeSpecialCommandDefpopupConditionalLabel(pLocation,szCondition,szItemName), m_szText(szText), m_szIcon(szIcon){};
	~KviKvsTreeNodeSpecialCommandDefpopupConditionalLabelWithTextAndIcon(){};
public:
	void setText(const TQString &szText){ m_szText = szText; };
	void setIcon(const TQString &szIcon){ m_szIcon = szIcon; };
};

class KVIRC_API KviKvsTreeNodeSpecialCommandDefpopupLabelExtpopup : public KviKvsTreeNodeSpecialCommandDefpopupConditionalLabelWithTextAndIcon
{
protected:
	TQString m_szName;
public:
	KviKvsTreeNodeSpecialCommandDefpopupLabelExtpopup(const TQChar * pLocation,const TQString &szCondition,const TQString &szText,const TQString &szIcon,const TQString &szName,const TQString &szItemName)
		: KviKvsTreeNodeSpecialCommandDefpopupConditionalLabelWithTextAndIcon(pLocation,szCondition,szText,szIcon,szItemName), m_szName(szName){};
	~KviKvsTreeNodeSpecialCommandDefpopupLabelExtpopup(){};
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c,KviKvsPopupMenu * p);
};

class KVIRC_API KviKvsTreeNodeSpecialCommandDefpopupLabelItem : public KviKvsTreeNodeSpecialCommandDefpopupConditionalLabelWithTextAndIcon
{
protected:
	TQString m_szInstruction;
public:
	KviKvsTreeNodeSpecialCommandDefpopupLabelItem(const TQChar * pLocation,const TQString &szCondition,const TQString &szText,const TQString &szIcon,const TQString &szInstruction,const TQString &szItemName)
		: KviKvsTreeNodeSpecialCommandDefpopupConditionalLabelWithTextAndIcon(pLocation,szCondition,szText,szIcon,szItemName), m_szInstruction(szInstruction) {};
	~KviKvsTreeNodeSpecialCommandDefpopupLabelItem(){};
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c,KviKvsPopupMenu * p);
};


class KVIRC_API KviKvsTreeNodeSpecialCommandDefpopupLabelLabel : public KviKvsTreeNodeSpecialCommandDefpopupConditionalLabelWithTextAndIcon
{
public:
	KviKvsTreeNodeSpecialCommandDefpopupLabelLabel(const TQChar * pLocation,const TQString &szCondition,const TQString &szText,const TQString &szIcon,const TQString &szItemName)
		: KviKvsTreeNodeSpecialCommandDefpopupConditionalLabelWithTextAndIcon(pLocation,szCondition,szText,szIcon,szItemName){};
	~KviKvsTreeNodeSpecialCommandDefpopupLabelLabel(){};
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c,KviKvsPopupMenu * p);
};



class KVIRC_API KviKvsTreeNodeSpecialCommandDefpopupLabelPrologue : public KviKvsTreeNodeSpecialCommandDefpopupLabel
{
protected:
	TQString m_szInstruction;
public:
	KviKvsTreeNodeSpecialCommandDefpopupLabelPrologue(const TQChar * pLocation,const TQString &szInstruction,const TQString &szItemName)
		: KviKvsTreeNodeSpecialCommandDefpopupLabel(pLocation,szItemName), m_szInstruction(szInstruction){};
	~KviKvsTreeNodeSpecialCommandDefpopupLabelPrologue(){};
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c,KviKvsPopupMenu * p);
};

class KVIRC_API KviKvsTreeNodeSpecialCommandDefpopupLabelEpilogue : public KviKvsTreeNodeSpecialCommandDefpopupLabel
{
protected:
	TQString m_szInstruction;
public:
	KviKvsTreeNodeSpecialCommandDefpopupLabelEpilogue(const TQChar * pLocation,const TQString &szInstruction,const TQString &szItemName)
		: KviKvsTreeNodeSpecialCommandDefpopupLabel(pLocation,szItemName), m_szInstruction(szInstruction){};
	~KviKvsTreeNodeSpecialCommandDefpopupLabelEpilogue(){};
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c,KviKvsPopupMenu * p);
};


class KVIRC_API KviKvsTreeNodeSpecialCommandDefpopupLabelPopup : public KviKvsTreeNodeSpecialCommandDefpopupConditionalLabelWithTextAndIcon
{
public:
	KviKvsTreeNodeSpecialCommandDefpopupLabelPopup(const TQChar * pLocation);
	~KviKvsTreeNodeSpecialCommandDefpopupLabelPopup();
protected:
	KviPointerList<KviKvsTreeNodeSpecialCommandDefpopupLabel> * m_pLabels;
public:
	bool isEmpty(){ return m_pLabels->isEmpty(); };
	void addLabel(KviKvsTreeNodeSpecialCommandDefpopupLabel * pLabel);
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c,KviKvsPopupMenu * p);
	bool fill(KviKvsRunTimeContext * c,KviKvsPopupMenu * p);
};


class KVIRC_API KviKvsTreeNodeSpecialCommandDefpopup : public KviKvsTreeNodeSpecialCommand
{
public:
	KviKvsTreeNodeSpecialCommandDefpopup(const TQChar * pLocation,KviKvsTreeNodeData * pPopupName,KviKvsTreeNodeSpecialCommandDefpopupLabelPopup * pMainPopup);
	~KviKvsTreeNodeSpecialCommandDefpopup();
private:
	KviKvsTreeNodeData * m_pPopupName; // can't be zero
	KviKvsTreeNodeSpecialCommandDefpopupLabelPopup * m_pMainPopup;
public:
	virtual void contextDescription(TQString &szBuffer);
	virtual void dump(const char * prefix);
	virtual bool execute(KviKvsRunTimeContext * c);
};

#endif //!_KVI_KVS_TREENODE_SPECIALCOMMANDDEFPOPUP_H_
