/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef _READER_FACTORY_H_
#define _READER_FACTORY_H_

#include <tqobject.h>

#include "globals.h"
#include "reader.h"
#include "logMode.h"
#include "logFile.h"

#include "logLevel.h"

#include <kurl.h>

/**
 * @author Nicolas Ternisien
 */
class ReaderFactory {

	public:
		static Reader* createReader(LogMode* logMode);
		
		static LogFiles* createLogFiles(LogMode* logMode);

		//TODO Change this *BIG* hack to a well oriented object form
		static KURL lastOpenedURL;
		
	private:
		static LogFiles* getNoModeLogFiles(TQStringList& stringList);
		
		static LogFiles* getGenericLogFiles(TQStringList& stringList, TQValueList<int>& valueList);
		static LogFile* getGenericLogFile(TQString& file);
	
	
		/**
		 * Get System log files from configuration
		 */
		static LogFiles* getSystemLogFiles();
		
		/**
		 * Get X.org path from configuration
		 */
		static LogFiles* getXorgLogFiles();
		
		/**
		 * Get Kernel log files from configuration
		 */
		static LogFiles* getKernelLogFiles();
		
		/**
		 * Get Daemon log files from configuration
		 */
		static LogFiles* getDaemonLogFiles();
		
		/**
		 * Get Cron log files from configuration
		 */
		static LogFiles* getCronLogFiles();

		/**
		 * Get ACPID log files from configuration
		 */
		static LogFiles* getAcpidLogFiles();
		
		/**
		 * Get Cups log files from configuration
		 */
		static LogFiles* getCupsLogFiles();
		
		/**
		 * Get Cups Access log files from configuration
		 */
		static LogFiles* getCupsAccessLogFiles();
		
		/**
		 * Get Apache log files from configuration
		 */
		static LogFiles* getApacheLogFiles();
		
		/**
		 * Get Apache Access log files from configuration
		 */
		static LogFiles* getApacheAccessLogFiles();
		
		/**
		 * Get Mail log files from configuration
		 */
		static LogFiles* getMailLogFiles();
				
		/**
		 * Get Bool log file from configuration
		 */
		static LogFile* getBootLogFile();
		
		/**
		 * Get Authentication log file from configuration
		 */
		static LogFile* getAuthenticationLogFile();

		/**
		 * Get Samba path from configuration
		 */
		static LogFiles* getSambaLogFiles();

};


#endif
