/*
 *  Copyright (c) 2005 Boudewijn Rempt <boud@valdyas.org>
 *
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <tqwidget.h>
#include <tqdockwindow.h>
#include <tqvariant.h>
#include <tqlabel.h>
#include <tqtoolbutton.h>
#include <tqtabwidget.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>
#include <tqimage.h>
#include <tqpixmap.h>
#include <tqlayout.h>

#include <kdebug.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <tdeglobalsettings.h>
#include <tdeaccelmanager.h>
#include <tdeconfig.h>

#include <KoView.h>

#include "kopalette.h"

KoPalette::KoPalette(TQWidget * parent, const char * name)
    : TQDockWindow(parent, name)
{

#if TDE_VERSION >= TDE_MAKE_VERSION(3,3,90)
    TDEAcceleratorManager::setNoAccel(this);
#endif
    setCloseMode( TQDockWindow::Never);
    setResizeEnabled(true);
    setOpaqueMoving(true);
    setFocusPolicy(TQWidget::NoFocus);
    setVerticallyStretchable(false);
    setHorizontallyStretchable(false);

    setNewLine(true);
    layout() -> setSpacing(0);
    layout() -> setMargin(0);

    resetFont();
}

void KoPalette::resetFont()
{
            
    TDEConfig * cfg = TDEGlobal::config();
    Q_ASSERT(cfg);
    cfg->setGroup("");
    m_font  = TDEGlobalSettings::generalFont();
    float ps = TQMIN(9, TDEGlobalSettings::generalFont().pointSize() * 0.8);
    ps = cfg->readNumEntry("palettefontsize", (int)ps);
    if (ps < 6) ps = 6;
    m_font.setPointSize((int)ps);
    setFont(m_font);

}

KoPalette::~KoPalette()
{
}

void KoPalette::setMainWidget(TQWidget * widget)
{
    setWidget(widget);
    resize( TQSize(285, 233).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
    widget->setFont(m_font);
    m_page = widget;
}

#include "kopalette.moc"
