/***************************************************************************
             mpagedisplay.h  -  Kugar page display widget
             -------------------
   begin     : Sun Aug 15 1999
   copyright : (C) 1999 by Mutiny Bay Software
   email     : info@mutinybaysoftware.com
***************************************************************************/

#ifndef MPAGEDISPLAY_H
#define MPAGEDISPLAY_H

#include <tqwidget.h>
#include <tqpainter.h>
#include <tqpixmap.h>
#include <tqpicture.h>
#include <tqsize.h>

/**Kugar page display widget
  *@author Mutiny Bay Software
  */

namespace Kugar
{

class MPageDisplay : public TQWidget
{
    TQ_OBJECT
  
public:
    /** Constructor */
    MPageDisplay( TQWidget *parent = 0, const char *name = 0 );
    /** Destructor */
    virtual ~MPageDisplay();

private:
    /** Page Widget's image buffer */
    TQPixmap buffer;

public:
    /** Sets the page image */
    void setPage( TQPicture* image );
    /** Sets the page display dimensions */
    void setPageDimensions( TQSize size );

    TQSize sizeHint() const;
    TQSizePolicy sizePolicy() const;

protected:
    /** Page widget's's paint event */
    void paintEvent( TQPaintEvent* event );

};

}

#endif
