
/*

 $Id: configdlg.h 466447 2005-10-02 17:54:10Z zander $


 KCalc

 Copyright (C) Bernd Johannes Wuebben
               wuebben@math.cornell.edu
	       wuebben@kde.org

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.

 */


#ifndef _CONFIG_DLG_H_
#define _CONFIG_DLG_H_

#include <tqgroupbox.h>
#include <tqcheckbox.h>
#include <tqdialog.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqpainter.h>
#include <tqlabel.h>
#include <tqframe.h>
#include <tqspinbox.h>
#include <kcolorbutton.h>

#include "kcalc.h"



class ConfigDlg : public TQDialog {

TQ_OBJECT
  

public:

  ConfigDlg(TQWidget *parent=0, const char *name=0, DefStruct *defstruct=NULL);

  ~ConfigDlg() {}

  DefStruct *defst ;
  TQLineEdit *mail;
  TQLineEdit *print;


private slots:

  void okButton();
  void cancelbutton();
  void set_fore_color(const TQColor &);
  void set_background_color(const TQColor &);
  void help();

signals:
  void color_change();

public:
  bool colors_changed;

private:


  TQGroupBox *box;

  TQPushButton *ok;
  TQPushButton *cancel;

  TQLabel *label1;
  KColorButton *button1;

  TQLabel *label2;
  KColorButton *button2;

  TQLabel *label3;
  TQPushButton *button3;
  TQLabel *label5;

  TQGroupBox *gbox;
  TQCheckBox *cb;
  TQCheckBox *cb2;
  TQSpinBox* precspin;
  TQSpinBox* precspin2;
  TQCheckBox *mybox;
  TQCheckBox *frame3d;

  TQButtonGroup *stylegroup;
  TQLabel *stylelabel;
  TQRadioButton *trigstyle;
  TQRadioButton *statstyle;
  TQRadioButton *sheetstyle;
};
#endif

