/* This file is part of the KDE project

   Copyright 2002-2003 Joseph Wenninger <jowenn@kde.org>
   Copyright 2002 Ariya Hidayat <ariya@kde.org>
   Copyright 2002 Philipp Mueller <philipp.mueller@gmx.de>
   Copyright 2001 David Faure <faure@kde.org
   Copyright 2001 Simon Hausmann <hausmann@kde.org>
   Copyright 1999-2001 Laurent Montel <montel@kde.org>
   Copyright 1999 Torben Weis <weis@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.

*/

#ifndef KSPREAD_CELL_IFACE_H
#define KSPREAD_CELL_IFACE_H

#include <tqstringlist.h>

#include <dcopobject.h>

class TQPoint;

namespace KSpread
{
class Sheet;

class CellIface : virtual public DCOPObject
{
    K_DCOP
public:
    CellIface();

    void setCell( Sheet* sheet, const TQPoint& point );
k_dcop:

    virtual bool isDefault() const;
    virtual bool isEmpty() const;
    virtual TQString text() const;
    virtual void setText( const TQString& text );
    virtual void setValue( int value );
    virtual void setValue( double value );
    virtual double value() const;
    virtual TQString visibleContentAsString() const;
    virtual void setBgColor(const TQString& _c);
    virtual void setBgColor(int r,int g,int b);
    virtual TQString bgColor() const;
    virtual void setTextColor(const TQString& _c);
    virtual void setTextColor(int r,int g,int b);
    virtual TQString textColor()const ;
    virtual void setComment(const TQString &_comment);
    virtual TQString comment()const;
    virtual void setAngle(int angle);
    virtual int angle() const ;
    virtual void setVerticalText(bool _vertical);
    virtual bool verticalText() const ;
    virtual void setMultiRow(bool _multi);
    virtual bool multiRow() const;
    virtual void setAlign(const TQString &_align);
    virtual TQString align() const;
    virtual void setAlignY(const TQString &_alignY);
    virtual TQString alignY() const;
    virtual void setPrefix(const TQString &_prefix);
    virtual TQString prefix() const;
    virtual void setPostfix(const TQString &_postfix);
    virtual TQString postfix() const;
    /** @deprecated use setFormatType*/
    virtual void setFormatNumber(const TQString &ft) { setFormatType(ft); }
    virtual void setFormatType(const TQString &formatType);
    /** @deprecated use getFormatType */
    virtual TQString getFormatNumber() const { return getFormatType(); }
    virtual TQString getFormatType() const;
    virtual void setPrecision(int  _p);
    virtual int precision() const;
    //font
    virtual void setTextFontBold( bool _b );
    virtual bool textFontBold( ) const;
    virtual void setTextFontItalic( bool _b );
    virtual bool textFontItalic( ) const;
    virtual void setTextFontUnderline( bool _b );
    virtual bool textFontUnderline(  ) const;
    virtual void setTextFontStrike( bool _b );
    virtual bool textFontStrike( ) const;
    virtual void setTextFontSize( int _size );
    virtual int textFontSize() const;
    virtual void setTextFontFamily( const TQString& _font );
    virtual TQString textFontFamily() const;
    //border left
    virtual void setLeftBorderStyle( const TQString& _style );
    virtual void setLeftBorderColor(const TQString& _c);
    virtual void setLeftBorderColor(int r,int g,int b);
    virtual void setLeftBorderWidth( int _size );
    virtual int leftBorderWidth() const;
    virtual TQString leftBorderColor() const;
    virtual TQString leftBorderStyle() const;
    //border right
    virtual void setRightBorderStyle( const TQString& _style );
    virtual void setRightBorderColor(const TQString& _c);
    virtual void setRightBorderColor(int r,int g,int b);
    virtual void setRightBorderWidth( int _size );
    virtual int rightBorderWidth() const;
    virtual TQString rightBorderColor() const;
    virtual TQString rightBorderStyle() const;
    //border top
    virtual void setTopBorderStyle( const TQString& _style );
    virtual void setTopBorderColor(const TQString& _c);
    virtual void setTopBorderColor(int r,int g,int b);
    virtual void setTopBorderWidth( int _size );
    virtual int topBorderWidth() const;
    virtual TQString topBorderColor() const;
    virtual TQString topBorderStyle() const;
    //border bottom
    virtual void setBottomBorderStyle( const TQString& _style );
    virtual void setBottomBorderColor(const TQString& _c);
    virtual void setBottomBorderColor(int r,int g,int b);
    virtual void setBottomBorderWidth( int _size );
    virtual int bottomBorderWidth() const;
    virtual TQString bottomBorderColor() const;
    virtual TQString bottomBorderStyle() const;
    // fall back diagonal
    virtual void setFallDiagonalStyle( const TQString& _style );
    virtual void setFallDiagonalColor(const TQString& _c);
    virtual void setFallDiagonalColor(int r,int g,int b);
    virtual void setFallDiagonalWidth( int _size );
    virtual int fallDiagonalWidth() const;
    virtual TQString fallDiagonalColor() const;
    virtual TQString fallDiagonalStyle() const;
    //GoUpDiagonal
    virtual void setGoUpDiagonalStyle( const TQString& _style );
    virtual void setGoUpDiagonalColor(const TQString& _c);
    virtual void setGoUpDiagonalColor(int r,int g,int b);
    virtual void setGoUpDiagonalWidth( int _size );
    virtual int goUpDiagonalWidth() const;
    virtual TQString goUpDiagonalColor() const;
    virtual TQString goUpDiagonalStyle() const;
    //indent
    virtual void setIndent(double indent);
    virtual double getIndent() const ;
    //don't print text
    virtual void setDontPrintText ( bool _b);
    virtual bool getDontprintText() const ;

    virtual bool hasValidation() const;
    virtual void removeValidity();
    virtual TQString validationTitle() const;
    virtual TQString validationMessage() const;
    virtual bool displayValidationMessage() const;
    virtual bool validationAllowEmptyCell() const;
    virtual bool displayValidationInformation() const;
    virtual TQStringList listValidation() const;

    virtual TQString validationTitleInfo() const;
    virtual TQString validationMessageInfo() const;

private:
    TQPoint m_point;
    Sheet* m_sheet;
};

} // namespace KSpread

#endif
