/* This file is part of the KDE project
   Copyright (C) 2002, The Karbon Developers

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __VSTATEBUTTON_H__
#define __VSTATEBUTTON_H__

#include <tqpushbutton.h>
#include <tqpixmap.h>
#include <tqptrlist.h>

class VStateButton : public TQPushButton
{
public:
	VStateButton( TQWidget* parent = 0L, const char* name = 0L );
	~VStateButton();

	void addState( TQPixmap *state ) { m_pixmaps.append( state ); }
	void setState( unsigned int index );
	unsigned int getState() const { return m_index; }

private:
	void mouseReleaseEvent( TQMouseEvent * );

	TQPtrList<TQPixmap> m_pixmaps;
	unsigned int m_index;
};

#endif

