/* SectionStyle: Stores (and writes) section-based information (e.g.: a column
 * break needs a new section) that is needed at the head of an OO document and
 * is referenced throughout the entire document
 *
 * Copyright (C) 2002-2003 William Lachance (william.lachance@sympatico.ca)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * For further information visit http://libwpd.sourceforge.net
 *
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */
#include <config.h>

#include "FilterInternal.h"
#include "PageSpan.h"
#include "DocumentElement.h"


PageSpan::PageSpan(const _SH_PropertyList &xPropList) :
#if 0
const int iSpan, const float fFormLength, const float fFormWidth, const WPXFormQt::Orientation fFormQt::Orientation,
                   const float fLeftMargin, const float fRightMargin, const float fTopMargin, const float fBottomMargin):
	miSpan(iSpan),
	mfFormLength(fFormLength),
	mfFormWidth(fFormWidth),
	mfFormQt::Orientation(fFormQt::Orientation),
	mfMarginLeft(fLeftMargin),
	mfMarginRight(fRightMargin),
	mfMarginTop(fTopMargin),
	mfMarginBottom(fBottomMargin),
#endif
        mxPropList(xPropList),
	mpHeaderContent(NULL),
	mpFooterContent(NULL),
	mpHeaderLeftContent(NULL),
	mpFooterLeftContent(NULL)
{
}

PageSpan::~PageSpan()
{
	delete mpHeaderContent;
	delete mpHeaderLeftContent;
	delete mpFooterContent;
	delete mpFooterLeftContent;
}

int PageSpan::getSpan() const
{
        if (mxPropList["libwpd:num-pages"])
                return mxPropList["libwpd:num-pages"]->getInt();

        return 0; // should never happen
}

float PageSpan::getMarginLeft() const
{
        if (mxPropList["fo:margin-left"])
#if defined(HAVE_LIBWPD_090) || defined(HAVE_LIBWPD_0100)
                return mxPropList["fo:margin-left"]->getDouble();
#else
                return mxPropList["fo:margin-left"]->getFloat();
#endif

         return 0.0f;
}

float PageSpan::getMarginRight() const
{
        if (mxPropList["fo:margin-right"])
#if defined(HAVE_LIBWPD_090) || defined(HAVE_LIBWPD_0100)
                return mxPropList["fo:margin-right"]->getDouble();
#else
                return mxPropList["fo:margin-right"]->getFloat();
#endif

         return 0.0f;
}

void PageSpan::writePageMaster(const int iNum, DocumentHandler &xHandler) const
{
        _SH_PropertyList propList;

	_SH_String sPageMasterName;
        sPageMasterName.sprintf("PM%i", iNum+2);
        propList.insert("style:name", sPageMasterName);
	xHandler.startElement("style:page-master", propList);

	_SH_PropertyList tempPropList = mxPropList;
	if (!tempPropList["style:writing-mode"])
		tempPropList.insert("style:writing-mode", _SH_String("lr-tb"));
	if (!tempPropList["style:footnote-max-height"])
		tempPropList.insert("style:footnote-max-height", _SH_String("0inch"));
        xHandler.startElement("style:properties", tempPropList);

	_SH_PropertyList footnoteSepPropList;
	footnoteSepPropList.insert("style:width", _SH_String("0.0071inch"));
	footnoteSepPropList.insert("style:distance-before-sep", _SH_String("0.0398inch"));
	footnoteSepPropList.insert("style:distance-after-sep", _SH_String("0.0398inch"));
	footnoteSepPropList.insert("style:adjustment", _SH_String("left"));
	footnoteSepPropList.insert("style:rel-width", _SH_String("25\%"));
	footnoteSepPropList.insert("style:color", _SH_String("#000000"));
	xHandler.startElement("style:footnote-sep", footnoteSepPropList);

	xHandler.endElement("style:footnote-sep");
        xHandler.endElement("style:properties");
        xHandler.endElement("style:page-master");
}

void PageSpan::writeMasterPages(const int iStartingNum, const int iPageMasterNum, const bool bLastPageSpan,
                                DocumentHandler &xHandler) const
{
        _SH_PropertyList propList; // scratch space

	int iSpan = 0;
	(bLastPageSpan) ? iSpan = 1 : iSpan = getSpan();

	for (int i=iStartingNum; i<(iStartingNum+iSpan); i++)
	{
		TagOpenElement masterPageOpen("style:master-page");
		_SH_String sMasterPageName;
		sMasterPageName.sprintf("Page Style %i", i);
		_SH_String sPageMasterName;
		sPageMasterName.sprintf("PM%i", iPageMasterNum+2);
                propList.insert("style:name", sMasterPageName);
		propList.insert("style:page-master-name", sPageMasterName);
		if (!bLastPageSpan)
		{
			_SH_String sNextMasterPageName;
			sNextMasterPageName.sprintf("Page Style %i", (i+1));
                        propList.insert("style:next-style-name", sNextMasterPageName);
		}
                xHandler.startElement("style:master-page", propList);

		if (mpHeaderContent)
			_writeHeaderFooter("style:header", *mpHeaderContent, xHandler);
		if (mpHeaderLeftContent)
			_writeHeaderFooter("style:header-left", *mpHeaderLeftContent, xHandler);
		if (mpFooterContent)
			_writeHeaderFooter("style:footer", *mpFooterContent, xHandler);
		if (mpFooterLeftContent)
			_writeHeaderFooter("style:footer-left", *mpFooterLeftContent, xHandler);

                xHandler.endElement("style:master-page");
	}

}

void PageSpan::_writeHeaderFooter(const char *headerFooterTagName,
				  const std::vector<DocumentElement *> & headerFooterContent,
				  DocumentHandler &xHandler) const
{
	TagOpenElement headerFooterOpen(headerFooterTagName);
	headerFooterOpen.write(xHandler);
	for (std::vector<DocumentElement *>::const_iterator iter = headerFooterContent.begin();
	     iter != headerFooterContent.end();
	     iter++) {
		(*iter)->write(xHandler);
	}
	TagCloseElement headerFooterClose(headerFooterTagName);
	headerFooterClose.write(xHandler);
}

