/* 
 * perftest.h -- Part of Chalk
 *
 * Copyright (c) 2005 Boudewijn Rempt <boud@valdyas.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef PERFTEST_H_
#define PERFTEST_H_

#include <tdeparts/plugin.h>
#include <kis_types.h>
#include <kis_global.h>

class KisView;
class KisID;

class PerfTest : public KParts::Plugin
{
    TQ_OBJECT
  
public:
    PerfTest(TQObject *parent, const char *name, const TQStringList &);
    virtual ~PerfTest();
    
private slots:

    void slotPerfTest();

private:

    TQString bltTest(TQ_UINT32 testCount);
    TQString fillTest(TQ_UINT32 testCount);
    TQString gradientTest(TQ_UINT32 testCount);
    TQString pixelTest(TQ_UINT32 testCount);
    TQString shapeTest(TQ_UINT32 testCount);
    TQString layerTest(TQ_UINT32 testCount);
    TQString scaleTest(TQ_UINT32 testCount);
    TQString rotateTest(TQ_UINT32 testCount);
    TQString renderTest(TQ_UINT32 restCount);
    TQString selectionTest(TQ_UINT32 testCount);
    TQString colorConversionTest(TQ_UINT32 testCount);
    TQString filterTest(TQ_UINT32 testCount);
    TQString readBytesTest(TQ_UINT32 testCount);
    TQString writeBytesTest(TQ_UINT32 testCount);
    TQString iteratorTest(TQ_UINT32 testCount);
    TQString paintViewTest(TQ_UINT32 testCount);
    TQString paintViewFPSTest();

    TQString doBlit(const KisCompositeOp& op, 
               KisID cspace,
               TQ_UINT8 opacity,
               TQ_UINT32 testCount,
               KisImageSP img);

private:

    KisView * m_view;
    KisPainter * m_painter;

};

#endif // PERFTEST_H_
